/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Iterator;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractAstFunctionChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.model.cfg.ICfgData;
import org.eclipse.cdt.codan.core.model.cfg.IControlFlowGraph;
import org.eclipse.cdt.codan.core.model.cfg.IExitNode;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLambdaExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.core.resources.IResource;

public class ReturnChecker
extends AbstractAstFunctionChecker {
    public static final String PARAM_IMPLICIT = "implicit";
    public static final String RET_NO_VALUE_ID = "org.eclipse.cdt.codan.checkers.noreturn";
    public static final String RET_ERR_VALUE_ID = "org.eclipse.cdt.codan.checkers.errreturnvalue";
    public static final String RET_NORET_ID = "org.eclipse.cdt.codan.checkers.errnoreturn";

    public boolean isConstructorDestructor(IASTFunctionDefinition func) {
        IBinding method;
        return func instanceof ICPPASTFunctionDefinition && ((method = func.getDeclarator().getName().resolveBinding()) instanceof ICPPConstructor || method instanceof ICPPMethod && ((ICPPMethod)method).isDestructor());
    }

    public boolean isMain(IASTFunctionDefinition func) {
        try {
            String functionName = func.getDeclarator().getName().getRawSignature();
            if (functionName.equals("main")) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected void processFunction(IASTFunctionDefinition func) {
        IASTStatement body;
        boolean nonVoid;
        if (func.getParent() instanceof ICPPASTTemplateDeclaration) {
            return;
        }
        ReturnStmpVisitor visitor = new ReturnStmpVisitor(func);
        func.accept((ASTVisitor)visitor);
        boolean bl = nonVoid = !this.isVoid(func);
        if (nonVoid && !this.isMain(func) && (body = func.getBody()) instanceof IASTCompoundStatement) {
            IASTStatement[] statements = ((IASTCompoundStatement)body).getStatements();
            if (statements.length > 0) {
                IASTStatement last = statements[statements.length - 1];
                while (last instanceof IASTLabelStatement) {
                    last = ((IASTLabelStatement)last).getNestedStatement();
                }
                if (this.isCompoundStatement(last)) {
                    if (this.endsWithNoExitNode(func)) {
                        this.reportNoRet(func, visitor.hasret);
                    }
                } else if (!this.isFuncExitStatement(last)) {
                    this.reportNoRet(func, visitor.hasret);
                }
            } else {
                this.reportNoRet(func, false);
            }
        }
    }

    protected void reportNoRet(IASTFunctionDefinition func, boolean hasRet) {
        if (!hasRet) {
            if (!this.checkImplicitReturn(RET_NORET_ID) && !this.isExplicitReturn(func)) {
                return;
            }
            if (this.isConstructorDestructor(func)) {
                return;
            }
        }
        this.reportProblem(RET_NORET_ID, (IASTNode)func.getDeclSpecifier(), new Object[0]);
    }

    private boolean isCompoundStatement(IASTStatement last) {
        return last instanceof IASTIfStatement || last instanceof IASTWhileStatement || last instanceof IASTDoStatement || last instanceof IASTForStatement || last instanceof IASTSwitchStatement || last instanceof IASTCompoundStatement || last instanceof ICPPASTTryBlockStatement;
    }

    protected boolean isFuncExitStatement(IASTStatement statement) {
        return statement instanceof IASTReturnStatement || CxxAstUtils.isThrowStatement((IASTNode)statement) || CxxAstUtils.isExitStatement((IASTNode)statement);
    }

    protected boolean checkImplicitReturn(String id) {
        IProblem pt = this.getProblemById(id, (IResource)this.getFile());
        return (Boolean)this.getPreference(pt, PARAM_IMPLICIT);
    }

    protected boolean endsWithNoExitNode(IASTFunctionDefinition func) {
        IControlFlowGraph graph = this.getModelCache().getControlFlowGraph(func);
        Iterator exitNodeIterator = graph.getExitNodeIterator();
        boolean noexitop = false;
        while (exitNodeIterator.hasNext()) {
            IExitNode node = (IExitNode)exitNodeIterator.next();
            if (((ICfgData)node).getData() != null) continue;
            noexitop = true;
            break;
        }
        return noexitop;
    }

    protected boolean isExplicitReturn(IASTFunctionDefinition func) {
        return this.getDeclSpecType(func) != 0;
    }

    public boolean isVoid(IASTFunctionDefinition func) {
        IASTFunctionDeclarator declarator;
        int type = this.getDeclSpecType(func);
        return type == 1 ? (declarator = func.getDeclarator()).getPointerOperators().length == 0 : type == 10 && this.isAutoVoid(func);
    }

    public boolean isVoid(IType type) {
        if (type instanceof IBasicType) {
            try {
                if (((IBasicType)type).getType() == 1) {
                    return true;
                }
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        return false;
    }

    protected int getDeclSpecType(IASTFunctionDefinition func) {
        IBinding binding;
        IType utype;
        IASTDeclSpecifier declSpecifier = func.getDeclSpecifier();
        int type = -1;
        if (declSpecifier instanceof IASTSimpleDeclSpecifier) {
            type = ((IASTSimpleDeclSpecifier)declSpecifier).getType();
        } else if (declSpecifier instanceof IASTNamedTypeSpecifier && this.isVoid(utype = CxxAstUtils.unwindTypedef((IType)((IType)(binding = ((IASTNamedTypeSpecifier)declSpecifier).getName().resolveBinding()))))) {
            return 1;
        }
        return type;
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        if (problem.getId().equals(RET_NO_VALUE_ID) || problem.getId().equals(RET_NORET_ID)) {
            this.addPreference(problem, PARAM_IMPLICIT, CheckersMessages.ReturnChecker_Param0, Boolean.FALSE);
        }
    }

    private boolean isAutoVoid(IASTFunctionDefinition functionDefinition) {
        IASTDeclarator abstractDeclarator;
        ICPPASTFunctionDeclarator functionDeclarator;
        IASTTypeId trailingReturnType;
        IASTFunctionDeclarator declarator = functionDefinition.getDeclarator();
        if (declarator instanceof ICPPASTFunctionDeclarator && (trailingReturnType = (functionDeclarator = (ICPPASTFunctionDeclarator)declarator).getTrailingReturnType()) != null && (abstractDeclarator = trailingReturnType.getAbstractDeclarator()) != null) {
            ICPPASTSimpleDeclSpecifier simpleDeclSpecifier;
            if (abstractDeclarator.getPointerOperators().length > 0) {
                return false;
            }
            IASTDeclSpecifier declSpecifier = trailingReturnType.getDeclSpecifier();
            if (declSpecifier instanceof ICPPASTSimpleDeclSpecifier && (simpleDeclSpecifier = (ICPPASTSimpleDeclSpecifier)declSpecifier).getType() == 1) {
                return true;
            }
        }
        return false;
    }

    class ReturnStmpVisitor
    extends ASTVisitor {
        private final IASTFunctionDefinition func;
        boolean hasret;

        ReturnStmpVisitor(IASTFunctionDefinition func) {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.func = func;
            this.hasret = false;
        }

        public int visit(IASTDeclaration element) {
            if (element != this.func) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTExpression expr) {
            if (expr instanceof ICPPASTLambdaExpression) {
                return 1;
            }
            return 3;
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTReturnStatement) {
                boolean hasValue;
                IASTReturnStatement ret = (IASTReturnStatement)stmt;
                boolean bl = hasValue = ret.getReturnArgument() != null;
                if (!this.hasret && hasValue) {
                    this.hasret = true;
                }
                if (!ReturnChecker.this.isVoid(this.func) && !ReturnChecker.this.isConstructorDestructor(this.func)) {
                    if ((ReturnChecker.this.checkImplicitReturn(ReturnChecker.RET_NO_VALUE_ID) || ReturnChecker.this.isExplicitReturn(this.func)) && !hasValue) {
                        ReturnChecker.this.reportProblem(ReturnChecker.RET_NO_VALUE_ID, (IASTNode)ret, new Object[0]);
                    }
                } else if (hasValue) {
                    IType type = ret.getReturnValue().getExpressionType();
                    if (ReturnChecker.this.isVoid(type)) {
                        return 1;
                    }
                    ReturnChecker.this.reportProblem(ReturnChecker.RET_ERR_VALUE_ID, (IASTNode)ret.getReturnValue(), new Object[0]);
                }
                return 1;
            }
            return 3;
        }
    }
}

