/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IModificationStatus;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ConverterInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.ModificationStatus;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;

class ToolInfo {
    private ITool fResultingTool;
    private ITool fInitialTool;
    private ITool fBaseTool;
    private ITool fRealTool;
    private IResourceInfo fRcInfo;
    private int fFlag;
    private ToolInfo fCorInfo;
    private ConverterInfo fConverterInfo;
    private IModificationStatus fModificationStatus;
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int REMAINED = 4;

    ToolInfo(IResourceInfo rcInfo, ITool tool, int flag) {
        this.fRcInfo = rcInfo;
        this.updateInitialTool(tool);
        this.fFlag = flag;
    }

    private static ITool calculateBaseTool(IResourceInfo rcInfo, ITool tool) {
        ITool baseTool = null;
        if (tool.isExtensionElement()) {
            if (rcInfo instanceof IFolderInfo) {
                ((IFolderInfo)rcInfo).getToolChain();
            } else {
                IFolderInfo foInfo = ((ResourceConfiguration)rcInfo).getParentFolderInfo();
                foInfo.getToolChain();
            }
            ITool realTool = ManagedBuildManager.getRealTool(tool);
            if (realTool == null) {
                baseTool = tool;
            } else if (baseTool == null) {
                baseTool = tool;
            }
        } else if (rcInfo != tool.getParentResourceInfo()) {
            baseTool = tool;
        }
        return baseTool;
    }

    public int getType() {
        return this.fFlag;
    }

    public ITool getRealTool() {
        if (this.fRealTool == null) {
            ITool baseTool = this.getBaseTool();
            this.fRealTool = ManagedBuildManager.getRealTool(baseTool);
            if (this.fRealTool == null) {
                this.fRealTool = this.fBaseTool;
            }
        }
        return this.fRealTool;
    }

    void updateInitialTool(ITool tool) {
        if (this.fInitialTool == tool) {
            return;
        }
        this.fResultingTool = null;
        this.fRealTool = null;
        this.fInitialTool = tool;
        this.fModificationStatus = null;
        this.fBaseTool = ToolInfo.calculateBaseTool(this.fRcInfo, tool);
    }

    public ITool getBaseTool() {
        if (this.fBaseTool == null) {
            this.fBaseTool = ManagedBuildManager.getExtensionTool(this.fInitialTool);
            if (this.fBaseTool == null) {
                this.fBaseTool = this.fInitialTool;
            }
        }
        return this.fBaseTool;
    }

    public ITool getBaseExtensionTool() {
        ITool tool = this.getBaseTool();
        return ManagedBuildManager.getExtensionTool(tool);
    }

    public ITool getInitialTool() {
        return this.fInitialTool;
    }

    public IModificationStatus getModificationStatus() {
        if (this.fModificationStatus == null) {
            this.getResultingTool();
        }
        return this.fModificationStatus;
    }

    public ITool getResultingTool() {
        switch (this.fFlag) {
            case 1: {
                if (this.fResultingTool == null || this.fResultingTool.getParentResourceInfo() != this.fRcInfo) {
                    Tool result = null;
                    ModificationStatus status = null;
                    if (this.fConverterInfo != null) {
                        IBuildObject resultBo = this.fConverterInfo.getConvertedFromObject();
                        if (!(resultBo instanceof Tool)) {
                            status = new ModificationStatus(ManagedMakeMessages.getString("ToolInfo.0"));
                        } else {
                            result = (Tool)resultBo;
                            status = ModificationStatus.OK;
                        }
                    }
                    if (status != ModificationStatus.OK) {
                        ITool baseTool = this.getBaseTool();
                        if (this.fRcInfo instanceof IFolderInfo) {
                            IFolderInfo foInfo = (IFolderInfo)this.fRcInfo;
                            if (baseTool.isExtensionElement()) {
                                result = new Tool((ToolChain)foInfo.getToolChain(), baseTool, ManagedBuildManager.calculateChildId(baseTool.getId(), null), baseTool.getName(), false);
                            } else {
                                ITool extTool = ManagedBuildManager.getExtensionTool(baseTool);
                                result = new Tool((IBuildObject)foInfo.getToolChain(), extTool, ManagedBuildManager.calculateChildId(extTool.getId(), null), baseTool.getName(), (Tool)baseTool);
                            }
                        } else {
                            ResourceConfiguration fiInfo = (ResourceConfiguration)this.fRcInfo;
                            if (baseTool.isExtensionElement()) {
                                result = new Tool(fiInfo, baseTool, ManagedBuildManager.calculateChildId(baseTool.getId(), null), baseTool.getName(), false);
                            } else {
                                ITool extTool = ManagedBuildManager.getExtensionTool(baseTool);
                                result = new Tool((IBuildObject)fiInfo, extTool, ManagedBuildManager.calculateChildId(extTool.getId(), null), baseTool.getName(), (Tool)baseTool);
                            }
                        }
                        if (status == null) {
                            status = ModificationStatus.OK;
                        }
                    }
                    result.updateParentResourceInfo(this.fRcInfo);
                    this.fResultingTool = result;
                    this.fModificationStatus = status;
                }
                return this.fResultingTool;
            }
            case 2: {
                this.fModificationStatus = new ModificationStatus(ManagedMakeMessages.getString("ToolInfo.1"));
                return null;
            }
        }
        if (this.fResultingTool == null) {
            this.fModificationStatus = ModificationStatus.OK;
            this.fResultingTool = this.fInitialTool;
        }
        return this.fResultingTool;
    }

    void setConversionInfo(ToolInfo corInfo, ConverterInfo converterInfo) {
        this.fCorInfo = corInfo;
        this.fConverterInfo = converterInfo;
    }
}

