/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.RunControl;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.IDPrintf;
import org.eclipse.tcf.services.IDiagnostics;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.services.ISymbols;

class TestExpressions
implements ITCFTest,
IRunControl.RunControlListener,
IExpressions.ExpressionsListener,
IBreakpoints.BreakpointsListener {
    private final TCFTestSuite test_suite;
    private final RunControl test_rc;
    private final IDiagnostics srv_diag;
    private final IExpressions srv_expr;
    private final ISymbols srv_syms;
    private final IStackTrace srv_stk;
    private final IRunControl srv_rc;
    private final IBreakpoints srv_bp;
    private final IDPrintf srv_dprintf;
    private final IStreams srv_streams;
    private final Random rnd = new Random();
    private String test_id;
    private String bp_id;
    private boolean bp_ok;
    private IDiagnostics.ISymbol sym_func3;
    private String test_ctx_id;
    private String process_id;
    private String thread_id;
    private boolean run_to_bp_done;
    private boolean loc_info_done;
    private boolean no_cpp;
    private boolean dprintf_done;
    private boolean test_done;
    private boolean cancel_test_sent;
    private IRunControl.RunControlContext test_ctx;
    private IRunControl.RunControlContext thread_ctx;
    private String suspended_pc;
    private boolean waiting_suspend;
    private String[] stack_trace;
    private IStackTrace.StackTraceContext[] stack_frames;
    private String[] local_var_expr_ids;
    private final Set<IToken> cmds = new HashSet<IToken>();
    private final Map<String, String> global_var_ids = new HashMap<String, String>();
    private final Map<String, String> local_var_ids = new HashMap<String, String>();
    private final Map<String, SymbolLocation> global_var_location = new HashMap<String, SymbolLocation>();
    private final Map<String, SymbolLocation> local_var_location = new HashMap<String, SymbolLocation>();
    private final Map<String, IExpressions.Expression> expr_ctx = new HashMap<String, IExpressions.Expression>();
    private final Map<String, IExpressions.Value> expr_val = new HashMap<String, IExpressions.Value>();
    private final Map<String, ISymbols.Symbol> expr_sym = new HashMap<String, ISymbols.Symbol>();
    private final Map<String, String[]> expr_chld = new HashMap<String, String[]>();
    private final Set<String> expr_to_dispose = new HashSet<String>();
    private int timer = 0;
    private static String[] global_var_names = new String[]{"tcf_test_char", "tcf_test_short", "tcf_test_long", "tcf_cpp_test_bool"};
    private static final String[] test_expressions = new String[]{"func2_local1", "func2_local2", "func2_local3", "func2_local1 == func2_local1", "func2_local1 != func2_local2", "1.34 == 1.34", "1.34 != 1.35", "1 ? 1 : 0", "!func2_local1 ? 0 : 1", "(0 || 0) == 0", "(0 || func2_local1) == 1", "(func2_local1 || 0) == 1", "(func2_local1 || func2_local1) == 1", "(0 && 0) == 0", "(0 && func2_local1) == 0", "(func2_local1 && 0) == 0", "(func2_local1 && func2_local1) == 1", "(func2_local1 | func2_local2) == 3", "(func2_local1 & func2_local2) == 0", "(func2_local1 ^ func2_local2) == 3", "(func2_local1 < func2_local2)", "(func2_local1 <= func2_local2)", "!(func2_local1 > func2_local2)", "!(func2_local1 >= func2_local2)", "(func2_local1 < 1.1)", "(func2_local1 <= 1.1)", "!(func2_local1 > 1.1)", "!(func2_local1 >= 1.1)", "(func2_local2 << 2) == 8", "(func2_local2 >> 1) == 1", "+func2_local2 == 2", "-func2_local2 == -2", "(short)(int)(long)((char *)func2_local2 + 1) == 3", "((func2_local1 + func2_local2) * 2 - 2) / 2 == 2", "func2_local3.f_struct->f_struct->f_struct == &func2_local3", "(char *)func2_local3.f_struct", "(char[4])func2_local3.f_struct", "&((test_struct *)0)->f_float", "&((struct test_struct *)0)->f_float", "tcf_test_func3", "&tcf_test_func3", "tcf_test_array + 10", "*(tcf_test_array + 10) | 1", "&*(char *)(int *)0 == 0", "(bool)0 == false", "(bool)1 == true", "sizeof(bool) == sizeof true", "tcf_cpp_test_class::s_int == 1", "sizeof tcf_cpp_test_class::s_int == sizeof signed", "tcf_cpp_test_class::tcf_cpp_test_class_nested::s_int == 2", "tcf_cpp_test_class_extension::tcf_cpp_test_class_nested::s_int == 2", "enum_val1 == 1 && enum_val2 == 2 && enum_val3 == 3"};
    private static final String[] test_dprintfs;

    static {
        String[] stringArray = new String[22];
        stringArray[0] = "$printf";
        stringArray[2] = "$printf(";
        stringArray[4] = "$printf()";
        stringArray[6] = "$printf(1)";
        stringArray[8] = "$printf(\"abc\")";
        stringArray[9] = "abc";
        stringArray[10] = "$printf(\"%s\",\"abc\")";
        stringArray[11] = "abc";
        stringArray[12] = "$printf(\"%d\",1)";
        stringArray[13] = "1";
        stringArray[14] = "$printf(\"%d\",enum_val2)";
        stringArray[15] = "2";
        stringArray[16] = "$printf(\"%u\",func2_local3.f_enum)";
        stringArray[17] = "3";
        stringArray[18] = "$printf(\"%g\",func2_local3.f_float)";
        stringArray[19] = "3.14";
        stringArray[20] = "$printf(\"%g\",func2_local3.f_double)";
        stringArray[21] = "2.71";
        test_dprintfs = stringArray;
    }

    TestExpressions(TCFTestSuite test_suite, RunControl test_rc, IChannel channel) {
        this.test_suite = test_suite;
        this.test_rc = test_rc;
        this.srv_diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
        this.srv_expr = (IExpressions)channel.getRemoteService(IExpressions.class);
        this.srv_syms = (ISymbols)channel.getRemoteService(ISymbols.class);
        this.srv_stk = (IStackTrace)channel.getRemoteService(IStackTrace.class);
        this.srv_rc = (IRunControl)channel.getRemoteService(IRunControl.class);
        this.srv_bp = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
        this.srv_dprintf = (IDPrintf)channel.getRemoteService(IDPrintf.class);
        this.srv_streams = (IStreams)channel.getRemoteService(IStreams.class);
    }

    @Override
    public void start() {
        if (this.srv_diag == null || this.srv_expr == null || this.srv_stk == null || this.srv_rc == null || this.srv_bp == null) {
            this.test_suite.done(this, null);
        } else {
            this.srv_expr.addListener((IExpressions.ExpressionsListener)this);
            this.srv_rc.addListener((IRunControl.RunControlListener)this);
            this.srv_bp.addListener((IBreakpoints.BreakpointsListener)this);
            this.srv_diag.getTestList(new IDiagnostics.DoneGetTestList(){

                public void doneGetTestList(IToken token, Throwable error, String[] list) {
                    if (!TestExpressions.this.test_suite.isActive(TestExpressions.this)) {
                        return;
                    }
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else {
                        if (list.length > 0) {
                            TestExpressions.this.test_id = list[TestExpressions.this.rnd.nextInt(list.length)];
                            TestExpressions.this.runTest();
                            Protocol.invokeLater((long)100L, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (!TestExpressions.this.test_suite.isActive(TestExpressions.this)) {
                                        return;
                                    }
                                    TestExpressions testExpressions = TestExpressions.this;
                                    testExpressions.timer = testExpressions.timer + 1;
                                    if (((TestExpressions)(this).TestExpressions.this).test_suite.cancel) {
                                        TestExpressions.this.exit(null);
                                    } else if (TestExpressions.this.timer < 600) {
                                        if (TestExpressions.this.test_done && !TestExpressions.this.cancel_test_sent) {
                                            TestExpressions.this.test_rc.cancel(TestExpressions.this.test_ctx_id);
                                            TestExpressions.this.cancel_test_sent = true;
                                        }
                                        Protocol.invokeLater((long)100L, (Runnable)this);
                                    } else if (TestExpressions.this.test_ctx_id == null) {
                                        TestExpressions.this.exit(new Error("Timeout waiting for reply of Diagnostics.runTest command"));
                                    } else {
                                        TestExpressions.this.exit(new Error("Missing 'contextRemoved' event for " + TestExpressions.this.test_ctx_id));
                                    }
                                }
                            });
                            return;
                        }
                        TestExpressions.this.exit(null);
                    }
                }
            });
        }
    }

    @Override
    public boolean canResume(String id) {
        if (this.test_ctx_id != null && this.thread_ctx == null) {
            return false;
        }
        if (this.thread_ctx != null && !this.test_done) {
            assert (this.thread_ctx.getID().equals(this.thread_id));
            IRunControl.RunControlContext ctx = this.test_rc.getContext(id);
            if (ctx == null) {
                return false;
            }
            String grp = ctx.getRCGroup();
            if (id.equals(this.thread_id) || grp != null && grp.equals(this.thread_ctx.getRCGroup())) {
                BigInteger pc1;
                if (this.run_to_bp_done) {
                    return false;
                }
                if (this.sym_func3 == null) {
                    return false;
                }
                if (this.suspended_pc == null) {
                    return false;
                }
                BigInteger pc0 = JSON.toBigInteger((Number)this.sym_func3.getValue());
                if (pc0.equals(pc1 = new BigInteger(this.suspended_pc))) {
                    return false;
                }
            }
        }
        return true;
    }

    private void runTest() {
        String id2;
        this.timer = 0;
        if (this.cmds.size() > 0) {
            return;
        }
        if (this.bp_id == null) {
            this.srv_bp.set(null, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else {
                        TestExpressions.this.bp_id = "TestExpressionsBP";
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (!this.bp_ok) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("ID", this.bp_id);
            m.put("Enabled", Boolean.TRUE);
            m.put("Location", "tcf_test_func3");
            this.srv_bp.set(new Map[]{m}, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else {
                        TestExpressions.this.bp_ok = true;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.test_ctx_id == null) {
            this.srv_diag.runTest(this.test_id, new IDiagnostics.DoneRunTest(){

                public void doneRunTest(IToken token, Throwable error, String id) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (id == null) {
                        TestExpressions.this.exit(new Exception("Test context ID must not be null"));
                    } else if (TestExpressions.this.test_rc.getContext(id) == null) {
                        TestExpressions.this.exit(new Exception("Missing context added event"));
                    } else {
                        TestExpressions.this.test_ctx_id = id;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.test_ctx == null) {
            this.srv_rc.getContext(this.test_ctx_id, new IRunControl.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext ctx) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (ctx == null) {
                        TestExpressions.this.exit(new Exception("Invalid test execution context"));
                    } else {
                        TestExpressions.this.test_ctx = ctx;
                        TestExpressions.this.process_id = TestExpressions.this.test_ctx.getProcessID();
                        if (TestExpressions.this.test_ctx.hasState()) {
                            TestExpressions.this.thread_id = TestExpressions.this.test_ctx_id;
                        }
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.thread_id == null) {
            this.srv_rc.getChildren(this.process_id, new IRunControl.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] ids) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (ids == null || ids.length == 0) {
                        TestExpressions.this.exit(new Exception("Test process has no threads"));
                    } else if (ids.length != 1) {
                        TestExpressions.this.exit(new Exception("Test process has too many threads"));
                    } else {
                        TestExpressions.this.thread_id = ids[0];
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.thread_ctx == null) {
            this.srv_rc.getContext(this.thread_id, new IRunControl.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext ctx) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (ctx == null || !ctx.hasState()) {
                        TestExpressions.this.exit(new Exception("Invalid thread context"));
                    } else {
                        TestExpressions.this.thread_ctx = ctx;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.suspended_pc == null) {
            this.thread_ctx.getState(new IRunControl.DoneGetState(){

                public void doneGetState(IToken token, Exception error, boolean suspended, String pc, String reason, Map<String, Object> params) {
                    if (error != null) {
                        TestExpressions.this.exit(new Exception("Cannot get context state", error));
                    } else if (!suspended) {
                        TestExpressions.this.waiting_suspend = true;
                    } else if (pc == null || pc.length() == 0 || pc.equals("0")) {
                        TestExpressions.this.exit(new Exception("Invalid context PC"));
                    } else {
                        TestExpressions.this.suspended_pc = pc;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.sym_func3 == null) {
            this.srv_diag.getSymbol(this.process_id, "tcf_test_func3", new IDiagnostics.DoneGetSymbol(){

                public void doneGetSymbol(IToken token, Throwable error, IDiagnostics.ISymbol symbol) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (symbol == null) {
                        TestExpressions.this.exit(new Exception("Symbol must not be null: tcf_test_func3"));
                    } else {
                        TestExpressions.this.sym_func3 = symbol;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (!this.run_to_bp_done) {
            BigInteger pc1;
            BigInteger pc0 = JSON.toBigInteger((Number)this.sym_func3.getValue());
            if (!pc0.equals(pc1 = new BigInteger(this.suspended_pc))) {
                this.waiting_suspend = true;
                return;
            }
            this.run_to_bp_done = true;
        }
        assert (this.test_done || !this.canResume(this.thread_id));
        if (this.stack_trace == null) {
            this.srv_stk.getChildren(this.thread_id, new IStackTrace.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (context_ids == null || context_ids.length < 2) {
                        TestExpressions.this.exit(new Exception("Invalid stack trace"));
                    } else {
                        TestExpressions.this.stack_trace = context_ids;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.stack_frames == null) {
            this.srv_stk.getContext(this.stack_trace, new IStackTrace.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, IStackTrace.StackTraceContext[] frames) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (frames == null || frames.length != TestExpressions.this.stack_trace.length) {
                        TestExpressions.this.exit(new Exception("Invalid stack trace"));
                    } else {
                        TestExpressions.this.stack_frames = frames;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.local_var_expr_ids == null) {
            this.srv_expr.getChildren(this.stack_trace[this.stack_trace.length - 2], new IExpressions.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                    if (error != null || context_ids == null) {
                        TestExpressions.this.local_var_expr_ids = new String[0];
                        TestExpressions.this.runTest();
                    } else {
                        TestExpressions.this.local_var_expr_ids = context_ids;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        String[] stringArray = this.local_var_expr_ids;
        int n = this.local_var_expr_ids.length;
        int n2 = 0;
        while (n2 < n) {
            id2 = stringArray[n2];
            if (this.expr_ctx.get(id2) == null) {
                this.srv_expr.getContext(id2, new IExpressions.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IExpressions.Expression ctx) {
                        if (error != null) {
                            TestExpressions.this.exit(error);
                        } else {
                            TestExpressions.this.expr_ctx.put(id2, ctx);
                            TestExpressions.this.local_var_ids.put(id2, ctx.getSymbolID());
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            ++n2;
        }
        if (this.srv_syms != null && this.local_var_expr_ids.length > 0) {
            stringArray = global_var_names;
            n = global_var_names.length;
            n2 = 0;
            while (n2 < n) {
                final String nm = stringArray[n2];
                if (!this.global_var_ids.containsKey(nm)) {
                    this.srv_syms.find(this.process_id, (Number)new BigInteger(this.suspended_pc), nm, new ISymbols.DoneFind(){

                        public void doneFind(IToken token, Exception error, String symbol_id) {
                            if (error != null) {
                                if (nm.startsWith("tcf_cpp_") && error instanceof IErrorReport && ((IErrorReport)error).getErrorCode() == 22) {
                                    TestExpressions.this.global_var_ids.put(nm, null);
                                    TestExpressions.this.no_cpp = true;
                                    TestExpressions.this.runTest();
                                    return;
                                }
                                TestExpressions.this.exit(error);
                            } else if (symbol_id == null) {
                                TestExpressions.this.exit(new Exception("Invalid symbol ID"));
                            } else {
                                TestExpressions.this.global_var_ids.put(nm, symbol_id);
                                TestExpressions.this.runTest();
                            }
                        }
                    });
                    return;
                }
                ++n2;
            }
        }
        if (this.srv_syms != null && !this.loc_info_done) {
            for (final String id2 : this.global_var_ids.values()) {
                if (id2 == null || this.global_var_location.get(id2) != null) continue;
                this.srv_syms.getLocationInfo(id2, new ISymbols.DoneGetLocationInfo(){

                    public void doneGetLocationInfo(IToken token, Exception error, Map<String, Object> props) {
                        SymbolLocation l = new SymbolLocation();
                        l.error = error;
                        l.props = props;
                        TestExpressions.this.global_var_location.put(id2, l);
                        if (error != null) {
                            if (error instanceof IErrorReport && ((IErrorReport)error).getErrorCode() == 25) {
                                TestExpressions.this.runTest();
                                return;
                            }
                            TestExpressions.this.exit(error);
                        } else if (props == null) {
                            TestExpressions.this.exit(new Exception("Invalid symbol location info: props = null"));
                        } else {
                            List cmds = (List)props.get("ValueCmds");
                            if (cmds == null || cmds.size() == 0) {
                                TestExpressions.this.exit(new Exception("Invalid symbol location info: ValueCmds = null"));
                            } else {
                                TestExpressions.this.runTest();
                            }
                        }
                    }
                });
                return;
            }
            for (final String id2 : this.local_var_ids.values()) {
                if (id2 == null || this.local_var_location.get(id2) != null) continue;
                this.srv_syms.getLocationInfo(id2, new ISymbols.DoneGetLocationInfo(){

                    public void doneGetLocationInfo(IToken token, Exception error, Map<String, Object> props) {
                        SymbolLocation l = new SymbolLocation();
                        l.error = error;
                        l.props = props;
                        TestExpressions.this.local_var_location.put(id2, l);
                        List cmds = (List)props.get("ValueCmds");
                        if (error != null) {
                            if (error instanceof IErrorReport && ((IErrorReport)error).getErrorCode() == 25) {
                                TestExpressions.this.runTest();
                                return;
                            }
                            TestExpressions.this.exit(error);
                        } else if (cmds == null || cmds.size() == 0) {
                            TestExpressions.this.exit(new Exception("Invalid symbol location info"));
                        } else {
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            this.loc_info_done = true;
        }
        stringArray = test_expressions;
        n = test_expressions.length;
        int n3 = 0;
        while (n3 < n) {
            final String txt = stringArray[n3];
            if ((this.local_var_expr_ids.length != 0 || txt.indexOf("func2_local") < 0 && txt.indexOf("test_struct") < 0 && txt.indexOf("tcf_test_array") < 0 && txt.indexOf("(char *)") < 0 && txt.indexOf("enum_val") < 0) && (this.local_var_expr_ids.length != 0 && !this.no_cpp || txt.indexOf("tcf_cpp_test") < 0 && txt.indexOf("(bool)") < 0) && this.expr_ctx.get(txt) == null) {
                this.srv_expr.create(this.stack_trace[this.stack_trace.length - 2], null, txt, new IExpressions.DoneCreate(){

                    public void doneCreate(IToken token, Exception error, IExpressions.Expression ctx) {
                        if (error != null) {
                            TestExpressions.this.exit(error);
                        } else {
                            TestExpressions.this.expr_to_dispose.add(ctx.getID());
                            TestExpressions.this.expr_ctx.put(txt, ctx);
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            ++n3;
        }
        stringArray = this.local_var_expr_ids;
        n = this.local_var_expr_ids.length;
        n3 = 0;
        while (n3 < n) {
            id2 = stringArray[n3];
            if (this.expr_val.get(id2) == null) {
                this.srv_expr.evaluate(id2, new IExpressions.DoneEvaluate(){

                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value ctx) {
                        if (error != null) {
                            TestExpressions.this.exit(error);
                        } else {
                            TestExpressions.this.expr_val.put(id2, ctx);
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            ++n3;
        }
        for (final String id2 : this.expr_ctx.keySet()) {
            if (this.expr_val.get(id2) != null) continue;
            this.srv_expr.evaluate(this.expr_ctx.get(id2).getID(), new IExpressions.DoneEvaluate(){

                public void doneEvaluate(IToken token, Exception error, IExpressions.Value ctx) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else {
                        TestExpressions.this.expr_val.put(id2, ctx);
                        byte[] arr = ctx.getValue();
                        boolean b = false;
                        byte[] byArray = arr;
                        int n = arr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte x = byArray[n2];
                            if (x != 0) {
                                b = true;
                            }
                            ++n2;
                        }
                        if (!b) {
                            TestExpressions.this.exit(new Exception("Invalid value of expression \"" + id2 + "\""));
                        }
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.srv_syms != null) {
            for (final String id2 : this.expr_val.keySet()) {
                IExpressions.Value v;
                String type_id;
                if (this.expr_sym.get(id2) != null || (type_id = (v = this.expr_val.get(id2)).getTypeID()) == null) continue;
                this.srv_syms.getContext(type_id, new ISymbols.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, ISymbols.Symbol ctx) {
                        if (error != null) {
                            TestExpressions.this.exit(error);
                        } else if (ctx == null) {
                            TestExpressions.this.exit(new Exception("Symbol.getContext returned null"));
                        } else {
                            TestExpressions.this.expr_sym.put(id2, ctx);
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            for (final String id2 : this.expr_sym.keySet()) {
                if (this.expr_chld.get(id2) != null) continue;
                ISymbols.Symbol sym = this.expr_sym.get(id2);
                this.srv_syms.getChildren(sym.getID(), new ISymbols.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                        if (error != null) {
                            TestExpressions.this.exit(error);
                        } else {
                            if (context_ids == null) {
                                context_ids = new String[]{};
                            }
                            TestExpressions.this.expr_chld.put(id2, context_ids);
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
        }
        if (this.srv_dprintf != null && !this.dprintf_done && this.local_var_expr_ids.length > 0) {
            this.cmds.add(this.srv_dprintf.open(null, new IDPrintf.DoneCommandOpen(){
                int test_cnt;
                int char_cnt;

                public void doneCommandOpen(IToken token, Exception error, final String id) {
                    TestExpressions.this.cmds.remove(token);
                    if (error != null) {
                        TestExpressions.this.exit(error);
                        return;
                    }
                    TestExpressions.this.cmds.add(TestExpressions.this.srv_streams.connect(id, new IStreams.DoneConnect(){

                        public void doneConnect(IToken token, Exception error) {
                            TestExpressions.this.cmds.remove(token);
                            if (error != null) {
                                TestExpressions.this.exit(error);
                                return;
                            }
                        }
                    }));
                    TestExpressions.this.cmds.add(TestExpressions.this.srv_streams.read(id, 256, new IStreams.DoneRead(){

                        public void doneRead(IToken token, Exception error, int lost_size, byte[] data, boolean eos) {
                            TestExpressions.this.cmds.remove(token);
                            if (error != null) {
                                TestExpressions.this.exit(error);
                                return;
                            }
                            if (eos) {
                                TestExpressions.this.exit(new Exception("Unexpected EOS"));
                                return;
                            }
                            byte[] byArray = data;
                            int n = data.length;
                            int n2 = 0;
                            while (n2 < n) {
                                byte b = byArray[n2];
                                while (test_dprintfs[test_cnt * 2 + 1] == null) {
                                    ++test_cnt;
                                }
                                char ch = test_dprintfs[test_cnt * 2 + 1].charAt(char_cnt++);
                                if (b != ch) {
                                    TestExpressions.this.exit(new Exception("Invalid ouptput of $printf"));
                                    return;
                                }
                                if (char_cnt == test_dprintfs[test_cnt * 2 + 1].length()) {
                                    char_cnt = 0;
                                    ++test_cnt;
                                }
                                ++n2;
                            }
                            if (test_cnt >= test_dprintfs.length / 2) {
                                TestExpressions.this.cmds.add(TestExpressions.this.srv_streams.disconnect(id, new IStreams.DoneDisconnect(){

                                    public void doneDisconnect(IToken token, Exception error) {
                                        TestExpressions.this.cmds.remove(token);
                                        if (error != null) {
                                            TestExpressions.this.exit(error);
                                            return;
                                        }
                                        TestExpressions.this.runTest();
                                    }
                                }));
                            } else {
                                TestExpressions.this.cmds.add(TestExpressions.this.srv_streams.read(id, 256, (IStreams.DoneRead)this));
                            }
                        }
                    }));
                    int n = 0;
                    while (n < test_dprintfs.length) {
                        String txt = test_dprintfs[n];
                        final String res = test_dprintfs[n + 1];
                        TestExpressions.this.cmds.add(TestExpressions.this.srv_expr.create(TestExpressions.this.stack_trace[TestExpressions.this.stack_trace.length - 2], null, txt, new IExpressions.DoneCreate(){

                            public void doneCreate(IToken token, Exception error, IExpressions.Expression ctx) {
                                TestExpressions.this.cmds.remove(token);
                                if (error != null) {
                                    if (res != null) {
                                        TestExpressions.this.exit(error);
                                    }
                                } else {
                                    if (res == null) {
                                        TestExpressions.this.exit(new Exception("Expressions service was expected to return error"));
                                    }
                                    TestExpressions.this.expr_to_dispose.add(ctx.getID());
                                    TestExpressions.this.cmds.add(TestExpressions.this.srv_expr.evaluate(ctx.getID(), new IExpressions.DoneEvaluate(){

                                        public void doneEvaluate(IToken token, Exception error, IExpressions.Value value) {
                                            TestExpressions.this.cmds.remove(token);
                                            if (error != null) {
                                                TestExpressions.this.exit(error);
                                                return;
                                            }
                                        }
                                    }));
                                }
                            }
                        }));
                        n += 2;
                    }
                }
            }));
            this.dprintf_done = true;
            return;
        }
        Iterator<String> iterator = this.expr_to_dispose.iterator();
        if (iterator.hasNext()) {
            id2 = iterator.next();
            this.srv_expr.dispose(id2, new IExpressions.DoneDispose(){

                public void doneDispose(IToken token, Exception error) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else {
                        TestExpressions.this.expr_to_dispose.remove(id2);
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        this.test_done = true;
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        this.srv_expr.removeListener((IExpressions.ExpressionsListener)this);
        this.srv_bp.removeListener((IBreakpoints.BreakpointsListener)this);
        this.srv_rc.removeListener((IRunControl.RunControlListener)this);
        this.test_suite.done(this, x);
    }

    public void containerResumed(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.contextResumed(id);
            ++n2;
        }
    }

    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        String[] stringArray = suspended_ids;
        int n = suspended_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.contextSuspended(id, null, null, null);
            ++n2;
        }
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
    }

    public void contextException(String context, String msg) {
        if (this.test_done) {
            return;
        }
        IRunControl.RunControlContext ctx = this.test_rc.getContext(context);
        if (ctx != null) {
            String p = ctx.getParentID();
            String c = ctx.getCreatorID();
            if (!this.test_ctx_id.equals(c) && !this.test_ctx_id.equals(p)) {
                return;
            }
        }
        this.exit(new Exception("Context exception: " + msg));
    }

    public void contextRemoved(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(this.test_ctx_id)) {
                if (this.test_done) {
                    this.srv_bp.set(null, new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            TestExpressions.this.exit(error);
                        }
                    });
                } else {
                    this.exit(new Exception("Test process exited too soon"));
                }
                return;
            }
            ++n2;
        }
    }

    public void contextResumed(String id) {
        if (id.equals(this.thread_id)) {
            if (this.run_to_bp_done && !this.test_done) {
                assert (this.thread_ctx != null);
                assert (!this.canResume(this.thread_id));
                this.exit(new Exception("Unexpected contextResumed event: " + id));
            }
            this.suspended_pc = null;
        }
    }

    public void contextSuspended(String id, String pc, String reason, Map<String, Object> params) {
        assert (id != null);
        if (id.equals(this.thread_id) && this.waiting_suspend) {
            this.suspended_pc = pc;
            this.waiting_suspend = false;
            this.runTest();
        }
    }

    public void valueChanged(String id) {
    }

    public void breakpointStatusChanged(String id, Map<String, Object> status) {
        if (id.equals(this.bp_id) && this.process_id != null && !this.test_done) {
            Collection list;
            String s = (String)status.get("Error");
            if (s != null) {
                this.exit(new Exception("Invalid BP status: " + s));
            }
            if ((list = (Collection)status.get("Instances")) == null) {
                return;
            }
            String err = null;
            for (Map map : list) {
                String ctx = (String)map.get("LocationContext");
                if (!this.process_id.equals(ctx) || map.get("Error") == null) continue;
                err = (String)map.get("Error");
            }
            if (err != null) {
                this.exit(new Exception("Invalid BP status: " + err));
            }
        }
    }

    public void contextAdded(Map<String, Object>[] bps) {
    }

    public void contextChanged(Map<String, Object>[] bps) {
    }

    private static class SymbolLocation {
        Exception error;
        Map<String, Object> props;

        private SymbolLocation() {
        }
    }
}

