/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.tabs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.tcf.te.ui.terminals.tabs.TabCommandFieldHandler;
import org.eclipse.tcf.te.ui.terminals.tabs.TabFolderManager;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;

public class TabTerminalListener
implements ITerminalListener {
    final TabFolderManager tabFolderManager;
    private final CTabItem tabItem;
    private final String tabItemTitle;

    public TabTerminalListener(TabFolderManager tabFolderManager, CTabItem tabItem) {
        Assert.isNotNull((Object)((Object)tabFolderManager));
        this.tabFolderManager = tabFolderManager;
        Assert.isNotNull((Object)tabItem);
        this.tabItem = tabItem;
        this.tabItemTitle = tabItem.getText();
    }

    protected final CTabItem getTabItem() {
        return this.tabItem;
    }

    public void setState(final TerminalState state) {
        final CTabItem item = this.getTabItem();
        if (item == null || item.isDisposed()) {
            return;
        }
        item.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String newTitle = TabTerminalListener.this.getTerminalConsoleTabTitle(state);
                if (newTitle != null) {
                    item.setText(newTitle);
                }
                TabCommandFieldHandler handler = TabTerminalListener.this.tabFolderManager.getTabCommandFieldHandler(item);
                if (TerminalState.CLOSED.equals(state) && handler != null && handler.hasCommandInputField()) {
                    handler.setCommandInputField(false);
                    ISelectionProvider provider = TabTerminalListener.this.tabFolderManager.getParentView().getViewSite().getSelectionProvider();
                    Assert.isNotNull((Object)provider);
                    provider.setSelection(provider.getSelection());
                } else {
                    TabTerminalListener.this.tabFolderManager.updateStatusLine();
                }
            }
        });
    }

    protected String getTerminalConsoleTabTitle(TerminalState state) {
        Assert.isNotNull((Object)state);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        CTabItem item = this.getTabItem();
        if (item == null || item.isDisposed()) {
            return null;
        }
        String oldTitle = item.getText();
        String newTitle = null;
        if (TerminalState.CLOSED.equals(state)) {
            newTitle = NLS.bind((String)Messages.TabTerminalListener_consoleClosed, (Object)this.tabItemTitle, (Object)this.tabFolderManager.state2msg(item, state));
        } else if (TerminalState.CONNECTING.equals(state)) {
            newTitle = NLS.bind((String)Messages.TabTerminalListener_consoleConnecting, (Object)this.tabItemTitle, (Object)this.tabFolderManager.state2msg(item, state));
        } else if (TerminalState.CONNECTED.equals(state)) {
            newTitle = this.tabItemTitle;
        }
        return newTitle != null && !newTitle.equals(oldTitle) ? newTitle : null;
    }

    public void setTerminalTitle(String title) {
    }
}

