/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.streams;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.terminals.streams.OutputStreamMonitor;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;

public class StreamsSettings {
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private boolean localEcho = true;
    private String lineSeparator = null;
    private OutputStreamMonitor.Listener[] stdoutListeners = null;
    private OutputStreamMonitor.Listener[] stderrListeners = null;

    public void setStdinStream(OutputStream stdin) {
        this.stdin = stdin;
    }

    public OutputStream getStdinStream() {
        return this.stdin;
    }

    public void setStdoutStream(InputStream stdout) {
        this.stdout = stdout;
    }

    public InputStream getStdoutStream() {
        return this.stdout;
    }

    public void setStderrStream(InputStream stderr) {
        this.stderr = stderr;
    }

    public InputStream getStderrStream() {
        return this.stderr;
    }

    public void setLocalEcho(boolean value) {
        this.localEcho = value;
    }

    public boolean isLocalEcho() {
        return this.localEcho;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setStdOutListeners(OutputStreamMonitor.Listener[] listeners) {
        this.stdoutListeners = listeners;
    }

    public OutputStreamMonitor.Listener[] getStdOutListeners() {
        return this.stdoutListeners;
    }

    public void setStdErrListeners(OutputStreamMonitor.Listener[] listeners) {
        this.stderrListeners = listeners;
    }

    public OutputStreamMonitor.Listener[] getStdErrListeners() {
        return this.stderrListeners;
    }

    public void load(ISettingsStore store) {
        Assert.isNotNull((Object)store);
        this.localEcho = Boolean.parseBoolean(store.get("LocalEcho", Boolean.FALSE.toString()));
        this.lineSeparator = store.get("LineSeparator", null);
        if (store instanceof IPropertiesContainer) {
            this.stdin = (OutputStream)((IPropertiesContainer)store).getProperty("stdin");
            this.stdout = (InputStream)((IPropertiesContainer)store).getProperty("stdout");
            this.stderr = (InputStream)((IPropertiesContainer)store).getProperty("stderr");
            this.stdoutListeners = (OutputStreamMonitor.Listener[])((IPropertiesContainer)store).getProperty("StdOutListeners");
            this.stderrListeners = (OutputStreamMonitor.Listener[])((IPropertiesContainer)store).getProperty("StdErrListeners");
        }
    }

    public void save(ISettingsStore store) {
        Assert.isNotNull((Object)store);
        store.put("LocalEcho", Boolean.toString(this.localEcho));
        store.put("LineSeparator", this.lineSeparator);
        if (store instanceof IPropertiesContainer) {
            ((IPropertiesContainer)store).setProperty("stdin", (Object)this.stdin);
            ((IPropertiesContainer)store).setProperty("stdout", (Object)this.stdout);
            ((IPropertiesContainer)store).setProperty("stderr", (Object)this.stderr);
            ((IPropertiesContainer)store).setProperty("StdOutListeners", (Object)this.stdoutListeners);
            ((IPropertiesContainer)store).setProperty("StdErrListeners", (Object)this.stderrListeners);
        }
    }
}

