/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.commands;

import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IDisassembly;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataDisassembleInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MIDataDisassemble
extends MICommand<MIDataDisassembleInfo> {
    private static final int MIN_MODE = 0;
    private static final int MAX_MODE = 3;
    private static final String MODE_OUT_OF_RANGE = "Mode out of range: ";

    public MIDataDisassemble(IDisassembly.IDisassemblyDMContext ctx, String start, String end, boolean mode) {
        this(ctx, start, end, mode ? 1 : 0);
    }

    public MIDataDisassemble(IDisassembly.IDisassemblyDMContext ctx, String start, String end, int mode) {
        super((IDMContext)ctx, "-data-disassemble");
        this.setOptions(new String[]{"-s", start, "-e", end});
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException(MODE_OUT_OF_RANGE + mode);
        }
        this.setParameters(new String[]{Integer.toString(mode)});
    }

    public MIDataDisassemble(IDisassembly.IDisassemblyDMContext ctx, String file, int linenum, int lines, boolean mode) {
        this(ctx, file, linenum, lines, mode ? 1 : 0);
    }

    public MIDataDisassemble(IDisassembly.IDisassemblyDMContext ctx, String file, int linenum, int lines, int mode) {
        super((IDMContext)ctx, "-data-disassemble");
        this.setOptions(new String[]{"-f", file, "-l", Integer.toString(linenum), "-n", Integer.toString(lines)});
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException(MODE_OUT_OF_RANGE + mode);
        }
        this.setParameters(new String[]{Integer.toString(mode)});
    }

    @Override
    protected String parametersToString() {
        String[] parameters = this.getParameters();
        if (parameters != null && parameters.length > 0) {
            return "-- " + parameters[0];
        }
        return new String();
    }

    @Override
    public MIDataDisassembleInfo getResult(MIOutput output) {
        return new MIDataDisassembleInfo(output);
    }
}

