/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.controls.PeerNameControl;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.RegexValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.wizards.pages.AbstractFormsWizardPage;
import org.eclipse.ui.forms.IManagedForm;

public abstract class AbstractConfigWizardPage
extends AbstractFormsWizardPage
implements IDataExchangeNode {
    private ConfigNameControl configName = null;
    private AbstractSection selectorSection = null;
    private AbstractSection detailsSection = null;
    Button launchDbg = null;
    private Button advancedButton = null;
    boolean autoLaunchDbg = true;
    final List<String> usedNames = new ArrayList<String>();

    public AbstractConfigWizardPage(String pageName) {
        super(pageName);
    }

    public AbstractConfigWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void dispose() {
        if (this.configName != null) {
            this.configName.dispose();
            this.configName = null;
        }
        if (this.selectorSection != null) {
            this.selectorSection.dispose();
            this.selectorSection = null;
        }
        if (this.detailsSection != null) {
            this.detailsSection.dispose();
            this.detailsSection = null;
        }
        super.dispose();
    }

    protected void doCreateFormContent(Composite parent, CustomFormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        this.configName = new ConfigNameControl((IDialogPage)this);
        this.configName.setupPanel(parent);
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectorSection = this.doCreateSelectorSection(this.getManagedForm(), parent);
        if (this.selectorSection != null) {
            this.selectorSection.getSection().setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.detailsSection = this.doCreateDetailsSection(this.getManagedForm(), parent);
        if (this.detailsSection != null) {
            this.detailsSection.getSection().setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.launchDbg = new Button(parent, 32);
        this.launchDbg.setText(Messages.AbstractConfigWizardPage_launchDbg_label);
        this.launchDbg.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.launchDbg.setSelection(this.autoLaunchDbg);
        this.launchDbg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractConfigWizardPage.this.autoLaunchDbg = SWTControlUtil.getSelection((Button)AbstractConfigWizardPage.this.launchDbg);
            }
        });
        if (this.hasAdvancedButton()) {
            this.advancedButton = new Button(parent, 8);
            this.advancedButton.setText("  " + Messages.AbstractConfigWizardPage_advancedButton_label + "  ");
            this.advancedButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractConfigWizardPage.this.onAdvancedButtonSelected();
                }
            });
        }
        this.restoreWidgetValues();
        this.initializeUsedNameList();
    }

    protected abstract AbstractSection doCreateSelectorSection(IManagedForm var1, Composite var2);

    protected final AbstractSection getSelectorSection() {
        return this.selectorSection;
    }

    protected abstract AbstractSection doCreateDetailsSection(IManagedForm var1, Composite var2);

    protected final AbstractSection getDetailsSection() {
        return this.detailsSection;
    }

    protected boolean hasAdvancedButton() {
        return false;
    }

    protected void onAdvancedButtonSelected() {
    }

    protected abstract String getPeerType();

    protected abstract String getDefaultConfigNameTemplate();

    protected abstract String getDefaultConfigNamePattern(String var1);

    protected void initializeUsedNameList() {
        this.usedNames.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeerModel[] peers;
                IPeerModel[] iPeerModelArray = peers = Model.getModel().getPeers();
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerModel peerModel = iPeerModelArray[n2];
                    if (peerModel.isStatic()) {
                        String name = peerModel.getPeer().getName();
                        Assert.isNotNull((Object)name);
                        if (!"".equals(name) && !AbstractConfigWizardPage.this.usedNames.contains(name)) {
                            AbstractConfigWizardPage.this.usedNames.add(name.trim().toUpperCase());
                        }
                    }
                    ++n2;
                }
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
    }

    public void autoGenerateConfigurationName(String customID) {
        String origProposedName;
        String currentName;
        String template = this.getDefaultConfigNameTemplate();
        Assert.isNotNull((Object)template);
        String pattern = this.getDefaultConfigNamePattern(template);
        Assert.isNotNull((Object)pattern);
        String string = currentName = this.configName != null ? this.configName.getEditFieldControlText().trim() : null;
        if (currentName != null && !"".equals(currentName.trim()) && !currentName.matches(pattern)) {
            return;
        }
        String proposedName = origProposedName = NLS.bind((String)template, (Object)(customID != null ? customID : ""));
        int count = 0;
        while (this.usedNames.contains(proposedName.trim().toUpperCase())) {
            proposedName = String.valueOf(origProposedName.trim()) + " (" + ++count + ")";
        }
        if (this.configName != null) {
            this.configName.setEditFieldControlText(proposedName.trim());
        }
    }

    public final boolean isAutoStartDebugger() {
        return this.autoLaunchDbg;
    }

    protected IValidatingContainer.ValidationResult doValidate() {
        IValidatingContainer.ValidationResult result = new IValidatingContainer.ValidationResult();
        boolean valid = true;
        if (this.configName != null) {
            valid &= this.configName.isValid();
            result.setResult((IMessageProvider)this.configName);
        }
        if (this.selectorSection != null) {
            valid &= this.selectorSection.isValid();
            result.setResult((IMessageProvider)this.selectorSection);
        }
        if (this.detailsSection != null) {
            valid &= this.detailsSection.isValid();
            result.setResult((IMessageProvider)this.detailsSection);
        }
        result.setValid(valid);
        return result;
    }

    public void setupData(IPropertiesContainer data) {
    }

    protected void updatePeerAttributes(IPropertiesContainer peerAttributes) {
        String value;
        Assert.isNotNull((Object)peerAttributes);
        if (this.getControl() == null) {
            return;
        }
        String string = value = this.configName != null ? this.configName.getEditFieldControlText() : null;
        if (value != null && !"".equals(value)) {
            peerAttributes.setProperty("Name", (Object)value);
        }
        if (this.isAutoStartDebugger()) {
            peerAttributes.setProperty("autoStartDebugger", true);
        }
        if (this.selectorSection != null) {
            this.updateAttribute(this.selectorSection, peerAttributes);
        }
        if (this.detailsSection != null) {
            this.updateAttribute(this.detailsSection, peerAttributes);
        }
    }

    protected abstract void updateAttribute(AbstractSection var1, IPropertiesContainer var2);

    public void extractData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        this.updatePeerAttributes(data);
    }

    public void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.selectorSection != null) {
                this.selectorSection.saveWidgetValues(settings);
            }
            if (this.detailsSection != null) {
                this.detailsSection.saveWidgetValues(settings);
            }
        }
    }

    public void restoreWidgetValues() {
        super.restoreWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.selectorSection != null) {
                this.selectorSection.restoreWidgetValues(settings);
            }
            if (this.detailsSection != null) {
                this.detailsSection.restoreWidgetValues(settings);
            }
        }
    }

    protected static class ConfigNameControl
    extends PeerNameControl {
        public ConfigNameControl(IDialogPage parentPage) {
            super(parentPage);
            this.setEditFieldLabel(Messages.AbstractConfigWizardPage_configName_label);
        }

        @Override
        protected Validator doCreateEditFieldValidator() {
            return new RegexValidator(1, ".*");
        }

        @Override
        protected void configureEditFieldValidator(Validator validator) {
            if (validator instanceof RegexValidator) {
                validator.setMessageText("RegexValidator_Information_MissingValue", Messages.AbstractConfigWizardPage_configName_infoMissingValue);
            }
        }

        public boolean isValid() {
            boolean valid = true;
            String name = this.getEditFieldControlTextForValidation();
            if (!"".equals(name) && this.getParentPage() instanceof AbstractConfigWizardPage) {
                boolean bl = valid = !((AbstractConfigWizardPage)this.getParentPage()).usedNames.contains(name.trim().toUpperCase());
                if (!valid) {
                    this.setMessage(Messages.AbstractConfigWizardPage_configName_nameInUse, 3);
                }
            }
            if (!valid && this.getControlDecoration() != null && this.isEnabled()) {
                this.updateControlDecoration(this.getMessage(), this.getMessageType());
            }
            return valid ? super.isValid() : false;
        }
    }
}

