/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.preferences;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.preferences.ScopedEclipsePreferences;
import org.eclipse.tcf.te.tcf.log.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LoggingPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor enabled;
    private BooleanFieldEditor monitorEnabled;
    private BooleanFieldEditor showHeartbeats;
    private BooleanFieldEditor showFrameworkEvents;
    private StringFieldEditor logfileSize;
    private IntegerFieldEditor filesInCycle;
    private IPreferenceStore store = new PreferenceStore(){

        public boolean needsSaving() {
            return false;
        }
    };

    public LoggingPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setFont(parent.getFont());
        Label label = new Label(panel, 256);
        label.setText(Messages.LoggingPreferencePage_label);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        this.createSpacer(panel, 2);
        this.enabled = new BooleanFieldEditor("te.tcf.log.core.enabled", Messages.LoggingPreferencePage_enabled_label, panel);
        this.addField((FieldEditor)this.enabled);
        this.monitorEnabled = new BooleanFieldEditor("te.tcf.log.core.monitor.enabled", Messages.LoggingPreferencePage_monitorEnabled_label, panel);
        this.addField((FieldEditor)this.monitorEnabled);
        this.createSpacer(panel, 2);
        Group filterGroup = new Group(panel, 0);
        filterGroup.setText(Messages.LoggingPreferencePage_filterGroup_label);
        filterGroup.setLayout((Layout)new GridLayout(2, false));
        filterGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite filterPanel = new Composite((Composite)filterGroup, 0);
        filterPanel.setLayout((Layout)new GridLayout());
        filterPanel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.showHeartbeats = new BooleanFieldEditor("te.tcf.log.core.show.heartbeats", Messages.LoggingPreferencePage_showHeartbeats_label, filterPanel);
        this.addField((FieldEditor)this.showHeartbeats);
        this.showFrameworkEvents = new BooleanFieldEditor("te.tcf.log.core.show.frameworkEvents", Messages.LoggingPreferencePage_showFrameworkEvents_label, filterPanel);
        this.addField((FieldEditor)this.showFrameworkEvents);
        this.createSpacer(panel, 2);
        Group logfileGroup = new Group(panel, 0);
        logfileGroup.setText(Messages.LoggingPreferencePage_logfileGroup_label);
        logfileGroup.setLayout((Layout)new GridLayout(2, false));
        logfileGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite logfilePanel = new Composite((Composite)logfileGroup, 0);
        logfilePanel.setLayout((Layout)new GridLayout());
        logfilePanel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.logfileSize = new LogfileSizeFieldEditor("te.tcf.log.core.limits.fileSize", Messages.LoggingPreferencePage_maxFileSize_label, logfilePanel);
        this.addField((FieldEditor)this.logfileSize);
        this.filesInCycle = new IntegerFieldEditor("te.tcf.log.core.limits.inCycle", Messages.LoggingPreferencePage_maxFilesInCycle_label, logfilePanel);
        this.addField((FieldEditor)this.filesInCycle);
    }

    protected void createSpacer(Composite parent, int columnSpan) {
        Assert.isNotNull((Object)parent);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        gd.heightHint = SWTControlUtil.convertHeightInCharsToPixels((Control)parent, (int)1) / 4;
        new Label(parent, 0).setLayoutData((Object)gd);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.store;
    }

    protected void initialize() {
        ScopedEclipsePreferences prefs = CoreBundleActivator.getScopedPreferences();
        this.store.setDefault("te.tcf.log.core.enabled", prefs.getDefaultBoolean("te.tcf.log.core.enabled"));
        this.store.setValue("te.tcf.log.core.enabled", prefs.getBoolean("te.tcf.log.core.enabled"));
        this.store.setDefault("te.tcf.log.core.monitor.enabled", prefs.getDefaultBoolean("te.tcf.log.core.monitor.enabled"));
        this.store.setValue("te.tcf.log.core.monitor.enabled", prefs.getBoolean("te.tcf.log.core.monitor.enabled"));
        this.store.setDefault("te.tcf.log.core.show.heartbeats", prefs.getDefaultBoolean("te.tcf.log.core.show.heartbeats"));
        this.store.setValue("te.tcf.log.core.show.heartbeats", prefs.getBoolean("te.tcf.log.core.show.heartbeats"));
        this.store.setDefault("te.tcf.log.core.show.frameworkEvents", prefs.getDefaultBoolean("te.tcf.log.core.show.frameworkEvents"));
        this.store.setValue("te.tcf.log.core.show.frameworkEvents", prefs.getBoolean("te.tcf.log.core.show.frameworkEvents"));
        this.store.setDefault("te.tcf.log.core.limits.fileSize", prefs.getDefaultString("te.tcf.log.core.limits.fileSize"));
        this.store.setValue("te.tcf.log.core.limits.fileSize", prefs.getString("te.tcf.log.core.limits.fileSize"));
        this.store.setDefault("te.tcf.log.core.limits.inCycle", prefs.getDefaultInt("te.tcf.log.core.limits.inCycle"));
        this.store.setValue("te.tcf.log.core.limits.inCycle", prefs.getInt("te.tcf.log.core.limits.inCycle"));
        super.initialize();
    }

    public boolean performOk() {
        boolean success = super.performOk();
        if (success) {
            ScopedEclipsePreferences prefs = CoreBundleActivator.getScopedPreferences();
            prefs.putBoolean("te.tcf.log.core.enabled", this.store.getBoolean("te.tcf.log.core.enabled"));
            prefs.putBoolean("te.tcf.log.core.monitor.enabled", this.store.getBoolean("te.tcf.log.core.monitor.enabled"));
            prefs.putBoolean("te.tcf.log.core.show.heartbeats", this.store.getBoolean("te.tcf.log.core.show.heartbeats"));
            prefs.putBoolean("te.tcf.log.core.show.frameworkEvents", this.store.getBoolean("te.tcf.log.core.show.frameworkEvents"));
            prefs.putString("te.tcf.log.core.limits.fileSize", this.store.getString("te.tcf.log.core.limits.fileSize"));
            prefs.putInt("te.tcf.log.core.limits.inCycle", this.store.getInt("te.tcf.log.core.limits.inCycle"));
        }
        return success;
    }

    private class LogfileSizeFieldEditor
    extends StringFieldEditor {
        private Pattern valid;

        public LogfileSizeFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.valid = Pattern.compile("0|[1-9][0-9]*[KMG]?");
            this.setEmptyStringAllowed(false);
            this.setTextLimit(6);
            this.setErrorMessage(Messages.LoggingPreferencePage_maxFileSize_error);
        }

        protected boolean doCheckState() {
            return this.valid.matcher(this.getStringValue()).matches();
        }
    }
}

