/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor.sections;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.editor.controls.InfoSectionPeerNameControl;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class GeneralInformationSection
extends AbstractSection {
    private InfoSectionPeerNameControl nameControl = null;
    private Text linkState = null;
    private Label linkStateImage = null;
    IPeerModel od;
    final IPropertiesContainer odc = new PropertiesContainer();
    final IPropertiesContainer wc = new PropertiesContainer();
    final List<String> usedNames = new ArrayList<String>();

    public GeneralInformationSection(IManagedForm form, Composite parent) {
        super(form, parent, 128);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public void dispose() {
        if (this.nameControl != null) {
            this.nameControl.dispose();
            this.nameControl = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (InfoSectionPeerNameControl.class.equals((Object)adapter)) {
            return this.nameControl;
        }
        return super.getAdapter(adapter);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.GeneralInformationSection_title);
        section.setDescription(Messages.GeneralInformationSection_description);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Composite client = this.createClientContainer((Composite)section, 2, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        this.nameControl = new InfoSectionPeerNameControl(this){

            public boolean isValid() {
                boolean valid = true;
                String name = this.getEditFieldControlTextForValidation();
                if (!"".equals(name)) {
                    boolean bl = valid = !this.infoSection.usedNames.contains(name.trim().toUpperCase());
                    if (!valid) {
                        this.setMessage(Messages.GeneralInformationSection_error_nameInUse, 3);
                    }
                }
                if (!valid && this.getControlDecoration() != null && this.isEnabled()) {
                    this.updateControlDecoration(this.getMessage(), this.getMessageType());
                }
                return valid ? super.isValid() : false;
            }
        };
        this.nameControl.setFormToolkit(toolkit);
        this.nameControl.setParentControlIsInnerPanel(true);
        this.nameControl.setupPanel(client);
        Label label = new Label(client, 256);
        label.setText(Messages.GeneralInformationSection_state);
        GridData layoutData = new GridData(16384, 128, false, false);
        layoutData.verticalIndent = 4;
        label.setLayoutData((Object)layoutData);
        Composite panel = new Composite(client, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        panel.setLayout((Layout)new GridLayout(2, false));
        layoutData = new GridData(4, 0x1000000, true, false);
        if (this.nameControl.getControlDecoration() != null) {
            layoutData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth() / 2;
        }
        panel.setLayoutData((Object)layoutData);
        this.linkStateImage = new Label(panel, 256);
        layoutData = new GridData(0x1000000, 128, false, false);
        layoutData.verticalIndent = 1;
        layoutData.widthHint = 10;
        this.linkStateImage.setLayoutData((Object)layoutData);
        this.linkState = new Text(panel, 74);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.heightHint = SWTControlUtil.convertHeightInCharsToPixels((Control)this.linkState, (int)2);
        this.linkState.setLayoutData((Object)layoutData);
        this.updateEnablement();
        this.setIsUpdating(false);
    }

    public void setActive(boolean active) {
        if (active) {
            Object node;
            if (this.getManagedForm().getContainer() instanceof AbstractEditorPage && !((AbstractEditorPage)this.getManagedForm().getContainer()).isDirty() && (node = ((AbstractEditorPage)this.getManagedForm().getContainer()).getEditorInputNode()) instanceof IPeerModel) {
                this.setupData((IPeerModel)node);
            }
        } else {
            this.dataChanged(null);
        }
    }

    public void setupData(final IPeerModel node) {
        if (this.isDirty()) {
            return;
        }
        boolean updateWidgets = true;
        if (node == null && this.od == null || node != null && node.equals(this.od)) {
            updateWidgets = false;
        }
        PropertiesContainer previousOdc = new PropertiesContainer();
        previousOdc.setProperties(this.odc.getProperties());
        this.od = node;
        this.odc.clearProperties();
        this.wc.clearProperties();
        if (node == null) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                GeneralInformationSection.this.odc.setProperty("state", node.getProperty("state"));
                GeneralInformationSection.this.odc.setProperty("ID", node.getPeer().getAttributes().get("ID"));
                GeneralInformationSection.this.odc.setProperty("Name", node.getPeer().getAttributes().get("Name"));
                GeneralInformationSection.this.wc.setProperties(GeneralInformationSection.this.odc.getProperties());
            }
        });
        if (!previousOdc.getProperties().equals(this.odc.getProperties())) {
            updateWidgets = true;
        }
        if (updateWidgets) {
            this.setIsUpdating(true);
            if (this.nameControl != null) {
                this.nameControl.setEditFieldControlText(this.wc.getStringProperty("Name"));
            }
            if (this.linkState != null && this.linkStateImage != null) {
                String state = this.wc.getStringProperty("state");
                this.linkState.setText(Messages.getString("GeneralInformationSection_state_" + (state != null ? state.replace('-', '_') : "_1")));
                switch (this.wc.getIntProperty("state")) {
                    case 0: {
                        this.linkStateImage.setImage(UIPlugin.getImage("GoldOverlay"));
                        break;
                    }
                    case 1: {
                        this.linkStateImage.setImage(UIPlugin.getImage("GreenOverlay"));
                        break;
                    }
                    case 2: {
                        this.linkStateImage.setImage(UIPlugin.getImage("RedOverlay"));
                        break;
                    }
                    case 3: {
                        this.linkStateImage.setImage(UIPlugin.getImage("RedXOverlay"));
                        break;
                    }
                    default: {
                        this.linkStateImage.setImage(UIPlugin.getImage("GreyOverlay"));
                    }
                }
            }
            this.setIsUpdating(false);
        }
        this.initializeUsedNameList();
        this.dataChanged(null);
        this.updateEnablement();
    }

    public void extractData(final IPeerModel node) {
        if (node == null) {
            return;
        }
        if (this.nameControl != null) {
            boolean used;
            String name = this.nameControl.getEditFieldControlText();
            boolean bl = used = name != null && this.usedNames.contains(name.trim().toUpperCase());
            if (!used && name != null && !"".equals(name.trim())) {
                this.wc.setProperty("Name", (Object)name);
            } else {
                String template = NLS.bind((String)Messages.OverviewEditorPage_error_save, (Object)this.wc.getStringProperty("Name"), (Object)Messages.PossibleCause);
                Status status = new Status(4, UIPlugin.getUniqueIdentifier(), used ? Messages.GeneralInformationSection_error_nameInUse : Messages.GeneralInformationSection_error_emptyName);
                StatusHandlerUtil.handleStatus((IStatus)status, (Object)this.od, (String)template, null, (String)IContextHelpIds.MESSAGE_SAVE_FAILED, (Object)((Object)this), null);
            }
        }
        if (!this.odc.getStringProperty("Name").equals(this.wc.getStringProperty("Name"))) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    IPeer oldPeer = node.getPeer();
                    HashMap<String, String> attributes = new HashMap<String, String>(oldPeer.getAttributes());
                    attributes.put("Name", GeneralInformationSection.this.wc.getStringProperty("Name"));
                    attributes.remove("URI.transient");
                    PeerRedirector newPeer = oldPeer instanceof PeerRedirector ? new PeerRedirector(((PeerRedirector)oldPeer).getParent(), attributes) : new Peer(attributes);
                    boolean changed = node.setChangeEventsEnabled(false);
                    node.setProperty("instance", (Object)newPeer);
                    if (changed) {
                        node.setChangeEventsEnabled(true);
                    }
                }
            });
        }
    }

    public boolean isValid() {
        if (this.isUpdating()) {
            return true;
        }
        boolean valid = super.isValid();
        if (this.nameControl != null) {
            valid &= this.nameControl.isValid();
            this.setMessage(this.nameControl.getMessage(), this.nameControl.getMessageType());
        }
        return valid;
    }

    public void commit(boolean onSave) {
        boolean needsSaving = this.isDirty();
        super.commit(onSave);
        if (!onSave || !needsSaving) {
            return;
        }
        String oldName = this.odc.getStringProperty("Name");
        this.extractData(this.od);
        if (!oldName.equals(this.wc.getStringProperty("Name"))) {
            try {
                IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                if (uRIPersistenceService == null) {
                    throw new IOException("Persistence service instance unavailable.");
                }
                HashMap<String, String> oldData = new HashMap<String, String>();
                for (String key : this.odc.getProperties().keySet()) {
                    oldData.put(key, this.odc.getStringProperty(key));
                }
                uRIPersistenceService.delete((Object)new Peer(oldData), null);
            }
            catch (IOException e) {
                String template = NLS.bind((String)Messages.GeneralInformationSection_error_delete, (Object)oldName, (Object)Messages.PossibleCause);
                StatusHandlerUtil.handleStatus((IStatus)StatusHelper.getStatus((Throwable)e), (Object)this.od, (String)template, null, (String)IContextHelpIds.MESSAGE_DELETE_FAILED, (Object)((Object)this), null);
            }
        }
    }

    public void dataChanged(TypedEvent e) {
        if (this.isUpdating()) {
            return;
        }
        boolean isDirty = false;
        if (this.nameControl != null) {
            String value;
            String name = this.nameControl.getEditFieldControlText();
            isDirty = "".equals(name) ? (isDirty |= (value = this.odc.getStringProperty("Name")) != null && !"".equals(value.trim())) : (isDirty |= !this.odc.isProperty("Name", (Object)name));
        }
        this.markDirty(isDirty);
    }

    protected void updateEnablement() {
        final Object input = this.getManagedForm().getInput();
        if (this.nameControl != null) {
            final AtomicBoolean isStatic = new AtomicBoolean();
            final AtomicBoolean isRemote = new AtomicBoolean();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (input instanceof IPeerModel) {
                        isStatic.set(((IPeerModel)input).isStatic());
                        isRemote.set(((IPeerModel)input).isRemote());
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            SWTControlUtil.setEnabled((Control)this.nameControl.getEditFieldControl(), (isStatic.get() && !isRemote.get() ? 1 : 0) != 0);
        }
    }

    protected void initializeUsedNameList() {
        this.usedNames.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeerModel[] peers;
                IPeerModel[] iPeerModelArray = peers = Model.getModel().getPeers();
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerModel peerModel = iPeerModelArray[n2];
                    if (peerModel.isStatic() && !peerModel.equals(GeneralInformationSection.this.od)) {
                        String name = peerModel.getPeer().getName();
                        Assert.isNotNull((Object)name);
                        if (!"".equals(name) && !GeneralInformationSection.this.usedNames.contains(name)) {
                            GeneralInformationSection.this.usedNames.add(name.trim().toUpperCase());
                        }
                    }
                    ++n2;
                }
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
    }
}

