/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.activator;

import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.async.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepperService;
import org.eclipse.tcf.te.runtime.stepper.job.StepperJob;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin {
    private static UIPlugin plugin;
    private IWorkbenchListener listener;
    final ListenerList listeners = new ListenerList();

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (UIPlugin.getDefault() != null && UIPlugin.getDefault().getBundle() != null) {
            return UIPlugin.getDefault().getBundle().getSymbolicName();
        }
        return "org.eclipse.tcf.te.tcf.ui";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.listener = new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                Object[] candidates;
                boolean proceedShutdown = true;
                Object[] objectArray = candidates = UIPlugin.this.listeners.getListeners();
                int n = candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    if (listener instanceof IWorkbenchListener && !(proceedShutdown &= ((IWorkbenchListener)listener).preShutdown(workbench, forced)) && !forced) break;
                    ++n2;
                }
                if (proceedShutdown || forced) {
                    final ILocatorModel model = Model.getModel((boolean)true);
                    if (model != null) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                model.getScanner().terminate();
                            }
                        };
                        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
                        Protocol.invokeAndWait((Runnable)runnable);
                    }
                    if (model != null) {
                        final AsyncCallbackCollector collector = new AsyncCallbackCollector();
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                IPeerModel[] peers;
                                IPeerModel[] iPeerModelArray = peers = model.getPeers();
                                int n = peers.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IPeerModel peerModel = iPeerModelArray[n2];
                                    IStepperService service = (IStepperService)ServiceManager.getInstance().getService((Object)peerModel, IStepperService.class);
                                    if (service != null) {
                                        String stepGroupId = service.getStepGroupId((Object)peerModel, "disconnect");
                                        IStepContext stepContext = service.getStepContext((Object)peerModel, "disconnect");
                                        String name = service.getStepGroupName((Object)peerModel, "disconnect");
                                        boolean isEnabled = service.isEnabled((Object)peerModel, "disconnect");
                                        if (isEnabled && stepGroupId != null && stepContext != null) {
                                            PropertiesContainer data = new PropertiesContainer();
                                            StepperJob job = new StepperJob(name != null ? name : "", stepContext, (IPropertiesContainer)data, stepGroupId, "disconnect", false);
                                            AsyncCallbackCollector.SimpleCollectorCallback callback = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
                                            job.setJobCallback((ICallback)callback);
                                            job.schedule();
                                        }
                                    }
                                    ++n2;
                                }
                                collector.initDone();
                            }
                        };
                        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
                        Protocol.invokeAndWait((Runnable)runnable);
                        ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)collector.getConditionTester());
                    }
                    Tcf.getChannelManager().closeAll(!Protocol.isDispatchThread());
                }
                return proceedShutdown;
            }

            public void postShutdown(IWorkbench workbench) {
                Object[] candidates;
                Object[] objectArray = candidates = UIPlugin.this.listeners.getListeners();
                int n = candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    if (listener instanceof IWorkbenchListener) {
                        ((IWorkbenchListener)listener).postShutdown(workbench);
                    }
                    ++n2;
                }
            }
        };
        PlatformUI.getWorkbench().addWorkbenchListener(this.listener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.listener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.listener);
            this.listener = null;
        }
        super.stop(context);
    }

    public void addListener(IWorkbenchListener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.add((Object)listener);
    }

    public void removeListener(IWorkbenchListener listener) {
        Assert.isNotNull((Object)listener);
        this.listeners.remove((Object)listener);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        URL url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/peer.gif");
        registry.put("PeerObject", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/peer_discovered.gif");
        registry.put("PeerObjectDiscovered", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/obj16/discovery_root.gif");
        registry.put("RemotePeerDiscoverRootNodeObject", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/gold_ovr.gif");
        registry.put("GoldOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/green_ovr.gif");
        registry.put("GreenOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/grey_ovr.gif");
        registry.put("GreyOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/red_ovr.gif");
        registry.put("RedOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/redX_ovr.gif");
        registry.put("RedXOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/link_ovr.gif");
        registry.put("LinkOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/dtool16/run_exc.gif");
        registry.put("RunDisabled", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/etool16/run_exc.gif");
        registry.put("RunEnabled", ImageDescriptor.createFromURL((URL)url));
    }

    public static Image getImage(String key) {
        return UIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return UIPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static Image getSharedImage(AbstractImageDescriptor descriptor) {
        String imageKey;
        ImageRegistry registry = UIPlugin.getDefault().getImageRegistry();
        Image image = registry.get(imageKey = descriptor.getDecriptorKey());
        if (image == null) {
            registry.put(imageKey, (ImageDescriptor)descriptor);
            image = registry.get(imageKey);
        }
        return image;
    }
}

