/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IInferenceRule;
import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.IRule;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.Parent;

public abstract class AbstractMakefile
extends Parent
implements IMakefile {
    private URI filename;

    public AbstractMakefile(Directive parent) {
        super(parent);
    }

    @Override
    public abstract IDirective[] getBuiltins();

    @Override
    public IRule[] getRules() {
        IDirective[] stmts = this.getDirectives(true);
        ArrayList<IDirective> array = new ArrayList<IDirective>(stmts.length);
        IDirective[] iDirectiveArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            IDirective stmt = iDirectiveArray[n2];
            if (stmt instanceof IRule) {
                array.add(stmt);
            }
            ++n2;
        }
        return array.toArray(new IRule[0]);
    }

    @Override
    public IRule[] getRules(String target) {
        IRule[] rules = this.getRules();
        ArrayList<IRule> array = new ArrayList<IRule>(rules.length);
        IRule[] iRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            IRule rule = iRuleArray[n2];
            if (rule.getTarget().equals(target)) {
                array.add(rule);
            }
            ++n2;
        }
        return array.toArray(new IRule[0]);
    }

    @Override
    public IInferenceRule[] getInferenceRules() {
        IRule[] rules = this.getRules();
        ArrayList<IRule> array = new ArrayList<IRule>(rules.length);
        IRule[] iRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            IRule rule = iRuleArray[n2];
            if (rule instanceof IInferenceRule) {
                array.add(rule);
            }
            ++n2;
        }
        return array.toArray(new IInferenceRule[0]);
    }

    @Override
    public IInferenceRule[] getInferenceRules(String target) {
        IInferenceRule[] irules = this.getInferenceRules();
        ArrayList<IInferenceRule> array = new ArrayList<IInferenceRule>(irules.length);
        IInferenceRule[] iInferenceRuleArray = irules;
        int n = irules.length;
        int n2 = 0;
        while (n2 < n) {
            IInferenceRule irule = iInferenceRuleArray[n2];
            if (irule.getTarget().equals(target)) {
                array.add(irule);
            }
            ++n2;
        }
        return array.toArray(new IInferenceRule[0]);
    }

    @Override
    public ITargetRule[] getTargetRules() {
        IRule[] trules = this.getRules();
        ArrayList<IRule> array = new ArrayList<IRule>(trules.length);
        IRule[] iRuleArray = trules;
        int n = trules.length;
        int n2 = 0;
        while (n2 < n) {
            IRule trule = iRuleArray[n2];
            if (trule instanceof ITargetRule) {
                array.add(trule);
            }
            ++n2;
        }
        return array.toArray(new ITargetRule[0]);
    }

    @Override
    public ITargetRule[] getTargetRules(String target) {
        ITargetRule[] trules = this.getTargetRules();
        ArrayList<ITargetRule> array = new ArrayList<ITargetRule>(trules.length);
        ITargetRule[] iTargetRuleArray = trules;
        int n = trules.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetRule trule = iTargetRuleArray[n2];
            if (trule.getTarget().equals(target)) {
                array.add(trule);
            }
            ++n2;
        }
        return array.toArray(new ITargetRule[0]);
    }

    @Override
    public IMacroDefinition[] getMacroDefinitions() {
        IDirective[] stmts = this.getDirectives(true);
        ArrayList<IDirective> array = new ArrayList<IDirective>(stmts.length);
        IDirective[] iDirectiveArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            IDirective stmt = iDirectiveArray[n2];
            if (stmt instanceof IMacroDefinition) {
                array.add(stmt);
            }
            ++n2;
        }
        return array.toArray(new IMacroDefinition[0]);
    }

    @Override
    public IMacroDefinition[] getMacroDefinitions(String name) {
        IMacroDefinition[] variables = this.getMacroDefinitions();
        ArrayList<IMacroDefinition> array = new ArrayList<IMacroDefinition>(variables.length);
        IMacroDefinition[] iMacroDefinitionArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IMacroDefinition variable = iMacroDefinitionArray[n2];
            if (variable.getName().equals(name)) {
                array.add(variable);
            }
            ++n2;
        }
        return array.toArray(new IMacroDefinition[0]);
    }

    @Override
    public IMacroDefinition[] getBuiltinMacroDefinitions() {
        IDirective[] stmts = this.getBuiltins();
        ArrayList<IDirective> array = new ArrayList<IDirective>(stmts.length);
        IDirective[] iDirectiveArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            IDirective stmt = iDirectiveArray[n2];
            if (stmt instanceof IMacroDefinition) {
                array.add(stmt);
            }
            ++n2;
        }
        return array.toArray(new IMacroDefinition[0]);
    }

    @Override
    public IMacroDefinition[] getBuiltinMacroDefinitions(String name) {
        IMacroDefinition[] variables = this.getBuiltinMacroDefinitions();
        ArrayList<IMacroDefinition> array = new ArrayList<IMacroDefinition>(variables.length);
        IMacroDefinition[] iMacroDefinitionArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IMacroDefinition variable = iMacroDefinitionArray[n2];
            if (variable.getName().equals(name)) {
                array.add(variable);
            }
            ++n2;
        }
        return array.toArray(new IMacroDefinition[0]);
    }

    public IInferenceRule[] getBuiltinInferenceRules() {
        IDirective[] stmts = this.getBuiltins();
        ArrayList<IDirective> array = new ArrayList<IDirective>(stmts.length);
        IDirective[] iDirectiveArray = stmts;
        int n = stmts.length;
        int n2 = 0;
        while (n2 < n) {
            IDirective stmt = iDirectiveArray[n2];
            if (stmt instanceof IInferenceRule) {
                array.add(stmt);
            }
            ++n2;
        }
        return array.toArray(new IInferenceRule[0]);
    }

    public IInferenceRule[] getBuiltinInferenceRules(String target) {
        IInferenceRule[] irules = this.getBuiltinInferenceRules();
        ArrayList<IInferenceRule> array = new ArrayList<IInferenceRule>(irules.length);
        IInferenceRule[] iInferenceRuleArray = irules;
        int n = irules.length;
        int n2 = 0;
        while (n2 < n) {
            IInferenceRule irule = iInferenceRuleArray[n2];
            if (irule.getTarget().equals(target)) {
                array.add(irule);
            }
            ++n2;
        }
        return array.toArray(new IInferenceRule[0]);
    }

    @Override
    public String expandString(String line) {
        return this.expandString(line, false);
    }

    @Override
    public String expandString(String line, boolean recursive) {
        int len = line.length();
        boolean foundDollar = false;
        boolean inMacro = false;
        StringBuffer buffer = new StringBuffer();
        StringBuffer macroName = new StringBuffer();
        int i = 0;
        while (i < len) {
            char c = line.charAt(i);
            switch (c) {
                case '$': {
                    if (foundDollar) {
                        buffer.append(c);
                        foundDollar = false;
                        break;
                    }
                    foundDollar = true;
                    break;
                }
                case '(': 
                case '{': {
                    if (foundDollar) {
                        inMacro = true;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case ')': 
                case '}': {
                    String result;
                    IMacroDefinition[] defs;
                    String name;
                    if (inMacro) {
                        name = macroName.toString();
                        if (name.length() > 0) {
                            defs = this.getMacroDefinitions(name);
                            if (defs.length == 0) {
                                defs = this.getBuiltinMacroDefinitions(name);
                            }
                            if (defs.length > 0) {
                                result = defs[0].getValue().toString();
                                if (result.indexOf(36) != -1 && recursive) {
                                    result = this.expandString(result, recursive);
                                }
                                buffer.append(result);
                            } else {
                                buffer.append('$').append('(').append(name).append(')');
                            }
                        }
                        macroName.setLength(0);
                        inMacro = false;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                default: {
                    String result;
                    IMacroDefinition[] defs;
                    String name;
                    if (inMacro) {
                        macroName.append(c);
                    } else if (foundDollar) {
                        name = String.valueOf(c);
                        defs = this.getMacroDefinitions(name);
                        if (defs.length == 0) {
                            defs = this.getBuiltinMacroDefinitions(name);
                        }
                        if (defs.length > 0) {
                            result = defs[0].getValue().toString();
                            if (result.indexOf(36) != -1 && recursive) {
                                result = this.expandString(result, recursive);
                            }
                            buffer.append(result);
                        } else {
                            buffer.append('$').append(c);
                        }
                        inMacro = false;
                    } else {
                        buffer.append(c);
                    }
                    foundDollar = false;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public URI getFileURI() {
        return this.filename;
    }

    public void setFileURI(URI filename) {
        this.filename = filename;
    }

    @Override
    public IMakefile getMakefile() {
        return this;
    }
}

