/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.listeners.interfaces.IChannelStateChangeListener;
import org.eclipse.tcf.te.tcf.locator.Scanner;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.IModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.IScanner;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.listener.ChannelStateChangeListener;
import org.eclipse.tcf.te.tcf.locator.listener.LocatorListener;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelUpdateService;

public class LocatorModel
extends PlatformObject
implements ILocatorModel {
    private final UUID uniqueId = UUID.randomUUID();
    private boolean disposed = false;
    final Map<String, IPeerModel> peers = new HashMap<String, IPeerModel>();
    final Map<String, List<IPeerModel>> peerChildren = new HashMap<String, List<IPeerModel>>();
    private IScanner scanner = null;
    private ILocator.LocatorListener locatorListener = null;
    private IChannelStateChangeListener channelStateChangeListener = null;
    private final List<IModelListener> modelListener = new ArrayList<IModelListener>();
    private final ILocatorModelRefreshService refreshService = new LocatorModelRefreshService(this);
    private final ILocatorModelLookupService lookupService = new LocatorModelLookupService(this);
    private final ILocatorModelUpdateService updateService = new LocatorModelUpdateService(this);
    private final ILocatorModelPeerNodeQueryService queryService = new LocatorModelPeerNodeQueryService(this);

    public LocatorModel() {
        this.channelStateChangeListener = new ChannelStateChangeListener(this);
        Tcf.addChannelStateChangeListener((IChannelStateChangeListener)this.channelStateChangeListener);
    }

    @Override
    public void addListener(IModelListener listener) {
        Assert.isNotNull((Object)listener);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.addListener( " + listener + " )", "trace/locatorModel", (Object)this);
        }
        if (!this.modelListener.contains(listener)) {
            this.modelListener.add(listener);
        }
    }

    @Override
    public void removeListener(IModelListener listener) {
        Assert.isNotNull((Object)listener);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.removeListener( " + listener + " )", "trace/locatorModel", (Object)this);
        }
        this.modelListener.remove(listener);
    }

    @Override
    public IModelListener[] getListener() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        return this.modelListener.toArray(new IModelListener[this.modelListener.size()]);
    }

    @Override
    public void dispose() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.dispose()", "trace/locatorModel", (Object)this);
        }
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        final IModelListener[] listeners = this.getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IModelListener[] iModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelListener listener = iModelListenerArray[n2];
                        listener.locatorModelDisposed(LocatorModel.this);
                        ++n2;
                    }
                }
            });
        }
        this.modelListener.clear();
        if (this.locatorListener != null) {
            Protocol.getLocator().removeListener(this.locatorListener);
            this.locatorListener = null;
        }
        if (this.channelStateChangeListener != null) {
            Tcf.removeChannelStateChangeListener((IChannelStateChangeListener)this.channelStateChangeListener);
            this.channelStateChangeListener = null;
        }
        if (this.scanner != null) {
            this.stopScanner();
            this.scanner = null;
        }
        this.peers.clear();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public IPeerModel[] getPeers() {
        final AtomicReference result = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                result.set(LocatorModel.this.peers.values().toArray(new IPeerModel[LocatorModel.this.peers.values().size()]));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return (IPeerModel[])result.get();
    }

    @Override
    public List<IPeerModel> getChildren(final String parentPeerID) {
        Assert.isNotNull((Object)parentPeerID);
        final AtomicReference result = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List<IPeerModel> children = LocatorModel.this.peerChildren.get(parentPeerID);
                if (children == null) {
                    children = Collections.emptyList();
                }
                result.set(children);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return Collections.unmodifiableList((List)result.get());
    }

    @Override
    public void setChildren(String parentPeerID, List<IPeerModel> children) {
        Assert.isNotNull((Object)parentPeerID);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (children == null || children.size() == 0) {
            this.peerChildren.remove(parentPeerID);
        } else {
            this.peerChildren.put(parentPeerID, new ArrayList<IPeerModel>(children));
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ILocator.LocatorListener.class)) {
            return this.locatorListener;
        }
        if (adapter.isAssignableFrom(IScanner.class)) {
            return this.scanner;
        }
        if (adapter.isAssignableFrom(ILocatorModelRefreshService.class)) {
            return this.refreshService;
        }
        if (adapter.isAssignableFrom(ILocatorModelLookupService.class)) {
            return this.lookupService;
        }
        if (adapter.isAssignableFrom(ILocatorModelUpdateService.class)) {
            return this.updateService;
        }
        if (adapter.isAssignableFrom(ILocatorModelPeerNodeQueryService.class)) {
            return this.queryService;
        }
        if (adapter.isAssignableFrom(Map.class)) {
            return this.peers;
        }
        return super.getAdapter(adapter);
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof LocatorModel) {
            return this.uniqueId.equals(((LocatorModel)obj).uniqueId);
        }
        return super.equals(obj);
    }

    @Override
    public <V extends ILocatorModelService> V getService(Class<V> serviceInterface) {
        Assert.isNotNull(serviceInterface);
        return (V)((ILocatorModelService)this.getAdapter(serviceInterface));
    }

    public void checkLocatorListener() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)Protocol.getLocator());
        if (this.locatorListener == null) {
            this.locatorListener = this.doCreateLocatorListener(this);
            Protocol.getLocator().addListener(this.locatorListener);
        }
    }

    protected ILocator.LocatorListener doCreateLocatorListener(ILocatorModel model) {
        Assert.isNotNull((Object)model);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        return new LocatorListener(model);
    }

    @Override
    public IScanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new Scanner(this);
        }
        return this.scanner;
    }

    @Override
    public void startScanner(long delay, long schedule) {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.startScanner( " + delay + ", " + schedule + " )", "trace/locatorModel", (Object)this);
        }
        IScanner scanner = this.getScanner();
        Assert.isNotNull((Object)scanner);
        HashMap<String, Object> config = new HashMap<String, Object>(scanner.getConfiguration());
        config.put("schedule", schedule);
        scanner.setConfiguration(config);
        if (scanner instanceof Job) {
            Job job = (Job)scanner;
            job.setSystem(true);
            job.setPriority(50);
            job.schedule(delay);
        }
    }

    @Override
    public void stopScanner() {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.stopScanner()", "trace/locatorModel", (Object)this);
        }
        if (this.scanner != null) {
            this.scanner.terminate();
            this.scanner = null;
        }
    }

    @Override
    public IPeer validatePeer(IPeer peer) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeer( " + peer.getID() + " )", "trace/locatorModel", (Object)this);
        }
        IPeer result = peer;
        String loopback = IPAddressUtil.getInstance().getIPv4LoopbackAddress();
        String peerIP = (String)peer.getAttributes().get("Host");
        if (IPAddressUtil.getInstance().isLocalHost(peerIP) && !loopback.equals(peerIP)) {
            result = null;
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
                CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeer: local host peer but not loopback address -> peer node dropped", "trace/locatorModel", (Object)this);
            }
        }
        return result;
    }

    @Override
    public IPeerModel validatePeerNodeForAdd(IPeerModel node) {
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeer peer = node.getPeer();
        if (peer == null) {
            return node;
        }
        boolean isStatic = node.isStatic();
        if (isStatic) {
            return node;
        }
        String transport = peer.getTransportName();
        if (transport == null || !"TCP".equals(transport) && !"SSL".equals(transport)) {
            return node;
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd( " + peer.getID() + " )", "trace/locatorModel", (Object)this);
        }
        IPeerModel result = node;
        String loopback = IPAddressUtil.getInstance().getIPv4LoopbackAddress();
        String peerIP = (String)peer.getAttributes().get("Host");
        if (IPAddressUtil.getInstance().isLocalHost(peerIP) && !loopback.equals(peerIP)) {
            boolean drop = true;
            String agentID = peer.getAgentID();
            if (agentID != null) {
                Map peers = Protocol.getLocator().getPeers();
                HashMap byAgentID = new HashMap();
                for (IPeer candidate : peers.values()) {
                    if (candidate.getAgentID() == null) continue;
                    List<Object> l = (List)byAgentID.get(candidate.getAgentID());
                    if (l == null) {
                        l = new ArrayList<IPeer>();
                        byAgentID.put(candidate.getAgentID(), l);
                    }
                    Assert.isNotNull((Object)l);
                    if (l.contains(candidate)) continue;
                    l.add(candidate);
                }
                List candidates = (List)byAgentID.get(agentID);
                if (candidates != null && candidates.size() > 1) {
                    drop = false;
                    for (IPeer candidate : candidates) {
                        String ip = (String)candidate.getAttributes().get("Host");
                        if (!IPAddressUtil.getInstance().isLocalHost(ip) || !loopback.equals(ip)) continue;
                        drop = true;
                        break;
                    }
                } else {
                    drop = false;
                }
            }
            if (drop) {
                result = null;
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
                    CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: local host peer but not loopback address -> peer node dropped", "trace/locatorModel", (Object)this);
                }
            }
        }
        if (result != null) {
            IPeerModel[] previousNodes;
            String agentId = peer.getAgentID();
            IPeerModel[] iPeerModelArray = previousNodes = agentId != null ? this.getService(ILocatorModelLookupService.class).lkupPeerModelByAgentId(agentId) : new IPeerModel[]{};
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
                CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: agentId=" + agentId + ", Matching peer nodes " + (previousNodes.length > 0 ? "found (" + previousNodes.length + ")" : "not found --> DONE"), "trace/locatorModel", (Object)this);
            }
            IPeerModel[] iPeerModelArray2 = previousNodes;
            int n = previousNodes.length;
            int n2 = 0;
            while (n2 < n) {
                Object previousNode = iPeerModelArray2[n2];
                IPeer previousPeer = previousNode.getPeer();
                if (previousPeer != null) {
                    String previousPeerIP = (String)previousPeer.getAttributes().get("Host");
                    if (IPAddressUtil.getInstance().isLocalHost(previousPeerIP) && !loopback.equals(previousPeerIP) && loopback.equals(peerIP)) {
                        this.getService(ILocatorModelUpdateService.class).remove((IPeerModel)previousNode);
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
                            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: Previous peer removed and replaced by new peer representing the loopback address", "trace/locatorModel", (Object)this);
                        }
                    } else {
                        String previousPeerPort;
                        String peerPort = (String)peer.getAttributes().get("Port");
                        if (peerPort == null || "".equals(peerPort)) {
                            peerPort = "1534";
                        }
                        if ((previousPeerPort = (String)previousPeer.getAttributes().get("Port")) == null || "".equals(previousPeerPort)) {
                            previousPeerPort = "1534";
                        }
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
                            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: peerIP=" + peerIP + ", peerPort=" + peerPort + ", previousPeerPort=" + previousPeerPort, "trace/locatorModel", (Object)this);
                        }
                        if (peerPort.equals(previousPeerPort)) {
                            result = null;
                            if (!CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) break;
                            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: Previous peer node kept, new peer node dropped", "trace/locatorModel", (Object)this);
                            break;
                        }
                        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
                            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: Previous peer node kept, new peer node added (Port mismatch)", "trace/locatorModel", (Object)this);
                        }
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public IPeerModel validateChildPeerNodeForAdd(IPeerModel node) {
        IPeerModel parent;
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validateChildPeerNodeForAdd( " + node.getPeerId() + " )", "trace/locatorModel", (Object)this);
        }
        if ((parent = (IPeerModel)node.getParent(IPeerModel.class)) == null) {
            return null;
        }
        return this.validateChildPeerNodeForAdd(parent, node);
    }

    protected IPeerModel validateChildPeerNodeForAdd(IPeerModel parent, IPeerModel node) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validateChildPeerNodeForAdd( " + parent.getPeerId() + ", " + node.getPeerId() + " )", "trace/locatorModel", (Object)this);
        }
        if (this.doValidateChildPeerNodeForAdd(parent, node) == null) {
            return null;
        }
        if (parent.getParent(IPeerModel.class) != null) {
            IPeerModel[] children;
            IPeerModel parentParentNode = (IPeerModel)parent.getParent(IPeerModel.class);
            if (this.doValidateChildPeerNodeForAdd(parentParentNode, node) == null) {
                return null;
            }
            List<IPeerModel> childrenList = this.getChildren(parentParentNode.getPeerId());
            IPeerModel[] iPeerModelArray = children = childrenList.toArray(new IPeerModel[childrenList.size()]);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IPeerModel parentParentChild = iPeerModelArray[n2];
                if (node.equals(parentParentChild) || parent.equals(parentParentChild)) {
                    return null;
                }
                if (this.doValidateChildPeerNodeForAdd(parentParentChild, node) == null) {
                    return null;
                }
                ++n2;
            }
        }
        return node;
    }

    protected IPeerModel doValidateChildPeerNodeForAdd(IPeerModel parent, IPeerModel node) {
        Map parentPeerAttributes;
        String id;
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.doValidateChildPeerNodeForAdd( " + parent.getPeerId() + ", " + node.getPeerId() + " )", "trace/locatorModel", (Object)this);
        }
        if (this.isRootNode(id = node.getPeerId())) {
            return null;
        }
        int beginIndex = id.indexOf(58);
        int endIndex = id.lastIndexOf(58);
        String ip = beginIndex != -1 && endIndex != -1 ? id.substring(beginIndex + 1, endIndex) : "";
        String loopback = IPAddressUtil.getInstance().getIPv4LoopbackAddress();
        if ("".equals(ip)) {
            ip = loopback;
        }
        if (IPAddressUtil.getInstance().isLocalHost(ip)) {
            StringBuilder newId = new StringBuilder();
            newId.append(id.substring(0, beginIndex));
            newId.append(':');
            newId.append(loopback);
            newId.append(':');
            newId.append(id.substring(endIndex + 1));
            if (this.isRootNode(newId.toString())) {
                return null;
            }
        }
        IPeer peer = node.getPeer();
        String parentAgentID = parent.getPeer().getAgentID();
        if (parentAgentID != null && parentAgentID.equals(peer.getAgentID())) {
            return null;
        }
        String agentID = node.getPeer().getAgentID();
        if (agentID != null) {
            IPeerModel[] matches;
            IPeerModel[] iPeerModelArray = matches = this.getService(ILocatorModelLookupService.class).lkupPeerModelByAgentId(parent.getPeerId(), agentID);
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                IPeerModel match = iPeerModelArray[n2];
                if (agentID.equals(match.getPeer().getAgentID())) {
                    if ("127.0.0.1".equals(node.getPeer().getAttributes().get("Host")) && !"127.0.0.1".equals(match.getPeer().getAttributes().get("Host"))) {
                        return null;
                    }
                    if (!"127.0.0.1".equals(node.getPeer().getAttributes().get("Host")) && "127.0.0.1".equals(match.getPeer().getAttributes().get("Host"))) {
                        this.getService(ILocatorModelUpdateService.class).removeChild(match);
                    }
                    if (!"127.0.0.1".equals(node.getPeer().getAttributes().get("Host")) && !"127.0.0.1".equals(match.getPeer().getAttributes().get("Host"))) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        if ((parentPeerAttributes = parent.getPeer().getAttributes()).get("Host") != null && ((String)parentPeerAttributes.get("Host")).equals(peer.getAttributes().get("Host"))) {
            String port;
            String parentPort = (String)parentPeerAttributes.get("Port");
            if (parentPort == null) {
                parentPort = "1534";
            }
            if ((port = (String)peer.getAttributes().get("Port")) == null) {
                port = "1534";
            }
            if (parentPort.equals(port)) {
                return null;
            }
        }
        return node;
    }

    private boolean isRootNode(String id) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        boolean isRoot = false;
        if (this.getService(ILocatorModelLookupService.class).lkupPeerModelById(id) != null) {
            isRoot = true;
        } else {
            Map peers = Protocol.getLocator().getPeers();
            if (peers.containsKey(id)) {
                isRoot = true;
            }
        }
        return isRoot;
    }
}

