/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.IScanner;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerModel;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;

public class ScannerRunnable
implements Runnable,
IChannel.IChannelListener {
    private final IScanner parentScanner;
    final IPeerModel peerNode;
    IChannel channel = null;
    boolean sharedChannel = false;
    private final ICallback callback;

    public ScannerRunnable(IScanner scanner, IPeerModel peerNode) {
        this(scanner, peerNode, null);
    }

    public ScannerRunnable(IScanner scanner, IPeerModel peerNode, ICallback callback) {
        this.parentScanner = scanner;
        Assert.isNotNull((Object)peerNode);
        this.peerNode = peerNode;
        this.callback = callback;
    }

    protected final IScanner getParentScanner() {
        return this.parentScanner;
    }

    @Override
    public void run() {
        boolean isValueAdd;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IScanner scanner = this.getParentScanner();
        if (scanner != null && scanner.isTerminated()) {
            if (this.callback != null) {
                this.callback.done((Object)this, Status.OK_STATUS);
            }
            return;
        }
        if (this.peerNode.getProperty("scanner.transient") != null) {
            if (this.callback != null) {
                this.callback.done((Object)this, Status.OK_STATUS);
            }
            return;
        }
        this.peerNode.setProperty("scanner.transient", this);
        IPeer peer = this.peerNode.getPeer();
        if (peer == null) {
            if (this.callback != null) {
                this.callback.done((Object)this, Status.OK_STATUS);
            }
            return;
        }
        String value = (String)peer.getAttributes().get("ValueAdd");
        boolean bl = isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
        if (isValueAdd) {
            if (this.callback != null) {
                this.callback.done((Object)this, Status.OK_STATUS);
            }
            return;
        }
        if (this.peerNode.isComplete()) {
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled("trace/scanner")) {
                CoreBundleActivator.getTraceHandler().trace("Scanner runnable invoked for peer '" + this.peerNode.getName() + "' (" + this.peerNode.getPeerId() + "). Attempting to open channel ...", "trace/scanner", (Object)this);
            }
            this.channel = Tcf.getChannelManager().getChannel(peer);
            if (this.channel == null || this.channel.getState() != 1) {
                this.sharedChannel = false;
                this.channel = peer.openChannel();
                this.channel.addChannelListener((IChannel.IChannelListener)this);
            } else {
                this.sharedChannel = true;
                this.onChannelOpened();
            }
        }
    }

    public void onChannelOpened() {
        if (this.channel != null && !this.sharedChannel) {
            this.channel.removeChannelListener((IChannel.IChannelListener)this);
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled("trace/scanner")) {
            CoreBundleActivator.getTraceHandler().trace("Scanner runnable onChannelOpened invoked for peer '" + this.peerNode.getName() + "' (" + this.peerNode.getPeerId() + ").", "trace/scanner", (Object)this);
        }
        final boolean changed = this.peerNode.setChangeEventsEnabled(false);
        int counter = this.peerNode.getIntProperty("channelRefCounter.silent");
        if (!this.peerNode.isProperty("state", 4)) {
            this.peerNode.setProperty("state", counter > 0 ? 1 : 0);
            this.peerNode.setProperty("lastScannerError", null);
        }
        final ILocatorModel model = (ILocatorModel)this.peerNode.getAdapter(ILocatorModel.class);
        if (this.channel != null && this.channel.getState() == 1) {
            String agentID;
            String ip;
            ILocatorModelUpdateService updateService;
            ILocatorModelUpdateService iLocatorModelUpdateService = updateService = model != null ? model.getService(ILocatorModelUpdateService.class) : null;
            if (updateService != null) {
                Collection localServices = this.channel.getLocalServices();
                Collection remoteServices = this.channel.getRemoteServices();
                updateService.updatePeerServices(this.peerNode, localServices, remoteServices);
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled("trace/scanner")) {
                    CoreBundleActivator.getTraceHandler().trace("Services: local = " + localServices + ", remote = " + remoteServices, "trace/scanner", (Object)this);
                }
            }
            if (!((ip = (String)this.channel.getRemotePeer().getAttributes().get("Host")) == null || "".equals(ip) || this.peerNode.getStringProperty("dns.name.transient") != null && ip.equals(this.peerNode.getStringProperty("dns.lastIP.transient")))) {
                if (!ip.equals(this.peerNode.getStringProperty("dns.lastIP.transient"))) {
                    this.peerNode.setProperty("dns.lastIP.transient", ip);
                    this.peerNode.setProperty("dns.skip.transient", false);
                }
                if (!this.peerNode.getBooleanProperty("dns.skip.transient")) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                InetAddress address = InetAddress.getByName(ip);
                                final AtomicReference<String> nameRef = new AtomicReference<String>();
                                nameRef.set(address.getCanonicalHostName());
                                if (ip.equals(nameRef.get()) && IPAddressUtil.getInstance().isLocalHost(ip)) {
                                    String[] candidates;
                                    String[] stringArray = candidates = IPAddressUtil.getInstance().getCanonicalHostNames();
                                    int n = candidates.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String candidate = stringArray[n2];
                                        if (!ip.equals(candidate)) {
                                            nameRef.set(candidate);
                                            break;
                                        }
                                        ++n2;
                                    }
                                }
                                Protocol.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        String name = (String)nameRef.get();
                                        if (name != null && !"".equals(name) && !ip.equals(name)) {
                                            String dnsName;
                                            String string = dnsName = name.indexOf(46) != -1 ? name.substring(0, name.indexOf(46)) : name;
                                            if (!ip.equalsIgnoreCase(dnsName)) {
                                                (this).ScannerRunnable.this.peerNode.setProperty("dns.name.transient", dnsName.toLowerCase());
                                            }
                                        }
                                    }
                                });
                            }
                            catch (UnknownHostException unknownHostException) {
                                Protocol.invokeLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        (this).ScannerRunnable.this.peerNode.setProperty("dns.skip.transient", true);
                                    }
                                });
                            }
                        }
                    };
                    Thread thread = new Thread(runnable, "DNS Query Thread for " + ip);
                    thread.start();
                }
            }
            if ((agentID = this.channel.getRemotePeer().getAgentID()) == null && this.channel.getRemotePeer() instanceof Peer) {
                ILocator locator = (ILocator)this.channel.getRemoteService(ILocator.class);
                if (locator != null) {
                    locator.getAgentID(new ILocator.DoneGetAgentID(){

                        public void doneGetAgentID(IToken token, Exception error, String agentID) {
                            if (agentID != null) {
                                HashMap<String, String> attrs = new HashMap<String, String>(ScannerRunnable.this.channel.getRemotePeer().getAttributes());
                                attrs.put("AgentID", agentID);
                                ScannerRunnable.this.peerNode.setProperty("instance", new Peer(attrs));
                            }
                            ScannerRunnable.this.getPeers(ScannerRunnable.this.channel, model, ip, (ICallback)new Callback(){

                                protected void internalDone(Object caller, IStatus status) {
                                    ScannerRunnable.this.onDone((this).ScannerRunnable.this.peerNode, changed);
                                }
                            });
                        }
                    });
                } else {
                    this.onDone(this.peerNode, changed);
                }
            } else {
                this.getPeers(this.channel, model, ip, (ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        ScannerRunnable.this.onDone(ScannerRunnable.this.peerNode, changed);
                    }
                });
            }
        } else {
            this.onDone(this.peerNode, changed);
        }
    }

    protected void getPeers(final IChannel channel, final ILocatorModel model, String ip, final ICallback callback) {
        ILocator locator;
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)model);
        Assert.isNotNull((Object)callback);
        boolean keepOpen = false;
        this.peerNode.getPeer().getAgentID();
        if (ip != null && !"".equals(ip) && model != null && (locator = (ILocator)channel.getRemoteService(ILocator.class)) != null) {
            keepOpen = true;
            new Command(channel, (IService)locator, "getPeers", null){

                public void done(Exception error, Object[] args) {
                    if (error == null) {
                        Assert.isTrue((args.length == 2 ? 1 : 0) != 0);
                        error = this.toError(args[0]);
                    }
                    if (error == null && args[1] != null) {
                        IPeer parentPeer = channel.getRemotePeer();
                        ArrayList<IPeerModel> oldChildren = new ArrayList<IPeerModel>(model.getChildren(parentPeer.getID()));
                        Collection peerAttributesList = (Collection)args[1];
                        for (Map attributes : peerAttributesList) {
                            boolean isValueAdd;
                            String value = (String)attributes.get("ValueAdd");
                            boolean bl = isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
                            if (isValueAdd) continue;
                            String peerId = (String)attributes.get("ID");
                            PeerRedirector peer = new PeerRedirector(parentPeer, attributes);
                            IPeerModel peerNode = model.getService(ILocatorModelLookupService.class).lkupPeerModelById(parentPeer.getID(), peerId);
                            if (peerNode == null) {
                                peerNode = new PeerModel(model, peer);
                                peerNode.setParent(ScannerRunnable.this.peerNode);
                                peerNode.setProperty("scanner.exclude.silent", true);
                                peerNode = model.validateChildPeerNodeForAdd(peerNode);
                                if (peerNode == null) continue;
                                model.getService(ILocatorModelUpdateService.class).addChild(peerNode);
                                continue;
                            }
                            Assert.isTrue((peerNode.getParent(IPeerModel.class) != null && ((IPeerModel)peerNode.getParent(IPeerModel.class)).equals(ScannerRunnable.this.peerNode) ? 1 : 0) != 0);
                            peerNode.setProperty("instance", peer);
                            oldChildren.remove(peerNode);
                        }
                        for (IPeerModel child : oldChildren) {
                            if (child.isStatic()) continue;
                            model.getService(ILocatorModelUpdateService.class).removeChild(child);
                        }
                    }
                    if (!ScannerRunnable.this.sharedChannel) {
                        channel.close();
                    }
                    callback.done((Object)ScannerRunnable.this, Status.OK_STATUS);
                }
            };
        }
        if (!this.sharedChannel && !keepOpen) {
            channel.close();
        }
        if (!keepOpen) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    public void onChannelClosed(Throwable error) {
        if (this.channel != null) {
            this.channel.removeChannelListener((IChannel.IChannelListener)this);
        }
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled("trace/scanner")) {
            CoreBundleActivator.getTraceHandler().trace("Scanner runnable onChannelClosed invoked for peer '" + this.peerNode.getName() + "' (" + this.peerNode.getPeerId() + "). Error was: " + (error != null ? error.getLocalizedMessage() : null), "trace/scanner", (Object)this);
        }
        if (this.parentScanner == null || !this.parentScanner.isTerminated()) {
            ILocatorModel model;
            boolean changed = this.peerNode.setChangeEventsEnabled(false);
            this.peerNode.setProperty("channelRefCounter.silent", null);
            if (!this.peerNode.isProperty("state", 4)) {
                boolean timeout = error instanceof SocketTimeoutException || error instanceof ConnectException && error.getMessage() != null && error.getMessage().startsWith("Connection timed out:");
                this.peerNode.setProperty("state", timeout ? 2 : 3);
                this.peerNode.setProperty("lastScannerError", error instanceof SocketTimeoutException ? null : error);
            }
            if ((model = (ILocatorModel)this.peerNode.getAdapter(ILocatorModel.class)) != null) {
                ILocatorModelUpdateService updateService = model.getService(ILocatorModelUpdateService.class);
                updateService.updatePeerServices(this.peerNode, null, null);
                model.setChildren(this.peerNode.getPeerId(), null);
            }
            this.peerNode.setProperty("dns.name.transient", null);
            this.peerNode.setProperty("dns.lastIP.transient", null);
            this.peerNode.setProperty("dns.skip.transient", null);
            this.onDone(this.peerNode, changed);
        }
    }

    protected void onDone(IPeerModel node, boolean changed) {
        Assert.isNotNull((Object)node);
        node.setProperty("scanner.transient", null);
        if (changed) {
            node.setChangeEventsEnabled(true);
            node.fireChangeEvent("properties", null, this.peerNode.getProperties());
        }
        if (this.callback != null) {
            this.callback.done((Object)this, Status.OK_STATUS);
        }
    }

    public void congestionLevel(int level) {
    }
}

