/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.persistence.history;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.persistence.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;

public class HistoryManager {
    private static final int HISTORY_LENGTH = 5;
    private Map<String, List<String>> history = new HashMap<String, List<String>>();

    public static HistoryManager getInstance() {
        return LazyInstance.instance;
    }

    HistoryManager() {
        this.initialize();
    }

    private void initialize() {
        this.history.clear();
        try {
            IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
            if (uRIPersistenceService == null) {
                throw new IOException("Persistence service instance unavailable.");
            }
            this.history = (Map)uRIPersistenceService.read(this.history, this.getURI());
        }
        catch (IOException iOException) {}
    }

    private URI getURI() {
        IPath pluginPath = CoreBundleActivator.getDefault().getStateLocation();
        pluginPath = pluginPath.append(".history");
        return pluginPath.toFile().toURI();
    }

    public void flush() {
        try {
            IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
            if (uRIPersistenceService == null) {
                throw new IOException("Persistence service instance unavailable.");
            }
            uRIPersistenceService.write(this.history, this.getURI());
        }
        catch (IOException iOException) {}
    }

    public String[] getHistory(String historyId) {
        Assert.isNotNull((Object)historyId);
        List<String> ids = this.history.get(historyId);
        if (ids == null) {
            ids = new ArrayList<String>();
        }
        return ids.toArray(new String[ids.size()]);
    }

    public String getFirst(String historyId) {
        String[] history = this.getHistory(historyId);
        return history.length > 0 ? history[0] : null;
    }

    public boolean add(String historyId, String id) {
        Assert.isNotNull((Object)historyId);
        Assert.isNotNull((Object)id);
        List<String> ids = this.history.get(historyId);
        if (ids == null) {
            ids = new ArrayList<String>();
            this.history.put(historyId, ids);
        }
        if (ids.contains(id)) {
            ids.remove(id);
        }
        ids.add(0, id);
        while (ids.size() > 5) {
            ids.remove(5);
        }
        this.flush();
        EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"added", (Object)historyId, (Object)historyId));
        return true;
    }

    public boolean remove(String historyId, String id) {
        Assert.isNotNull((Object)historyId);
        Assert.isNotNull((Object)id);
        boolean removed = false;
        List<String> ids = this.history.get(historyId);
        if (ids != null) {
            removed |= ids.remove(id);
            if (ids.isEmpty()) {
                this.history.remove(historyId);
            }
        }
        if (removed) {
            this.flush();
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"removed", (Object)historyId, (Object)historyId));
        }
        return removed;
    }

    private static class LazyInstance {
        public static HistoryManager instance = new HistoryManager();

        private LazyInstance() {
        }
    }
}

