/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.command.factories.macos;

import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.command.CLIInfoProc;
import org.eclipse.cdt.debug.mi.core.output.CLIInfoProcInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;

class MacOSCLIInfoPID
extends CLIInfoProc {
    public MacOSCLIInfoPID() {
        this.setOperation("info pid");
    }

    @Override
    public MIInfo getMIInfo() throws MIException {
        MacOSCLIInfoPIDOutput info = null;
        MIOutput out = this.getMIOutput();
        if (out != null && (info = new MacOSCLIInfoPIDOutput(out)).isError()) {
            this.throwMIException(info, out);
        }
        return info;
    }

    class MacOSCLIInfoPIDOutput
    extends CLIInfoProcInfo {
        int pid;

        public MacOSCLIInfoPIDOutput(MIOutput out) {
            super(out);
            this.parsePID();
        }

        void parsePID() {
            if (this.isDone()) {
                MIOutput out = this.getMIOutput();
                MIResult[] rr = out.getMIResultRecord().getMIResults();
                int i = 0;
                while (i < rr.length) {
                    this.parsePIDLine(rr[i].toString());
                    ++i;
                }
            }
        }

        void parsePIDLine(String str) {
            if (str != null && str.length() > 0) {
                if (!(str = str.trim()).startsWith("process-id=")) {
                    return;
                }
                this.pid = Integer.decode(str.substring(12, str.length() - 1));
            }
        }

        @Override
        public int getPID() {
            return this.pid;
        }
    }
}

