/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.math.BigInteger;
import java.util.HashMap;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocator;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgument;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocalVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocalVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.Locator;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.ArgumentDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.LocalVariableDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIExecFinish;
import org.eclipse.cdt.debug.mi.core.command.MIExecReturn;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class StackFrame
extends CObject
implements ICDIStackFrame {
    MIFrame frame;
    Thread cthread;
    int level;
    ICDIArgumentDescriptor[] argDescs;
    ICDILocalVariableDescriptor[] localDescs;
    Locator fLocator;
    private HashMap fTypeCache;

    public StackFrame(Thread thread, MIFrame f, int l) {
        super((Target)thread.getTarget());
        this.cthread = thread;
        this.frame = f;
        this.level = l;
        this.fTypeCache = new HashMap();
    }

    public MIFrame getMIFrame() {
        return this.frame;
    }

    public ICDIType getFromTypeCache(String typeName) {
        return (ICDIType)this.fTypeCache.get(typeName);
    }

    public void addToTypeCache(String typeName, ICDIType typeDefinition) {
        this.fTypeCache.put(typeName, typeDefinition);
    }

    public ICDIThread getThread() {
        return this.cthread;
    }

    public ICDIArgumentDescriptor[] getArgumentDescriptors() throws CDIException {
        if (this.argDescs == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            this.argDescs = mgr.getArgumentDescriptors(this);
        }
        return this.argDescs;
    }

    public ICDILocalVariableDescriptor[] getLocalVariableDescriptors() throws CDIException {
        if (this.localDescs == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            this.localDescs = mgr.getLocalVariableDescriptors(this);
        }
        return this.localDescs;
    }

    public ICDIArgument createArgument(ICDIArgumentDescriptor varDesc) throws CDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            return mgr.createArgument((ArgumentDescriptor)varDesc);
        }
        return null;
    }

    public ICDILocalVariable createLocalVariable(ICDILocalVariableDescriptor varDesc) throws CDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            return this.createArgument((ICDIArgumentDescriptor)varDesc);
        }
        if (varDesc instanceof LocalVariableDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            return mgr.createLocalVariable((LocalVariableDescriptor)varDesc);
        }
        return null;
    }

    public ICDILocator getLocator() {
        BigInteger addr = BigInteger.ZERO;
        if (this.frame != null) {
            if (this.fLocator == null) {
                String a = this.frame.getAddress();
                if (a != null) {
                    addr = MIFormat.getBigInteger(a);
                }
                this.fLocator = new Locator(this.frame.getFile(), this.frame.getFunction(), this.frame.getLine(), addr);
            }
            return this.fLocator;
        }
        return new Locator("", "", 0, addr);
    }

    public int getLevel() {
        return this.level;
    }

    public boolean equals(ICDIStackFrame stackframe) {
        if (stackframe instanceof StackFrame) {
            boolean equal;
            StackFrame stack = (StackFrame)stackframe;
            boolean bl = equal = this.cthread != null && this.cthread.equals(stack.getThread()) && this.getLevel() == stack.getLevel();
            if (equal) {
                ICDILocator otherLocator = stack.getLocator();
                ICDILocator myLocator = this.getLocator();
                if (Locator.equalString(myLocator.getFile(), otherLocator.getFile()) && Locator.equalString(myLocator.getFunction(), otherLocator.getFunction())) {
                    return true;
                }
            }
        }
        return super.equals(stackframe);
    }

    public void stepReturn() throws CDIException {
        this.finish();
    }

    public void stepReturn(ICDIValue value) throws CDIException {
        this.execReturn(value.toString());
    }

    protected void finish() throws CDIException {
        ((Thread)this.getThread()).setCurrentStackFrame(this, false);
        Target target = (Target)this.getTarget();
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIExecFinish finish = factory.createMIExecFinish();
        try {
            miSession.postCommand(finish);
            MIInfo info = finish.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    protected void execReturn(String value) throws CDIException {
        ((Thread)this.getThread()).setCurrentStackFrame(this, false);
        Target target = (Target)this.getTarget();
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        MIExecReturn ret = value == null ? factory.createMIExecReturn() : factory.createMIExecReturn(value);
        try {
            miSession.postCommand(ret);
            MIInfo info = ret.getMIInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.model.Target.Target_not_responding"));
            }
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }
}

