/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.NullOpExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpParsePath;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.FSTreeContentProvider;
import org.eclipse.tcf.te.tcf.filesystem.ui.controls.FSTreeViewerSorter;
import org.eclipse.tcf.te.tcf.filesystem.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.filesystem.ui.interfaces.IFSConstants;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.FSTreeElementLabelProvider;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards.FolderValidator;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards.NameValidator;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards.NewNodeWizard;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.trees.FilterDescriptor;
import org.eclipse.tcf.te.ui.trees.ViewerStateManager;
import org.eclipse.tcf.te.ui.wizards.pages.AbstractValidatingWizardPage;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class NewNodeWizardPage
extends AbstractValidatingWizardPage {
    private FormToolkit toolkit;
    private BaseEditBrowseTextControl nameControl;
    private BaseEditBrowseTextControl folderControl;
    private TreeViewer treeViewer;

    public NewNodeWizardPage(String pageName) {
        super(pageName);
    }

    protected abstract String getPageTitle();

    protected abstract String getPageDescription();

    protected abstract String getNameFieldLabel();

    public void createControl(Composite parent) {
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
        this.toolkit = new FormToolkit(parent.getDisplay());
        Composite mainPanel = this.toolkit.createComposite(parent);
        mainPanel.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        mainPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        mainPanel.setBackground(parent.getBackground());
        this.setControl((Control)mainPanel);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainPanel, IContextHelpIds.FS_NEW_FILE_WIZARD_PAGE);
        boolean changed = this.setValidationInProgress(true);
        this.createMainPanelControls(mainPanel);
        if (changed) {
            this.setValidationInProgress(false);
        }
        Dialog.applyDialogFont((Control)mainPanel);
        this.setPageComplete(false);
    }

    private void createMainPanelControls(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite client = this.toolkit != null ? this.toolkit.createComposite(parent) : new Composite(parent, 0);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)2));
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        client.setBackground(parent.getBackground());
        Label label = new Label(client, 0);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(Messages.NewNodeWizardPage_PromptFolderLabel);
        this.folderControl = new BaseEditBrowseTextControl((IDialogPage)this);
        this.folderControl.setIsGroup(false);
        this.folderControl.setHasHistory(false);
        this.folderControl.setHideBrowseButton(true);
        this.folderControl.setHideLabelControl(true);
        this.folderControl.setHideEditFieldControlDecoration(true);
        this.folderControl.setFormToolkit(this.toolkit);
        this.folderControl.setParentControlIsInnerPanel(true);
        this.folderControl.setupPanel(client);
        this.folderControl.setEditFieldValidator((Validator)new FolderValidator(this));
        NewNodeWizard wizard = this.getWizard();
        FSTreeNode folder = wizard.getFolder();
        if (folder != null) {
            this.folderControl.setEditFieldControlText(folder.getLocation());
        }
        this.treeViewer = new TreeViewer(client, 2820);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        data.heightHint = 193;
        data.widthHint = 450;
        this.treeViewer.getTree().setLayoutData((Object)data);
        this.treeViewer.setContentProvider((IContentProvider)new FSTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)NewNodeWizardPage.createDecoratingLabelProvider((ILabelProvider)new FSTreeElementLabelProvider()));
        this.treeViewer.setComparator((ViewerComparator)new FSTreeViewerSorter());
        this.treeViewer.addFilter((ViewerFilter)new DirectoryFilter());
        IPeerModel peer = wizard.getPeer();
        if (peer != null) {
            this.setInput(peer);
        }
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewNodeWizardPage.this.onSelectionChanged();
            }
        });
        if (folder != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)folder));
        }
        this.nameControl = new BaseEditBrowseTextControl((IDialogPage)this);
        this.nameControl.setIsGroup(false);
        this.nameControl.setHasHistory(false);
        this.nameControl.setHideBrowseButton(true);
        this.nameControl.setEditFieldLabel(this.getNameFieldLabel());
        this.nameControl.setFormToolkit(this.toolkit);
        this.nameControl.setParentControlIsInnerPanel(true);
        this.nameControl.setupPanel(client);
        this.nameControl.setEditFieldValidator((Validator)new NameValidator(this));
        if (folder == null) {
            this.folderControl.getEditFieldControl().setFocus();
        } else {
            this.nameControl.getEditFieldControl().setFocus();
        }
        this.restoreWidgetValues();
    }

    private void setInput(Object input) {
        this.treeViewer.setInput(input);
        FilterDescriptor[] filterDescriptors = ViewerStateManager.getInstance().getFilterDescriptors(IFSConstants.ID_TREE_VIEWER_FS, input);
        Assert.isNotNull((Object)filterDescriptors);
        FilterDescriptor[] filterDescriptorArray = filterDescriptors;
        int n = filterDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            FilterDescriptor descriptor = filterDescriptorArray[n2];
            if (descriptor.isEnabled()) {
                this.treeViewer.addFilter(descriptor.getFilter());
            }
            ++n2;
        }
    }

    private static ILabelProvider createDecoratingLabelProvider(ILabelProvider labelProvider) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IDecoratorManager manager = workbench.getDecoratorManager();
        ILabelDecorator decorator = manager.getLabelDecorator();
        return new DecoratingLabelProvider(labelProvider, decorator);
    }

    protected void onSelectionChanged() {
        IWizardContainer container;
        if (this.treeViewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
            if (selection.getFirstElement() instanceof FSTreeNode) {
                FSTreeNode folder = (FSTreeNode)selection.getFirstElement();
                this.folderControl.setEditFieldControlText(folder.getLocation());
            } else {
                this.folderControl.setEditFieldControlText("");
            }
        }
        if ((container = this.getContainer()) != null && container.getCurrentPage() != null) {
            container.updateWindowTitle();
            container.updateTitleBar();
            container.updateButtons();
        }
        this.validate();
    }

    public void setPeer(IPeerModel peer) {
        if (peer != null) {
            this.setInput(peer);
        }
    }

    protected IValidatingContainer.ValidationResult doValidate() {
        IValidatingContainer.ValidationResult result = new IValidatingContainer.ValidationResult();
        boolean valid = true;
        if (this.folderControl != null) {
            valid &= this.folderControl.isValid();
            result.setResult((IMessageProvider)this.folderControl);
        }
        if (this.nameControl != null) {
            valid &= this.nameControl.isValid();
            result.setResult((IMessageProvider)this.nameControl);
        }
        result.setValid(valid);
        return result;
    }

    public void dispose() {
        if (this.nameControl != null) {
            this.nameControl.dispose();
            this.nameControl = null;
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    public String getNodeName() {
        return this.nameControl.getEditFieldControlTextForValidation();
    }

    public NewNodeWizard getWizard() {
        return (NewNodeWizard)super.getWizard();
    }

    public FSTreeNode getInputDir() {
        NewNodeWizard wizard = this.getWizard();
        IPeerModel peer = wizard.getPeer();
        if (peer == null) {
            return null;
        }
        String text = this.folderControl.getEditFieldControlText();
        if (text != null) {
            String path = text.trim();
            OpParsePath parser = new OpParsePath(peer, path);
            new NullOpExecutor().execute((IOperation)parser);
            return parser.getResult();
        }
        return null;
    }

    static class DirectoryFilter
    extends ViewerFilter {
        DirectoryFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            FSTreeNode node;
            return !(element instanceof FSTreeNode) || !(node = (FSTreeNode)element).isFile();
        }
    }
}

