/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCacheUpdate;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.ContentTypeHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;

public class OpenWithMenu
extends ContributionItem {
    private static final String DEFAULT_TEXT_EDITOR = "org.eclipse.ui.DefaultTextEditor";
    public static final String ID = String.valueOf(UIPlugin.getUniqueIdentifier()) + ".OpenWithMenu";
    private static final Comparator<IEditorDescriptor> comparer = new Comparator<IEditorDescriptor>(){
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(IEditorDescriptor arg0, IEditorDescriptor arg1) {
            String s1 = arg0.getLabel();
            String s2 = arg1.getLabel();
            return this.collator.compare(s1, s2);
        }
    };
    FSTreeNode node;
    IWorkbenchPage page;
    IEditorRegistry registry;

    public OpenWithMenu(IWorkbenchPage page, FSTreeNode node) {
        super(ID);
        this.node = node;
        this.page = page;
        this.registry = PlatformUI.getWorkbench().getEditorRegistry();
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        return imageDesc.createImage();
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.node.name) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc != null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(this.node.name);
        }
        return imageDesc;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenWithMenu.this.syncOpen(descriptor, false);
                        break;
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private void createOtherMenuItem(final Menu menu) {
        new MenuItem(menu, 2);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(Messages.OpenWithMenu_OpenWith);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        IEditorDescriptor editor;
                        EditorSelectionDialog dialog = new EditorSelectionDialog(menu.getShell());
                        dialog.setMessage(NLS.bind((String)Messages.OpenWithMenu_ChooseEditorForOpening, (Object)OpenWithMenu.this.node.name));
                        if (dialog.open() != 0 || (editor = dialog.getSelectedEditor()) == null) break;
                        OpenWithMenu.this.syncOpen(editor, editor.isOpenExternal());
                        break;
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private IEditorDescriptor getDefaultEditor() {
        try {
            IEditorDescriptor desc;
            String editorID = (String)PersistenceManager.getInstance().getPersistentProperties(this.node).get(IDE.EDITOR_KEY);
            if (editorID != null && (desc = this.registry.findEditor(editorID)) != null) {
                return desc;
            }
        }
        catch (Exception exception) {}
        IContentType contentType = null;
        contentType = ContentTypeHelper.getContentType((FSTreeNode)this.node);
        return this.registry.getDefaultEditor(this.node.name, contentType);
    }

    public void fill(Menu menu, int index) {
        IEditorDescriptor defaultEditor = this.registry.findEditor(DEFAULT_TEXT_EDITOR);
        IEditorDescriptor preferredEditor = this.getDefaultEditor();
        IEditorDescriptor[] editors = this.registry.getEditors(this.node.name, ContentTypeHelper.getContentType((FSTreeNode)this.node));
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, descriptor, preferredEditor);
        this.createDefaultMenuItem(menu);
        this.createOtherMenuItem(menu);
    }

    public boolean isDynamic() {
        return true;
    }

    private void createDefaultMenuItem(Menu menu) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(this.getDefaultEditor() == null);
        menuItem.setText(Messages.OpenWithMenu_DefaultEditor);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        PersistenceManager.getInstance().getPersistentProperties(OpenWithMenu.this.node).put(IDE.EDITOR_KEY, null);
                        try {
                            OpenWithMenu.this.syncOpen(OpenWithMenu.this.getEditorDescriptor(), false);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    protected IEditorDescriptor getEditorDescriptor() throws PartInitException {
        IEditorDescriptor defaultDescriptor = this.getDefaultEditor();
        if (defaultDescriptor != null) {
            return defaultDescriptor;
        }
        IEditorDescriptor editorDesc = null;
        if (this.registry.isSystemInPlaceEditorAvailable(this.node.name)) {
            editorDesc = this.registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (editorDesc == null && this.registry.isSystemExternalEditorAvailable(this.node.name)) {
            editorDesc = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (editorDesc == null) {
            editorDesc = this.registry.findEditor(DEFAULT_TEXT_EDITOR);
        }
        if (editorDesc == null) {
            throw new PartInitException(Messages.OpenWithMenu_NoEditorFound);
        }
        return editorDesc;
    }

    protected void syncOpen(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
        File file = CacheManager.getCacheFile((FSTreeNode)this.node);
        if (!file.exists()) {
            UiExecutor executor = new UiExecutor();
            IStatus status = executor.execute((IOperation)new OpCacheUpdate(new FSTreeNode[]{this.node}));
            if (!status.isOK()) {
                return;
            }
        }
        this.openInEditor(editorDescriptor, openUsingDescriptor);
    }

    private void openInEditor(IEditorDescriptor editorDescriptor, boolean openUsingDescriptor) {
        try {
            IPath path = CacheManager.getCachePath((FSTreeNode)this.node);
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            if (openUsingDescriptor) {
                String editorId = editorDescriptor.getId();
                this.page.openEditor((IEditorInput)input, editorId, true, 3);
            } else {
                String editorId = "org.eclipse.ui.systemExternalEditor";
                if (editorDescriptor != null) {
                    editorId = editorDescriptor.getId();
                }
                this.page.openEditor((IEditorInput)input, editorId, true, 3);
                Map properties = PersistenceManager.getInstance().getPersistentProperties(this.node);
                properties.put(IDE.EDITOR_KEY, editorId);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

