/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.celleditor;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;

public class FSCellValidator
implements ICellEditorValidator {
    public static final String UNIX_FILENAME_REGEX = "[^/]+";
    public static final String WIN_FILENAME_REGEX = "[^(\\?|\\\\|/|:|\\*|<|>|\\|)]+";
    private TreeViewer viewer;

    public FSCellValidator(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public String isValid(Object value) {
        String formatRegex;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object element = selection.getFirstElement();
        Assert.isTrue((boolean)(element instanceof FSTreeNode));
        FSTreeNode node = (FSTreeNode)element;
        if (value == null) {
            return Messages.FSRenamingAssistant_SpecifyNonEmptyName;
        }
        String text = value.toString().trim();
        if (text.length() == 0) {
            return Messages.FSRenamingAssistant_SpecifyNonEmptyName;
        }
        if (this.hasChild(node, text)) {
            return Messages.FSRenamingAssistant_NameAlreadyExists;
        }
        String string = formatRegex = node.isWindowsNode() ? WIN_FILENAME_REGEX : UNIX_FILENAME_REGEX;
        if (!text.matches(formatRegex)) {
            return node.isWindowsNode() ? Messages.FSRenamingAssistant_WinIllegalCharacters : Messages.FSRenamingAssistant_UnixIllegalCharacters;
        }
        return null;
    }

    private boolean hasChild(FSTreeNode folder, String name) {
        List nodes = folder.getParent().getChildren();
        for (FSTreeNode node : nodes) {
            if (!(node.isWindowsNode() ? node.name.equalsIgnoreCase(name) : node.name.equals(name))) continue;
            return true;
        }
        return false;
    }
}

