/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.tcf.te.runtime.model.ModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;

public class ContainerModelNode
extends ModelNode
implements IContainerModelNode {
    private final List<IModelNode> childList = new ArrayList<IModelNode>();
    private final Lock childListLock = new ReentrantLock();
    public static final IModelNode[] EMPTY_MODEL_NODE_ARRAY = new IModelNode[0];

    @Override
    public IModelNode[] getChildren() {
        return this.internalGetChildren();
    }

    protected final IModelNode[] internalGetChildren() {
        ArrayList<IModelNode> children = new ArrayList<IModelNode>();
        try {
            this.childListLock.lock();
            children.addAll(this.childList);
        }
        finally {
            this.childListLock.unlock();
        }
        return children.toArray(new IModelNode[children.size()]);
    }

    @Override
    public <T> List<T> getChildren(Class<T> instanceOf) {
        ArrayList<IModelNode> children = new ArrayList<IModelNode>();
        try {
            this.childListLock.lock();
            for (IModelNode child : this.childList) {
                if (!instanceOf.isInstance(child)) continue;
                children.add(child);
            }
        }
        finally {
            this.childListLock.unlock();
        }
        return children;
    }

    @Override
    public boolean hasChildren() {
        boolean hasChildren = false;
        try {
            this.childListLock.lock();
            hasChildren = !this.childList.isEmpty();
        }
        finally {
            this.childListLock.unlock();
        }
        return hasChildren;
    }

    @Override
    public boolean add(IModelNode node) {
        if (node != null) {
            try {
                this.childListLock.lock();
                if (node.getParent() == null) {
                    node.setParent(this);
                } else {
                    Assert.isTrue((node.getParent() == this ? 1 : 0) != 0, (String)("Attempt to add child node to " + this.getName() + " with this != node.getParent()!!!"));
                }
                this.childList.add(node);
            }
            finally {
                this.childListLock.unlock();
            }
            this.fireChangeEvent("added", null, new IModelNode[]{node});
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(IModelNode node, boolean recursive) {
        if (node instanceof IContainerModelNode && recursive) {
            IContainerModelNode container = (IContainerModelNode)node;
            container.clear();
        }
        boolean removed = false;
        try {
            this.childListLock.lock();
            removed = this.childList.remove(node);
        }
        finally {
            this.childListLock.unlock();
        }
        if (removed) {
            this.fireChangeEvent("removed", new IModelNode[]{node}, null);
        }
        return removed;
    }

    @Override
    public <T> boolean removeAll(Class<T> nodeType) {
        List<T> children;
        boolean removed = false;
        try {
            this.childListLock.lock();
            children = this.getChildren(nodeType);
        }
        finally {
            this.childListLock.unlock();
        }
        if (removed |= this.childList.removeAll(children)) {
            this.fireChangeEvent("removed", children, null);
        }
        return removed;
    }

    @Override
    public boolean clear() {
        boolean removed = false;
        boolean changed = this.setChangeEventsEnabled(false);
        try {
            IModelNode[] children;
            this.childListLock.lock();
            IModelNode[] iModelNodeArray = children = this.internalGetChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IModelNode element = iModelNodeArray[n2];
                removed |= this.remove(element, true);
                ++n2;
            }
        }
        finally {
            this.childListLock.unlock();
        }
        if (changed) {
            this.setChangeEventsEnabled(true);
        }
        return removed;
    }

    @Override
    public int size() {
        int size = 0;
        try {
            this.childListLock.lock();
            size = this.childList.size();
        }
        finally {
            this.childListLock.unlock();
        }
        return size;
    }

    public boolean isEmpty() {
        return super.isEmpty() && !this.hasChildren();
    }

    @Override
    public boolean contains(IModelNode node) {
        if (node != null) {
            try {
                this.childListLock.lock();
                boolean bl = this.childList.contains(node);
                return bl;
            }
            finally {
                this.childListLock.unlock();
            }
        }
        return false;
    }

    protected boolean isSchedulingLockedRecursivly() {
        return true;
    }

    @Override
    public boolean contains(ISchedulingRule rule) {
        if (this.isSchedulingLockedRecursivly() && rule instanceof IModelNode) {
            try {
                IModelNode[] children;
                this.childListLock.lock();
                IModelNode[] iModelNodeArray = children = this.internalGetChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelNode child = iModelNodeArray[n2];
                    if (child.contains(rule)) {
                        return true;
                    }
                    ++n2;
                }
            }
            finally {
                this.childListLock.unlock();
            }
        }
        return super.contains(rule);
    }

    @Override
    public boolean isConflicting(ISchedulingRule rule) {
        if (this.isSchedulingLockedRecursivly() && rule instanceof IModelNode) {
            try {
                IModelNode[] children;
                this.childListLock.lock();
                IModelNode[] iModelNodeArray = children = this.internalGetChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelNode child = iModelNodeArray[n2];
                    if (child.isConflicting(rule)) {
                        return true;
                    }
                    ++n2;
                }
            }
            finally {
                this.childListLock.unlock();
            }
        }
        return super.isConflicting(rule);
    }

    @Override
    public IModelNode find(UUID uuid) {
        IModelNode find = super.find(uuid);
        if (find != null) {
            return find;
        }
        try {
            this.childListLock.lock();
            for (IModelNode child : this.childList) {
                find = child.find(uuid);
                if (find == null) continue;
                IModelNode iModelNode = find;
                return iModelNode;
            }
        }
        finally {
            this.childListLock.unlock();
        }
        return find;
    }
}

