/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.tabbed;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.ui.internal.tabbed.MapContentProvider;
import org.eclipse.tcf.te.tcf.processes.ui.internal.tabbed.MapEntryLabelProvider;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AdvancedPropertiesSection
extends AbstractPropertySection {
    Map<String, Object> properties;
    private TableViewer viewer;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        Table table = this.getWidgetFactory().createTable(composite, 67586);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, -4);
        table.setLayoutData((Object)data);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.AdvancedPropertiesSection_Name);
        column.setWidth(100);
        column = new TableColumn(table, 16384);
        column.setText(Messages.AdvancedPropertiesSection_Value);
        column.setWidth(150);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new MapContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MapEntryLabelProvider());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof IProcessContextNode));
        final IProcessContextNode node = (IProcessContextNode)input;
        final AtomicReference props = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                props.set(node.getSysMonitorContext().getProperties());
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
        this.properties = (Map)props.get();
    }

    public void refresh() {
        if (this.viewer != null) {
            this.viewer.setInput(this.properties);
        }
    }
}

