/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.tcf.processes.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.processes.ui.internal.dialogs.IntervalGrade;
import org.eclipse.tcf.te.tcf.processes.ui.internal.preferences.IPreferenceConsts;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;

public class IntervalConfigDialog
extends StatusDialog
implements ModifyListener,
IPreferenceConsts {
    private Text text;
    private int result;

    public IntervalConfigDialog(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell shell) {
        shell.setText(Messages.IntervalConfigDialog_DialogTitle);
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite comp1 = new Composite(composite, 0);
        GridData data = new GridData(4, 0x1000000, true, false);
        comp1.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        comp1.setLayout((Layout)layout);
        Label label = new Label(comp1, 16);
        label.setText(Messages.IntervalConfigDialog_ChoiceOneLabel);
        this.text = new Text(comp1, 2052);
        this.text.setTextLimit(Text.LIMIT);
        data = new GridData();
        data.widthHint = 70;
        this.text.setLayoutData((Object)data);
        this.text.setText("" + this.result);
        this.text.selectAll();
        this.text.setFocus();
        this.text.addModifyListener((ModifyListener)this);
        label = new Label(comp1, 0);
        label.setText(Messages.IntervalConfigDialog_SECONDS);
        return composite;
    }

    private IStatus isInputValid() {
        String pluginId = UIPlugin.getUniqueIdentifier();
        String txt = SWTControlUtil.getText((Control)this.text);
        if (txt == null || txt.trim().length() == 0) {
            return new Status(4, pluginId, null);
        }
        try {
            int interval = Integer.parseInt(txt.trim());
            if (interval < 0) {
                return new Status(4, pluginId, Messages.IntervalConfigDialog_BiggerThanZero);
            }
            if (interval == 0) {
                return new Status(2, pluginId, Messages.IntervalConfigDialog_ZeroWarning);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return new Status(4, pluginId, Messages.IntervalConfigDialog_InvalidNumber);
        }
        return Status.OK_STATUS;
    }

    protected void okPressed() {
        String txt = SWTControlUtil.getText((Control)this.text).trim();
        this.result = Integer.parseInt(txt);
        super.okPressed();
    }

    public int getResult() {
        return this.result;
    }

    private void validateInput() {
        IStatus status = this.isInputValid();
        this.updateStatus(status);
    }

    IntervalGrade[] getGrades() {
        ArrayList<IntervalGrade> gradeList = new ArrayList<IntervalGrade>();
        IPreferenceStore prefStore = UIPlugin.getDefault().getPreferenceStore();
        String grades = prefStore.getString("PrefIntervalGrades");
        Assert.isNotNull((Object)grades);
        StringTokenizer st = new StringTokenizer(grades, "|");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(token, ":");
            String name = st2.nextToken();
            String value = st2.nextToken();
            try {
                int seconds = Integer.parseInt(value);
                if (seconds <= 0) continue;
                gradeList.add(new IntervalGrade(name, seconds));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return gradeList.toArray(new IntervalGrade[gradeList.size()]);
    }

    public void modifyText(ModifyEvent e) {
        this.validateInput();
    }

    public void setResult(int interval) {
        this.result = interval;
    }

    static class GradeLabelProvider
    extends LabelProvider {
        GradeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IntervalGrade) {
                IntervalGrade grade = (IntervalGrade)element;
                return String.valueOf(grade.getName()) + " (" + grade.getValue() + " " + Messages.IntervalConfigDialog_SECOND_ABBR + ")";
            }
            return super.getText(element);
        }
    }
}

