/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.editor.tree.columns;

import java.io.Serializable;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.ui.navigator.runtime.LabelProviderDelegate;

public class ProcessComparator
implements Comparator<IProcessContextNode>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static LabelProvider labelProvider = new LabelProviderDelegate();

    @Override
    public int compare(IProcessContextNode node1, IProcessContextNode node2) {
        String text2;
        if (node1 == null && node2 == null) {
            return 0;
        }
        if (node1 != null && node2 == null) {
            return 1;
        }
        if (node1 == null && node2 != null) {
            return -1;
        }
        String text1 = node1 == null ? null : labelProvider.getText((Object)node1);
        String string = text2 = node2 == null ? null : labelProvider.getText((Object)node2);
        if (text1 == null) {
            text1 = "";
        }
        if (text2 == null) {
            text2 = "";
        }
        if (text1.length() > 0 && text2.length() > 0) {
            char c1 = text1.charAt(0);
            char c2 = text2.charAt(0);
            if (Character.isDigit(c1) || Character.isDigit(c2)) {
                if (Character.isDigit(c1) && !Character.isDigit(c2)) {
                    return -1;
                }
                if (!Character.isDigit(c1) && Character.isDigit(c2)) {
                    return 1;
                }
            }
            if (Character.isUpperCase(c1) || Character.isUpperCase(c2)) {
                if (Character.isUpperCase(c1) && !Character.isUpperCase(c2)) {
                    return -1;
                }
                if (!Character.isUpperCase(c1) && Character.isUpperCase(c2)) {
                    return 1;
                }
            }
            Matcher m1 = Pattern.compile("(\\D+)(\\d+)").matcher(text1);
            Matcher m2 = Pattern.compile("(\\D+)(\\d+)").matcher(text2);
            if (m1.matches() && m2.matches()) {
                String p11 = m1.group(1);
                String p12 = m1.group(2);
                String p21 = m2.group(1);
                String p22 = m2.group(2);
                if (p11 != null && p11.equals(p21)) {
                    try {
                        int result = 0;
                        long l1 = Long.parseLong(p12);
                        long l2 = Long.parseLong(p22);
                        if (l1 > l2) {
                            result = 1;
                        }
                        if (l1 < l2) {
                            result = -1;
                        }
                        return result;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (text1.matches(".*[A-Z]+.*") || text2.matches(".*[A-Z]+.*")) {
                if (text1.matches(".*[A-Z]+.*") && !text2.matches(".*[A-Z]+.*")) {
                    return -1;
                }
                if (!text1.matches(".*[A-Z]+.*") && text2.matches(".*[A-Z]+.*")) {
                    return 1;
                }
                int minLength = Math.min(text1.length(), text2.length());
                int i = 0;
                while (i < minLength) {
                    char ch1 = text1.charAt(i);
                    char ch2 = text2.charAt(i);
                    if (Character.isUpperCase(ch1) && !Character.isUpperCase(ch2)) {
                        return -1;
                    }
                    if (!Character.isUpperCase(ch1) && Character.isUpperCase(ch2)) {
                        return 1;
                    }
                    if (Character.isUpperCase(ch1) && Character.isUpperCase(ch2)) break;
                    ++i;
                }
            }
        }
        return text1.compareTo(text2);
    }
}

