/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.views.monitor.console;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.te.tcf.ui.views.monitor.console.Console;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class Factory {
    private static final Map<IPeer, Console> CONSOLES = new HashMap<IPeer, Console>();

    public static Console showConsole(IPeer peer, boolean createNew) {
        Assert.isNotNull((Object)peer);
        Console console = Factory.getConsole(peer, createNew);
        if (console != null) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            if (!Factory.isConsoleAlreadyAdded((IConsole)console)) {
                manager.addConsoles(new IConsole[]{console});
            }
            manager.showConsoleView((IConsole)console);
        }
        return console;
    }

    private static boolean isConsoleAlreadyAdded(IConsole console) {
        Assert.isNotNull((Object)console);
        boolean alreadyAdded = false;
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole candidate = iConsoleArray[n2];
            if (candidate == console) {
                alreadyAdded = true;
                break;
            }
            ++n2;
        }
        return alreadyAdded;
    }

    public static Console getConsole(IPeer peer, boolean createNew) {
        Assert.isNotNull((Object)peer);
        Console console = CONSOLES.get(peer);
        if (console == null && createNew) {
            console = new Console(peer);
            CONSOLES.put(peer, console);
        }
        if (console != null && !Factory.isConsoleAlreadyAdded((IConsole)console)) {
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        }
        return console;
    }

    public static void shutdown() {
        for (Console console : CONSOLES.values()) {
            console.shutdown();
        }
        CONSOLES.clear();
    }
}

