/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.Archive;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CContainerInfo;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CContainer
extends Openable
implements ICContainer {
    CModelManager factory = CModelManager.getDefault();

    public CContainer(ICElement parent, IResource res) {
        this(parent, res, 12);
    }

    public CContainer(ICElement parent, IResource res, int type) {
        super(parent, res, type);
    }

    @Override
    public IBinary[] getBinaries() throws CModelException {
        List<ICElement> list = this.getChildrenOfType(14);
        IBinary[] array = new IBinary[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IBinary getBinary(String name) {
        IFile file = this.getContainer().getFile((IPath)new Path(name));
        return this.getBinary(file);
    }

    public IBinary getBinary(IFile file) {
        IBinaryParser.IBinaryFile bin = this.factory.createBinaryFile(file);
        if (bin instanceof IBinaryParser.IBinaryObject) {
            return new Binary((ICElement)this, file, (IBinaryParser.IBinaryObject)bin);
        }
        return new Binary((ICElement)this, file, null);
    }

    @Override
    public IArchive[] getArchives() throws CModelException {
        List<ICElement> list = this.getChildrenOfType(18);
        IArchive[] array = new IArchive[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IArchive getArchive(String name) {
        IFile file = this.getContainer().getFile((IPath)new Path(name));
        return this.getArchive(file);
    }

    public IArchive getArchive(IFile file) {
        IBinaryParser.IBinaryFile ar = this.factory.createBinaryFile(file);
        if (ar != null && ar.getType() == 8) {
            return new Archive((ICElement)this, file, (IBinaryParser.IBinaryArchive)ar);
        }
        return new Archive((ICElement)this, file, null);
    }

    @Override
    public ITranslationUnit[] getTranslationUnits() throws CModelException {
        List<ICElement> list = this.getChildrenOfType(60);
        ITranslationUnit[] array = new ITranslationUnit[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public ITranslationUnit getTranslationUnit(String name) {
        IFile file = this.getContainer().getFile((IPath)new Path(name));
        return this.getTranslationUnit(file);
    }

    public ITranslationUnit getTranslationUnit(IFile file) {
        String id = CoreModel.getRegistedContentTypeId(file.getProject(), file.getName());
        return new TranslationUnit((ICElement)this, file, id);
    }

    @Override
    public ICContainer[] getCContainers() throws CModelException {
        List<ICElement> list = this.getChildrenOfType(12);
        ICContainer[] array = new ICContainer[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public ICContainer getCContainer(String name) {
        IFolder folder = this.getContainer().getFolder((IPath)new Path(name));
        return this.getCContainer(folder);
    }

    public ICContainer getCContainer(IFolder folder) {
        return new CContainer(this, (IResource)folder);
    }

    public IContainer getContainer() {
        return (IContainer)this.getResource();
    }

    @Override
    protected CElementInfo createElementInfo() {
        return new CContainerInfo(this);
    }

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map<ICElement, CElementInfo> newElements, IResource underlyingResource) throws CModelException {
        boolean validInfo;
        block5: {
            validInfo = false;
            try {
                IResource res = this.getResource();
                if (res != null && res.isAccessible()) {
                    validInfo = this.computeChildren(info, res);
                    break block5;
                }
                throw this.newNotPresentException();
            }
            finally {
                if (!validInfo) {
                    CModelManager.getDefault().removeInfo(this);
                }
            }
        }
        return validInfo;
    }

    @Override
    public Object[] getNonCResources() throws CModelException {
        return ((CContainerInfo)this.getElementInfo()).getNonCResources(this.getResource());
    }

    protected boolean computeChildren(OpenableInfo info, IResource res) throws CModelException {
        ArrayList<ICElement> vChildren = new ArrayList<ICElement>();
        try {
            IResource[] resources = null;
            if (res instanceof IContainer) {
                IContainer container = (IContainer)res;
                resources = container.members(false);
            }
            if (resources != null) {
                ICProject cproject = this.getCProject();
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource2 = iResourceArray[n2];
                    ICElement celement = this.computeChild(resource2, cproject);
                    if (celement != null) {
                        vChildren.add(celement);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        info.setChildren(vChildren);
        if (info instanceof CContainerInfo) {
            ((CContainerInfo)info).setNonCResources(null);
        }
        return true;
    }

    protected ICElement computeChild(IResource res, ICProject cproject) throws CModelException {
        Openable celement = null;
        SourceRoot sroot = this.getSourceRoot();
        switch (res.getType()) {
            case 1: {
                IBinaryParser.IBinaryFile bin;
                IFile file = (IFile)res;
                boolean checkBinary = true;
                if (sroot != null && sroot.isOnSourceEntry(res)) {
                    String id = CoreModel.getRegistedContentTypeId(file.getProject(), file.getName());
                    if (id != null) {
                        celement = new TranslationUnit((ICElement)this, file, id);
                        checkBinary = false;
                    } else {
                        checkBinary = true;
                    }
                }
                if (!checkBinary || !cproject.isOnOutputEntry((IResource)file) || (bin = this.factory.createBinaryFile(file)) == null) break;
                if (bin.getType() == 8) {
                    celement = new Archive((ICElement)this, file, (IBinaryParser.IBinaryArchive)bin);
                    ArchiveContainer vlib = (ArchiveContainer)cproject.getArchiveContainer();
                    vlib.addChild(celement);
                    break;
                }
                Binary binElement = new Binary((ICElement)this, file, (IBinaryParser.IBinaryObject)bin);
                celement = binElement;
                if (!binElement.showInBinaryContainer()) break;
                BinaryContainer vbin = (BinaryContainer)cproject.getBinaryContainer();
                vbin.addChild(celement);
                break;
            }
            case 2: {
                if ((sroot == null || !sroot.isOnSourceEntry(res)) && (sroot != null || !cproject.isOnOutputEntry(res))) break;
                celement = new CContainer(this, res);
            }
        }
        return celement;
    }

    @Override
    public ICElement getHandleFromMemento(String token, MementoTokenizer memento) {
        switch (token.charAt(0)) {
            case '<': {
                String name;
                if (memento.hasMoreTokens()) {
                    name = memento.nextToken();
                    char firstChar = name.charAt(0);
                    if (firstChar == '{') {
                        token = name;
                        name = "";
                    } else {
                        token = null;
                    }
                } else {
                    name = "";
                    token = null;
                }
                CElement folder = (CElement)((Object)this.getCContainer(name));
                if (folder == null) break;
                if (token == null) {
                    return folder.getHandleFromMemento(memento);
                }
                return folder.getHandleFromMemento(token, memento);
            }
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String tuName = memento.nextToken();
                CElement tu = (CElement)((Object)this.getTranslationUnit(tuName));
                if (tu == null) break;
                return tu.getHandleFromMemento(memento);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '<';
    }
}

