/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.commenthandler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.CommentHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class ASTCommenter {
    public static NodeCommentMap getCommentedNodeMap(IASTTranslationUnit ast) {
        NodeCommentMap commentMap = new NodeCommentMap();
        if (ast == null) {
            return commentMap;
        }
        IASTComment[] commentsArray = ast.getComments();
        ArrayList<IASTComment> comments = new ArrayList<IASTComment>(commentsArray.length);
        IASTComment[] iASTCommentArray = commentsArray;
        int n = commentsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTComment comment = iASTCommentArray[n2];
            if (comment.isPartOfTranslationUnitFile()) {
                comments.add(comment);
            }
            ++n2;
        }
        ASTCommenter.assignPreprocessorComments(commentMap, comments, ast);
        CommentHandler commentHandler = new CommentHandler(comments);
        ASTCommenterVisitor commenter = new ASTCommenterVisitor(commentHandler, commentMap);
        ast.accept(commenter);
        return commentMap;
    }

    private static boolean isCommentDirectlyBeforePreprocessorStatement(IASTComment comment, IASTPreprocessorStatement statement, IASTTranslationUnit tu) {
        if (tu == null || tu.getDeclarations().length == 0) {
            return true;
        }
        IASTFileLocation commentLocation = comment.getFileLocation();
        int preprocessorOffset = statement.getFileLocation().getNodeOffset();
        if (preprocessorOffset > commentLocation.getNodeOffset()) {
            PreprocessorRangeChecker visitor = new PreprocessorRangeChecker(preprocessorOffset, commentLocation);
            tu.accept(visitor);
            return visitor.isPreStatementComment;
        }
        return false;
    }

    public static boolean isInWorkspace(IASTNode node) {
        return node.isPartOfTranslationUnitFile();
    }

    private static void assignPreprocessorComments(NodeCommentMap commentMap, List<IASTComment> comments, IASTTranslationUnit tu) {
        IASTPreprocessorStatement[] preprocessorStatementsArray = tu.getAllPreprocessorStatements();
        if (preprocessorStatementsArray == null) {
            return;
        }
        List<IASTPreprocessorStatement> preprocessorStatements = Arrays.asList(preprocessorStatementsArray);
        if (preprocessorStatements.isEmpty() || comments.isEmpty()) {
            return;
        }
        ArrayList<IASTComment> freestandingComments = new ArrayList<IASTComment>(comments.size());
        Iterator<IASTPreprocessorStatement> statementsIter = preprocessorStatements.iterator();
        Iterator<IASTComment> commentIter = comments.iterator();
        IASTPreprocessorStatement curStatement = ASTCommenter.getNextNodeInTu(statementsIter);
        IASTComment curComment = ASTCommenter.getNextNodeInTu(commentIter);
        while (curStatement != null && curComment != null) {
            int statementLineNr = curStatement.getFileLocation().getStartingLineNumber();
            int commentLineNr = curComment.getFileLocation().getStartingLineNumber();
            if (commentLineNr == statementLineNr) {
                commentMap.addTrailingCommentToNode(curStatement, curComment);
                curComment = ASTCommenter.getNextNodeInTu(commentIter);
                continue;
            }
            if (commentLineNr > statementLineNr) {
                curStatement = ASTCommenter.getNextNodeInTu(statementsIter);
                continue;
            }
            if (ASTCommenter.isCommentDirectlyBeforePreprocessorStatement(curComment, curStatement, tu)) {
                commentMap.addLeadingCommentToNode(curStatement, curComment);
                curComment = ASTCommenter.getNextNodeInTu(commentIter);
                continue;
            }
            freestandingComments.add(curComment);
            curComment = ASTCommenter.getNextNodeInTu(commentIter);
        }
        while (curComment != null) {
            freestandingComments.add(curComment);
            curComment = ASTCommenter.getNextNodeInTu(commentIter);
        }
        if (freestandingComments.size() != comments.size()) {
            comments.clear();
            comments.addAll(freestandingComments);
        }
    }

    private static <T extends IASTNode> T getNextNodeInTu(Iterator<T> iter) {
        while (iter.hasNext()) {
            IASTNode next = (IASTNode)iter.next();
            if (!next.isPartOfTranslationUnitFile()) continue;
            return (T)next;
        }
        return null;
    }

    private static final class PreprocessorRangeChecker
    extends ASTVisitor {
        int statementOffset;
        IASTFileLocation commentNodeLocation;
        boolean isPreStatementComment = true;

        private PreprocessorRangeChecker(int statementOffset, IASTFileLocation commentNodeLocation) {
            super(true);
            this.statementOffset = statementOffset;
            this.commentNodeLocation = commentNodeLocation;
        }

        private int checkOffsets(IASTNode node) {
            int offset = ((ASTNode)node).getOffset();
            int status = 3;
            if (this.isCommentOnSameLine(node) || offset > this.commentNodeLocation.getNodeOffset() && offset < this.statementOffset) {
                this.isPreStatementComment = false;
                status = 2;
            } else if (offset + ((ASTNode)node).getLength() < this.commentNodeLocation.getNodeOffset()) {
                status = 1;
            } else if (offset > this.statementOffset) {
                status = 2;
            }
            return status;
        }

        private boolean isCommentOnSameLine(IASTNode node) {
            IASTFileLocation fileLocation = node.getFileLocation();
            return fileLocation != null && this.commentNodeLocation.getStartingLineNumber() == fileLocation.getEndingLineNumber();
        }

        @Override
        public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
            return this.checkOffsets(baseSpecifier);
        }

        @Override
        public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
            return this.checkOffsets(namespaceDefinition);
        }

        @Override
        public int visit(ICPPASTTemplateParameter templateParameter) {
            return this.checkOffsets(templateParameter);
        }

        @Override
        public int visit(IASTArrayModifier arrayModifier) {
            return this.checkOffsets(arrayModifier);
        }

        @Override
        public int visit(IASTDeclaration declaration) {
            return this.checkOffsets(declaration);
        }

        @Override
        public int visit(IASTDeclarator declarator) {
            return this.checkOffsets(declarator);
        }

        @Override
        public int visit(IASTDeclSpecifier declSpec) {
            return this.checkOffsets(declSpec);
        }

        @Override
        public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
            return this.checkOffsets(enumerator);
        }

        @Override
        public int visit(IASTExpression expression) {
            return this.checkOffsets(expression);
        }

        @Override
        public int visit(IASTInitializer initializer) {
            return this.checkOffsets(initializer);
        }

        @Override
        public int visit(IASTName name) {
            return this.checkOffsets(name);
        }

        @Override
        public int visit(IASTParameterDeclaration parameterDeclaration) {
            return this.checkOffsets(parameterDeclaration);
        }

        @Override
        public int visit(IASTPointerOperator ptrOperator) {
            return this.checkOffsets(ptrOperator);
        }

        @Override
        public int visit(IASTStatement statement) {
            return this.checkOffsets(statement);
        }

        @Override
        public int visit(IASTTranslationUnit tu) {
            return this.checkOffsets(tu);
        }

        @Override
        public int visit(IASTTypeId typeId) {
            return this.checkOffsets(typeId);
        }
    }
}

