/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTStaticAssertDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTStaticAssertionDeclaration
extends ASTNode
implements ICPPASTStaticAssertDeclaration,
IASTAmbiguityParent {
    private IASTExpression fCondition;
    private final ICPPASTLiteralExpression fMessage;

    public CPPASTStaticAssertionDeclaration(IASTExpression condition, ICPPASTLiteralExpression message) {
        this.fCondition = condition;
        this.fMessage = message;
        if (condition != null) {
            condition.setParent(this);
            condition.setPropertyInParent(CONDITION);
        }
        if (message != null) {
            message.setParent(this);
            message.setPropertyInParent(MESSAGE);
        }
    }

    @Override
    public IASTExpression getCondition() {
        return this.fCondition;
    }

    @Override
    public ICPPASTLiteralExpression getMessage() {
        return this.fMessage;
    }

    @Override
    public CPPASTStaticAssertionDeclaration copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTStaticAssertionDeclaration copy(IASTNode.CopyStyle style) {
        IASTExpression condCopy = this.fCondition == null ? null : this.fCondition.copy(style);
        ICPPASTLiteralExpression msgCopy = this.fMessage == null ? null : this.fMessage.copy(style);
        CPPASTStaticAssertionDeclaration copy = new CPPASTStaticAssertionDeclaration(condCopy, msgCopy);
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fCondition != null && !this.fCondition.accept(action)) {
            return false;
        }
        if (this.fMessage != null && !this.fMessage.accept(action)) {
            return false;
        }
        return !action.shouldVisitDeclarations || action.leave(this) != 2;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fCondition) {
            this.fCondition = (IASTExpression)other;
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
        }
    }
}

