/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBaseDeclSpecifier;

public class CPPASTSimpleDeclSpecifier
extends CPPASTBaseDeclSpecifier
implements ICPPASTSimpleDeclSpecifier,
IASTAmbiguityParent {
    private int type;
    private boolean isSigned;
    private boolean isUnsigned;
    private boolean isShort;
    private boolean isLong;
    private boolean isLonglong;
    private boolean isComplex;
    private boolean isImaginary;
    private IASTExpression fDeclTypeExpression;

    @Override
    public CPPASTSimpleDeclSpecifier copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTSimpleDeclSpecifier copy(IASTNode.CopyStyle style) {
        return this.copy(new CPPASTSimpleDeclSpecifier(), style);
    }

    @Override
    protected <T extends CPPASTSimpleDeclSpecifier> T copy(T copy, IASTNode.CopyStyle style) {
        copy.type = this.type;
        copy.isSigned = this.isSigned;
        copy.isUnsigned = this.isUnsigned;
        copy.isShort = this.isShort;
        copy.isLong = this.isLong;
        copy.isLonglong = this.isLonglong;
        copy.isComplex = this.isComplex;
        copy.isImaginary = this.isImaginary;
        if (this.fDeclTypeExpression != null) {
            copy.setDeclTypeExpression(this.fDeclTypeExpression.copy(style));
        }
        return super.copy(copy, style);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.assertNotFrozen();
        this.type = type;
    }

    @Override
    public void setType(IBasicType.Kind kind) {
        this.setType(this.getType(kind));
    }

    private int getType(IBasicType.Kind kind) {
        switch (kind) {
            case eBoolean: {
                return 6;
            }
            case eChar: {
                return 2;
            }
            case eWChar: {
                return 7;
            }
            case eChar16: {
                return 11;
            }
            case eChar32: {
                return 12;
            }
            case eDouble: {
                return 5;
            }
            case eFloat: {
                return 4;
            }
            case eFloat128: {
                return 14;
            }
            case eInt: {
                return 3;
            }
            case eInt128: {
                return 13;
            }
            case eUnspecified: {
                return 0;
            }
            case eVoid: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean isSigned() {
        return this.isSigned;
    }

    @Override
    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    @Override
    public boolean isShort() {
        return this.isShort;
    }

    @Override
    public boolean isLong() {
        return this.isLong;
    }

    @Override
    public boolean isLongLong() {
        return this.isLonglong;
    }

    @Override
    public boolean isComplex() {
        return this.isComplex;
    }

    @Override
    public boolean isImaginary() {
        return this.isImaginary;
    }

    @Override
    public IASTExpression getDeclTypeExpression() {
        return this.fDeclTypeExpression;
    }

    @Override
    public void setSigned(boolean value) {
        this.assertNotFrozen();
        this.isSigned = value;
    }

    @Override
    public void setUnsigned(boolean value) {
        this.assertNotFrozen();
        this.isUnsigned = value;
    }

    @Override
    public void setLong(boolean value) {
        this.assertNotFrozen();
        this.isLong = value;
    }

    @Override
    public void setShort(boolean value) {
        this.assertNotFrozen();
        this.isShort = value;
    }

    @Override
    public void setLongLong(boolean value) {
        this.assertNotFrozen();
        this.isLonglong = value;
    }

    @Override
    public void setComplex(boolean value) {
        this.assertNotFrozen();
        this.isComplex = value;
    }

    @Override
    public void setImaginary(boolean value) {
        this.assertNotFrozen();
        this.isImaginary = value;
    }

    @Override
    public void setDeclTypeExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.fDeclTypeExpression = expression;
        if (expression != null) {
            expression.setPropertyInParent(DECLTYPE_EXPRESSION);
            expression.setParent(this);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fDeclTypeExpression != null && !this.fDeclTypeExpression.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fDeclTypeExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fDeclTypeExpression = (IASTExpression)other;
        }
    }
}

