/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTForStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;

public class CPPASTForStatement
extends ASTAttributeOwner
implements ICPPASTForStatement,
IASTAmbiguityParent {
    private IScope scope;
    private IASTStatement init;
    private IASTExpression condition;
    private IASTDeclaration condDeclaration;
    private IASTExpression iterationExpression;
    private IASTStatement body;

    public CPPASTForStatement() {
    }

    public CPPASTForStatement(IASTStatement init, IASTDeclaration condDeclaration, IASTExpression iterationExpression, IASTStatement body) {
        this.setInitializerStatement(init);
        this.setConditionDeclaration(condDeclaration);
        this.setIterationExpression(iterationExpression);
        this.setBody(body);
    }

    public CPPASTForStatement(IASTStatement init, IASTExpression condition, IASTExpression iterationExpression, IASTStatement body) {
        this.setInitializerStatement(init);
        this.setConditionExpression(condition);
        this.setIterationExpression(iterationExpression);
        this.setBody(body);
    }

    @Override
    public CPPASTForStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTForStatement copy(IASTNode.CopyStyle style) {
        CPPASTForStatement copy = new CPPASTForStatement();
        copy.setInitializerStatement(this.init == null ? null : this.init.copy(style));
        copy.setConditionDeclaration(this.condDeclaration == null ? null : this.condDeclaration.copy(style));
        copy.setConditionExpression(this.condition == null ? null : this.condition.copy(style));
        copy.setIterationExpression(this.iterationExpression == null ? null : this.iterationExpression.copy(style));
        copy.setBody(this.body == null ? null : this.body.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getConditionExpression() {
        return this.condition;
    }

    @Override
    public void setConditionExpression(IASTExpression condition) {
        this.assertNotFrozen();
        this.condition = condition;
        if (condition != null) {
            condition.setParent(this);
            condition.setPropertyInParent(CONDITION);
            this.condDeclaration = null;
        }
    }

    @Override
    public IASTExpression getIterationExpression() {
        return this.iterationExpression;
    }

    @Override
    public void setIterationExpression(IASTExpression iterator) {
        this.assertNotFrozen();
        this.iterationExpression = iterator;
        if (iterator != null) {
            iterator.setParent(this);
            iterator.setPropertyInParent(ITERATION);
        }
    }

    @Override
    public IASTStatement getBody() {
        return this.body;
    }

    @Override
    public void setBody(IASTStatement statement) {
        this.assertNotFrozen();
        this.body = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(BODY);
        }
    }

    @Override
    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CPPBlockScope(this);
        }
        return this.scope;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributes(action)) {
            return false;
        }
        if (this.init != null && !this.init.accept(action)) {
            return false;
        }
        if (this.condition != null && !this.condition.accept(action)) {
            return false;
        }
        if (this.condDeclaration != null && !this.condDeclaration.accept(action)) {
            return false;
        }
        if (this.iterationExpression != null && !this.iterationExpression.accept(action)) {
            return false;
        }
        if (this.body != null && !this.body.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.body == child) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.body = (IASTStatement)other;
        } else if (child == this.condition || child == this.condDeclaration) {
            if (other instanceof IASTExpression) {
                this.setConditionExpression((IASTExpression)other);
            } else if (other instanceof IASTDeclaration) {
                this.setConditionDeclaration((IASTDeclaration)other);
            }
        } else if (child == this.iterationExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.iterationExpression = (IASTExpression)other;
        } else if (child == this.init) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.init = (IASTStatement)other;
        }
    }

    @Override
    public IASTStatement getInitializerStatement() {
        return this.init;
    }

    @Override
    public void setInitializerStatement(IASTStatement statement) {
        this.assertNotFrozen();
        this.init = statement;
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public void setConditionDeclaration(IASTDeclaration d) {
        this.assertNotFrozen();
        this.condDeclaration = d;
        if (d != null) {
            d.setParent(this);
            d.setPropertyInParent(CONDITION_DECLARATION);
            this.condition = null;
        }
    }

    @Override
    public IASTDeclaration getConditionDeclaration() {
        return this.condDeclaration;
    }
}

