/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public abstract class ASTAttributeOwner
extends ASTNode
implements IASTAttributeOwner {
    private IASTAttribute[] attributes = IASTAttribute.EMPTY_ATTRIBUTE_ARRAY;

    @Override
    public IASTAttribute[] getAttributes() {
        this.attributes = ArrayUtil.trim(this.attributes);
        return this.attributes;
    }

    @Override
    public void addAttribute(IASTAttribute attribute) {
        this.assertNotFrozen();
        if (attribute != null) {
            attribute.setParent(this);
            attribute.setPropertyInParent(ATTRIBUTE);
            this.attributes = ArrayUtil.append(this.attributes, attribute);
        }
    }

    @Override
    protected <T extends ASTAttributeOwner> T copy(T copy, IASTNode.CopyStyle style) {
        IASTAttribute[] iASTAttributeArray = this.getAttributes();
        int n = iASTAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAttribute attribute = iASTAttributeArray[n2];
            copy.addAttribute(attribute.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    protected boolean acceptByAttributes(ASTVisitor action) {
        IASTAttribute[] iASTAttributeArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAttribute attribute = iASTAttributeArray[n2];
            if (attribute == null) break;
            if (!attribute.accept(action)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

