/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.language.settings.providers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.LocalProjectScope;
import org.eclipse.cdt.internal.core.language.settings.providers.ScannerInfoExtensionLanguageSettingsProvider;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ScannerDiscoveryLegacySupport {
    public static final String USER_LANGUAGE_SETTINGS_PROVIDER_ID = "org.eclipse.cdt.ui.UserLanguageSettingsProvider";
    public static final String MBS_LANGUAGE_SETTINGS_PROVIDER_ID = "org.eclipse.cdt.managedbuilder.core.MBSLanguageSettingsProvider";
    public static final String SI_LANGUAGE_SETTINGS_PROVIDER_ID = "org.eclipse.cdt.core.LegacyScannerInfoLanguageSettingsProvider";
    public static final String PATH_ENTRY_MANAGER_LANGUAGE_SETTINGS_PROVIDER_ID = "org.eclipse.cdt.core.PathEntryScannerInfoLanguageSettingsProvider";
    private static String DISABLE_LSP_PREFERENCE = "language.settings.providers.disabled";
    private static boolean DISABLE_LSP_DEFAULT_PROJECT = false;
    private static boolean DISABLE_LSP_DEFAULT_WORKSPACE = false;
    private static final String PREFERENCES_QUALIFIER_CCORE = "org.eclipse.cdt.core";
    private static Map<String, String> legacyProfiles = null;

    private static Preferences getPreferences(IProject project) {
        if (project == null) {
            return InstanceScope.INSTANCE.getNode(PREFERENCES_QUALIFIER_CCORE);
        }
        return new LocalProjectScope(project).getNode(PREFERENCES_QUALIFIER_CCORE);
    }

    public static boolean isLanguageSettingsProvidersFunctionalityDefined(IProject project) {
        Preferences pref = ScannerDiscoveryLegacySupport.getPreferences(project);
        String value = pref.get(DISABLE_LSP_PREFERENCE, null);
        return value != null;
    }

    public static boolean isLanguageSettingsProvidersFunctionalityEnabled(IProject project) {
        boolean isEnabledInWorkspace;
        boolean bl = isEnabledInWorkspace = !ScannerDiscoveryLegacySupport.getPreferences(null).getBoolean(DISABLE_LSP_PREFERENCE, DISABLE_LSP_DEFAULT_WORKSPACE);
        if (isEnabledInWorkspace && project != null) {
            return !ScannerDiscoveryLegacySupport.getPreferences(project).getBoolean(DISABLE_LSP_PREFERENCE, DISABLE_LSP_DEFAULT_PROJECT);
        }
        return isEnabledInWorkspace;
    }

    public static void setLanguageSettingsProvidersFunctionalityEnabled(IProject project, boolean value) {
        Preferences pref = ScannerDiscoveryLegacySupport.getPreferences(project);
        if (value == ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled(project)) {
            return;
        }
        pref.putBoolean(DISABLE_LSP_PREFERENCE, !value);
        CCorePlugin.getDefault().resetCachedScannerInfoProvider(project);
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            CCorePlugin.log(e);
        }
    }

    public static boolean isMbsLanguageSettingsProviderOn(ICConfigurationDescription cfgDescription) {
        if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            List<ILanguageSettingsProvider> lsProviders = ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getLanguageSettingProviders();
            for (ILanguageSettingsProvider lsp : lsProviders) {
                if (!MBS_LANGUAGE_SETTINGS_PROVIDER_ID.equals(lsp.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isLegacyProviderOn(ICConfigurationDescription cfgDescription) {
        if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            List<ILanguageSettingsProvider> lsProviders = ((ILanguageSettingsProvidersKeeper)((Object)cfgDescription)).getLanguageSettingProviders();
            for (ILanguageSettingsProvider lsp : lsProviders) {
                String id = lsp.getId();
                if (!MBS_LANGUAGE_SETTINGS_PROVIDER_ID.equals(id) && !SI_LANGUAGE_SETTINGS_PROVIDER_ID.equals(id) && !PATH_ENTRY_MANAGER_LANGUAGE_SETTINGS_PROVIDER_ID.equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isLegacyScannerDiscoveryOn(ICConfigurationDescription cfgDescription) {
        ICProjectDescription prjDescription;
        IProject project = null;
        if (cfgDescription != null && (prjDescription = cfgDescription.getProjectDescription()) != null) {
            project = prjDescription.getProject();
        }
        return !ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled(project) || ScannerDiscoveryLegacySupport.isLegacyProviderOn(cfgDescription);
    }

    public static boolean isLegacyScannerDiscoveryOn(IProject project) {
        ICConfigurationDescription cfgDescription = null;
        ICProjectDescription prjDescription = CoreModel.getDefault().getProjectDescription(project);
        if (prjDescription != null) {
            cfgDescription = prjDescription.getActiveConfiguration();
        }
        return !ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled(project) || ScannerDiscoveryLegacySupport.isLegacyProviderOn(cfgDescription);
    }

    public static String[] getDefaultProviderIdsLegacy(ICConfigurationDescription cfgDescription) {
        boolean useScannerInfoProviderExtension;
        boolean bl = useScannerInfoProviderExtension = new ScannerInfoExtensionLanguageSettingsProvider().getScannerInfoProvider(cfgDescription) != null;
        String legacyProviderId = useScannerInfoProviderExtension ? SI_LANGUAGE_SETTINGS_PROVIDER_ID : (CProjectDescriptionManager.getInstance().isNewStyleCfg(cfgDescription) ? MBS_LANGUAGE_SETTINGS_PROVIDER_ID : PATH_ENTRY_MANAGER_LANGUAGE_SETTINGS_PROVIDER_ID);
        return new String[]{USER_LANGUAGE_SETTINGS_PROVIDER_ID, legacyProviderId};
    }

    public static boolean isProviderCompatible(String providerId, ICConfigurationDescription cfgDescription) {
        if (cfgDescription != null) {
            boolean useScannerInfoProviderExtension;
            boolean bl = useScannerInfoProviderExtension = new ScannerInfoExtensionLanguageSettingsProvider().getScannerInfoProvider(cfgDescription) != null;
            if (SI_LANGUAGE_SETTINGS_PROVIDER_ID.equals(providerId)) {
                return useScannerInfoProviderExtension;
            }
            boolean isNewStyleCfg = CProjectDescriptionManager.getInstance().isNewStyleCfg(cfgDescription);
            if (MBS_LANGUAGE_SETTINGS_PROVIDER_ID.equals(providerId)) {
                return !useScannerInfoProviderExtension && isNewStyleCfg;
            }
            if (PATH_ENTRY_MANAGER_LANGUAGE_SETTINGS_PROVIDER_ID.equals(providerId)) {
                return !useScannerInfoProviderExtension && !isNewStyleCfg;
            }
        }
        return true;
    }

    public static void defineLanguageSettingsEnablement(IProject project) {
        if (project != null && !ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityDefined(project)) {
            boolean isPreferenceEnabled = ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled(null);
            ScannerDiscoveryLegacySupport.setLanguageSettingsProvidersFunctionalityEnabled(project, isPreferenceEnabled);
        }
    }

    public static String getDeprecatedLegacyProfiles(String id) {
        if (legacyProfiles == null) {
            legacyProfiles = new HashMap<String, String>();
            legacyProfiles.put("cdt.managedbuild.tool.gnu.c.compiler.input", "org.eclipse.cdt.managedbuilder.core.GCCManagedMakePerProjectProfileC|org.eclipse.cdt.make.core.GCCStandardMakePerFileProfile");
            legacyProfiles.put("cdt.managedbuild.tool.gnu.cpp.compiler.input", "org.eclipse.cdt.managedbuilder.core.GCCManagedMakePerProjectProfileCPP|org.eclipse.cdt.make.core.GCCStandardMakePerFileProfile");
            legacyProfiles.put("cdt.managedbuild.tool.gnu.c.compiler.input.cygwin", "org.eclipse.cdt.managedbuilder.core.GCCWinManagedMakePerProjectProfileC");
            legacyProfiles.put("cdt.managedbuild.tool.gnu.cpp.compiler.input.cygwin", "org.eclipse.cdt.managedbuilder.core.GCCWinManagedMakePerProjectProfileCPP");
            legacyProfiles.put("cdt.managedbuild.tool.xlc.c.compiler.input", "org.eclipse.cdt.managedbuilder.xlc.core.XLCManagedMakePerProjectProfile");
            legacyProfiles.put("cdt.managedbuild.tool.xlc.cpp.c.compiler.input", "org.eclipse.cdt.managedbuilder.xlc.core.XLCManagedMakePerProjectProfile");
            legacyProfiles.put("cdt.managedbuild.tool.xlc.cpp.compiler.input", "org.eclipse.cdt.managedbuilder.xlc.core.XLCManagedMakePerProjectProfileCPP");
        }
        return legacyProfiles.get(id);
    }
}

