/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast.cpp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class SemanticQueries {
    public static boolean isCopyOrMoveConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveConstructorKind.COPY_OR_MOVE);
    }

    public static boolean isMoveConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveConstructorKind.MOVE);
    }

    public static boolean isCopyConstructor(ICPPConstructor constructor) {
        return SemanticQueries.isCopyOrMoveConstructor(constructor, CopyOrMoveConstructorKind.COPY);
    }

    private static boolean isCopyOrMoveConstructor(ICPPConstructor constructor, CopyOrMoveConstructorKind kind) {
        if (constructor instanceof ICPPFunctionTemplate) {
            return false;
        }
        if (!SemanticQueries.isCallableWithNumberOfArguments(constructor, 1)) {
            return false;
        }
        IType firstArgumentType = constructor.getType().getParameterTypes()[0];
        if (!((firstArgumentType = SemanticUtil.getNestedType(firstArgumentType, 1)) instanceof ICPPReferenceType)) {
            return false;
        }
        ICPPReferenceType firstArgReferenceType = (ICPPReferenceType)firstArgumentType;
        boolean isRvalue = firstArgReferenceType.isRValueReference();
        if (isRvalue && kind == CopyOrMoveConstructorKind.COPY) {
            return false;
        }
        if (!isRvalue && kind == CopyOrMoveConstructorKind.MOVE) {
            return false;
        }
        firstArgumentType = firstArgReferenceType.getType();
        firstArgumentType = SemanticUtil.getNestedType(firstArgumentType, 8);
        ICPPClassType classType = constructor.getClassOwner();
        if (classType instanceof ICPPClassTemplate) {
            classType = CPPTemplates.createDeferredInstance((ICPPClassTemplate)classType);
        }
        return firstArgumentType.isSameType(classType);
    }

    private static boolean isCallableWithNumberOfArguments(ICPPFunction function, int numArguments) {
        return function.getParameters().length >= numArguments && function.getRequiredArgumentCount() <= numArguments;
    }

    public static ICPPMethod[] getPureVirtualMethods(ICPPClassType classType, IASTNode point) {
        return new PureVirtualMethodCollector().collect(classType, point);
    }

    private static enum CopyOrMoveConstructorKind {
        COPY,
        MOVE,
        COPY_OR_MOVE;

    }

    private static class PureVirtualMethodCollector {
        private Map<ICPPClassType, Integer> subobjectNumbers = new HashMap<ICPPClassType, Integer>();
        private Map<ICPPClassType, FinalOverriderMap> virtualBaseCache = new HashMap<ICPPClassType, FinalOverriderMap>();

        private PureVirtualMethodCollector() {
        }

        public ICPPMethod[] collect(ICPPClassType root, IASTNode point) {
            FinalOverriderMap finalOverriderMap = this.collectFinalOverriders(root, false, new HashSet<ICPPClassType>(), point);
            return finalOverriderMap.collectPureVirtualMethods();
        }

        private FinalOverriderMap collectFinalOverriders(ICPPClassType classType, boolean isVirtualBase, Set<ICPPClassType> inheritanceChain, IASTNode point) {
            FinalOverriderMap result = new FinalOverriderMap();
            inheritanceChain.add(classType);
            int subobjectNumber = 0;
            if (!isVirtualBase) {
                Integer lastNumber = this.subobjectNumbers.get(classType);
                subobjectNumber = (lastNumber == null ? 0 : lastNumber) + 1;
                this.subobjectNumbers.put(classType, subobjectNumber);
            }
            ICPPBase[] iCPPBaseArray = ClassTypeHelper.getBases(classType, point);
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassType baseType;
                ICPPBase base = iCPPBaseArray[n2];
                IBinding baseClass = base.getBaseClass();
                if (baseClass instanceof ICPPClassType && !inheritanceChain.contains(baseType = (ICPPClassType)baseClass)) {
                    FinalOverriderMap baseOverriderMap;
                    if (base.isVirtual()) {
                        baseOverriderMap = this.virtualBaseCache.get(baseType);
                        if (baseOverriderMap == null) {
                            baseOverriderMap = this.collectFinalOverriders(baseType, true, inheritanceChain, point);
                        }
                    } else {
                        baseOverriderMap = this.collectFinalOverriders(baseType, false, inheritanceChain, point);
                    }
                    result.addOverriders(baseOverriderMap);
                }
                ++n2;
            }
            for (ICPPMethod method : ClassTypeHelper.getOwnMethods(classType, point)) {
                ICPPMethod[] overriddenMethods;
                result.add(method, subobjectNumber, method);
                ICPPMethod[] iCPPMethodArray = overriddenMethods = ClassTypeHelper.findOverridden(method, point);
                int n3 = overriddenMethods.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICPPMethod overriddenMethod = iCPPMethodArray[n4];
                    result.replaceForAllSubobjects(overriddenMethod, method);
                    ++n4;
                }
            }
            inheritanceChain.remove(classType);
            return result;
        }

        private static class FinalOverriderMap {
            private Map<ICPPMethod, Map<Integer, ICPPMethod>> fMap = new HashMap<ICPPMethod, Map<Integer, ICPPMethod>>();

            private FinalOverriderMap() {
            }

            public void add(ICPPMethod method, int subobjectNumber, ICPPMethod overrider) {
                Map<Integer, ICPPMethod> overriders = this.fMap.get(method);
                if (overriders == null) {
                    overriders = new HashMap<Integer, ICPPMethod>();
                    this.fMap.put(method, overriders);
                }
                overriders.put(subobjectNumber, overrider);
            }

            public void replaceForAllSubobjects(ICPPMethod method, ICPPMethod overrider) {
                Map<Integer, ICPPMethod> overriders = this.fMap.get(method);
                if (overriders == null) {
                    return;
                }
                for (Integer i : overriders.keySet()) {
                    overriders.put(i, overrider);
                }
            }

            public void addOverriders(FinalOverriderMap other) {
                for (ICPPMethod method : other.fMap.keySet()) {
                    Map<Integer, ICPPMethod> overriders = this.fMap.get(method);
                    if (overriders == null) {
                        overriders = new HashMap<Integer, ICPPMethod>();
                        this.fMap.put(method, overriders);
                    }
                    Map<Integer, ICPPMethod> otherOverriders = other.fMap.get(method);
                    for (Integer i : otherOverriders.keySet()) {
                        ICPPMethod overrider = otherOverriders.get(i);
                        overriders.put(i, overrider);
                    }
                }
            }

            public ICPPMethod[] collectPureVirtualMethods() {
                ArrayList<ICPPMethod> pureVirtualMethods = new ArrayList<ICPPMethod>();
                for (ICPPMethod method : this.fMap.keySet()) {
                    if (!method.isPureVirtual()) continue;
                    Map<Integer, ICPPMethod> finalOverriders = this.fMap.get(method);
                    for (Integer subobjectNumber : finalOverriders.keySet()) {
                        ICPPMethod finalOverrider = finalOverriders.get(subobjectNumber);
                        if (finalOverrider != method) continue;
                        pureVirtualMethods.add(method);
                    }
                }
                return pureVirtualMethods.toArray(new ICPPMethod[pureVirtualMethods.size()]);
            }
        }
    }
}

