/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;

public class ChangeString
extends MiniEdit {
    private String pending;
    private char[] insertedChars;
    private final int offset;
    private final TextRun run;
    private final boolean overwrite;
    private String overwrittenText;

    public ChangeString(TextRun run, String c, int offset, boolean overwrite) {
        this.run = run;
        this.pending = c;
        this.offset = offset;
        this.overwrite = overwrite;
    }

    public void appendText(String append) {
        Assert.isTrue((this.pending == null ? 1 : 0) != 0);
        this.pending = append;
    }

    @Override
    public void apply() {
        if (this.overwrite) {
            this.overwrittenText = this.run.overwriteText(this.pending, this.offset);
        } else {
            this.run.insertText(this.pending, this.offset);
        }
        this.insertedChars = this.pending.toCharArray();
        this.pending = null;
    }

    @Override
    public boolean canApply() {
        return this.pending != null;
    }

    public void commitPending() {
        if (this.overwrite) {
            this.overwrittenText = String.valueOf(this.overwrittenText) + this.run.overwriteText(this.pending, this.offset + this.insertedChars.length);
        } else {
            this.run.insertText(this.pending, this.offset + this.insertedChars.length);
        }
        char[] old = this.insertedChars;
        this.insertedChars = new char[old.length + 1];
        System.arraycopy(old, 0, this.insertedChars, 0, old.length);
        this.insertedChars[this.insertedChars.length - 1] = this.pending.toCharArray()[0];
        this.pending = null;
    }

    @Override
    public ModelLocation getResultingLocation() {
        return new ModelLocation(this.run, this.offset + this.insertedChars.length);
    }

    @Override
    public void reapply() {
        if (this.overwrite) {
            this.overwrittenText = this.run.overwriteText(new String(this.insertedChars), this.offset);
        } else {
            this.run.insertText(new String(this.insertedChars), this.offset);
        }
    }

    @Override
    public void rollback() {
        if (this.overwrite) {
            this.run.overwriteText(this.overwrittenText, this.offset);
            this.overwrittenText = null;
        } else {
            this.run.removeRange(this.offset, this.insertedChars.length);
        }
    }
}

