/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.exampleUses;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.BoxLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.exampleStructures.SimpleGraph;
import org.eclipse.zest.layouts.exampleStructures.SimpleNode;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;
import org.eclipse.zest.layouts.exampleUses.Messages;
import org.eclipse.zest.layouts.interfaces.LayoutContext;

public class SimpleSWTExample {
    private static final Color BLACK = new Color((Device)Display.getDefault(), 0, 0, 0);
    private static final Color NODE_NORMAL_COLOR = new Color((Device)Display.getDefault(), 225, 225, 255);
    private static final Color NODE_SELECTED_COLOR = new Color((Device)Display.getDefault(), 255, 125, 125);
    private static final Color NODE_ADJACENT_COLOR = new Color((Device)Display.getDefault(), 255, 200, 125);
    private static final Color BORDER_NORMAL_COLOR = new Color((Device)Display.getDefault(), 0, 0, 0);
    private static final Color BORDER_SELECTED_COLOR = new Color((Device)Display.getDefault(), 255, 0, 0);
    private static final Color BORDER_ADJACENT_COLOR = new Color((Device)Display.getDefault(), 255, 128, 0);
    private static final Color RELATIONSHIP_COLOR = new Color((Device)Display.getDefault(), 192, 192, 225);
    private static final Color RELATIONSHIP_HIGHLIGHT_COLOR = new Color((Device)Display.getDefault(), 255, 200, 125);
    private static final String[] NAMES = new String[]{"Peggy", "Rob", "Ian", "Chris", "Simon", "Wendy", "Steven", "Kim", "Neil", "Dave", "John", "Suzanne", "Jody", "Casey", "Bjorn", "Peter", "Erin", "Lisa", "Jennie", "Liz", "Bert", "Ryan", "Nick", "Amy", "Lee", "Me", "You", "Max", "NCI", "OWL", "Ed", "Jamie", "Protege", "Matt", "Bryan", "Pete", "Sam", "Bob", "Katie", "Bill", "Josh", "Davor", "Ken", "Jacob", "Norm", "Jim", "Maya", "Jill", "Kit", "Jo", "Joe", "Andrew", "Charles", "Pat", "Patrick", "Jeremy", "Mike", "Michael", "Patricia", "Marg", "Terry", "Emily", "Ben", "Holly", "Joanna", "Joanne", "Evan", "Tom", "Dan", "Eric", "Corey", "Meghan", "Kevin", "Nina", "Ron", "Daniel", "David", "Jeff", "Nathan", "Amanda", "Phil", "Tricia", "Steph", "Stewart", "Stuart", "Bull", "Lintern", "Callendar", "Thompson", "Rigby", "Adam", "Judith", "Cynthia", "Sarah", "Sara", "Roger", "Andy", "Kris", "Mark", "Shane", "Spence", "Ivy", "Ivanna", "Julie", "Justin", "Emile", "Toby", "Robin", "Rich", "Kathy", "Cathy", "Nicky", "Ricky", "Danny", "Anne", "Ann", "Jen", "Robert", "Calvin", "Alvin", "Scott", "Kumar"};
    private static final int INITIAL_PANEL_WIDTH = 800;
    private static final int INITIAL_PANEL_HEIGHT = 600;
    private static final double INITIAL_NODE_WIDTH = 20.0;
    private static final double INITIAL_NODE_HEIGHT = 15.0;
    protected static List<LayoutAlgorithm> algorithms = List.of(new SpringLayoutAlgorithm(), new TreeLayoutAlgorithm(), new TreeLayoutAlgorithm(3), new RadialLayoutAlgorithm(), new GridLayoutAlgorithm(), new BoxLayoutAlgorithm(256), new BoxLayoutAlgorithm(512));
    protected static List<String> algorithmNames = List.of(Messages.getString("SimpleSWTExample.SpringLayout"), Messages.getString("SimpleSWTExample.TreeVLayout"), Messages.getString("SimpleSWTExample.TreeHLayout"), Messages.getString("SimpleSWTExample.RadialLayout"), Messages.getString("SimpleSWTExample.GridLayout"), Messages.getString("SimpleSWTExample.HorizontalLayout"), Messages.getString("SimpleSWTExample.VerticalLayout"));
    private final Shell mainShell;
    private Composite mainComposite;
    private final ToolBar toolBar;
    private LayoutAlgorithm currentLayoutAlgorithm;
    protected SimpleNode selectedEntity;
    protected SimpleNode hoverEntity;
    private SimpleGraph graph;
    protected Point mouseDownPoint;
    protected Point selectedEntityPositionAtMouseDown;
    private long idCount = 0L;
    IProgressMonitor progressMonitor = null;
    ProgressMonitorDialog pmd = null;
    boolean GUI_UPDATING = false;
    static int lastUpdateCall = 0;
    private int repeats = 0;
    static Display display = null;

    public SimpleSWTExample(Display display) {
        this.mainShell = new Shell(display);
        this.mainShell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SimpleSWTExample.this.mainShell.layout(true);
            }
        });
        this.mainShell.setLayout((Layout)new GridLayout());
        this.toolBar = new ToolBar((Composite)this.mainShell, 256);
        this.toolBar.setLayoutData((Object)new GridData(0x1000000, 1, true, false));
        this.toolBar.setLayout((Layout)new FillLayout(256));
        int i = 0;
        while (i < algorithms.size()) {
            final LayoutAlgorithm algorithm = algorithms.get(i);
            String algorithmName = algorithmNames.get(i);
            ToolItem algorithmButton = new ToolItem(this.toolBar, 8);
            algorithmButton.setText(algorithmName);
            new ToolItem(this.toolBar, 2);
            algorithmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SimpleSWTExample.this.currentLayoutAlgorithm = algorithm;
                    SimpleSWTExample.this.performLayout(false);
                }
            });
            ++i;
        }
        ToolItem redrawButton = new ToolItem(this.toolBar, 8);
        redrawButton.setText(Messages.getString("SimpleSWTExample.Redraw"));
        redrawButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleSWTExample.this.mainComposite.redraw();
            }
        });
        this.createMainPanel();
        SimpleNode.setNodeColors(NODE_NORMAL_COLOR, BORDER_NORMAL_COLOR, NODE_SELECTED_COLOR, NODE_ADJACENT_COLOR, BORDER_SELECTED_COLOR, BORDER_ADJACENT_COLOR);
        SimpleRelationship.setDefaultColor(RELATIONSHIP_COLOR);
        SimpleRelationship.setDefaultHighlightColor(RELATIONSHIP_HIGHLIGHT_COLOR);
        this.createTreeGraph(4, 3, false);
        this.mainShell.pack();
    }

    private void performLayout(boolean placeRandomly) {
        if (placeRandomly) {
            this.placeRandomly();
        }
        Rectangle bounds = this.mainComposite.getClientArea();
        this.graph.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        this.currentLayoutAlgorithm.setLayoutContext((LayoutContext)this.graph);
        this.currentLayoutAlgorithm.applyLayout(true);
        this.updateGUI();
    }

    private Shell getShell() {
        return this.mainShell;
    }

    private void createMainPanel() {
        this.mainComposite = new Canvas((Composite)this.mainShell, 262144);
        GridData mainGridData = new GridData(4, 4, true, true);
        mainGridData.widthHint = 800;
        mainGridData.heightHint = 600;
        this.mainComposite.setLayoutData((Object)mainGridData);
        this.mainComposite.addPaintListener((PaintListener)new GraphPaintListener());
        this.mainComposite.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        this.mainComposite.setLayout(null);
        this.mainComposite.addMouseMoveListener(e -> {
            if (this.selectedEntity == null) {
                SimpleNode oldEntity = this.hoverEntity;
                this.hoverEntity = null;
                SimpleNode[] simpleNodeArray = this.graph.getNodes();
                int n = simpleNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    double h;
                    double w;
                    double y;
                    SimpleNode entity = simpleNodeArray[n2];
                    double x = entity.getX();
                    Rectangle rect = new Rectangle((int)x, (int)(y = entity.getY()), (int)(w = entity.getWidth()), (int)(h = entity.getHeight()));
                    if (rect.contains(e.x, e.y)) {
                        this.hoverEntity = entity;
                        this.hoverEntity.ignoreInLayout(true);
                        this.hoverEntity.setSelected();
                        break;
                    }
                    ++n2;
                }
                if (oldEntity != null && oldEntity != this.hoverEntity) {
                    oldEntity.ignoreInLayout(false);
                    oldEntity.setUnSelected();
                }
            }
        });
        this.mainComposite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SimpleSWTExample.this.selectedEntity = null;
                SimpleSWTExample.this.hoverEntity = null;
                SimpleNode[] simpleNodeArray = SimpleSWTExample.this.graph.getNodes();
                int n = simpleNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    double h;
                    double w;
                    double y;
                    SimpleNode entity = simpleNodeArray[n2];
                    double x = entity.getX();
                    Rectangle rect = new Rectangle((int)x, (int)(y = entity.getY()), (int)(w = entity.getWidth()), (int)(h = entity.getHeight()));
                    if (rect.contains(e.x, e.y)) {
                        SimpleSWTExample.this.selectedEntity = entity;
                        break;
                    }
                    ++n2;
                }
                if (SimpleSWTExample.this.selectedEntity != null) {
                    SimpleSWTExample.this.mouseDownPoint = new Point(e.x, e.y);
                    SimpleSWTExample.this.selectedEntityPositionAtMouseDown = new Point((int)SimpleSWTExample.this.selectedEntity.getX(), (int)SimpleSWTExample.this.selectedEntity.getY());
                    SimpleSWTExample.this.selectedEntity.ignoreInLayout(true);
                    SimpleSWTExample.this.selectedEntity.setSelected();
                } else {
                    SimpleSWTExample.this.mouseDownPoint = null;
                    SimpleSWTExample.this.selectedEntityPositionAtMouseDown = null;
                }
                SimpleSWTExample.this.mainComposite.redraw();
            }

            public void mouseUp(MouseEvent e) {
                if (SimpleSWTExample.this.selectedEntity != null) {
                    SimpleRelationship rel;
                    SimpleSWTExample.this.selectedEntity.ignoreInLayout(false);
                    SimpleSWTExample.this.selectedEntity.setUnSelected();
                    List<SimpleNode> relatedNodes = SimpleSWTExample.this.selectedEntity.getRelatedEntities();
                    for (SimpleNode element : relatedNodes) {
                        element.setUnSelected();
                    }
                    SimpleRelationship[] simpleRelationshipArray = SimpleSWTExample.this.selectedEntity.getOutgoingConnections();
                    int n = simpleRelationshipArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        rel = simpleRelationshipArray[n2];
                        rel.resetLineWidth();
                        ++n2;
                    }
                    simpleRelationshipArray = SimpleSWTExample.this.selectedEntity.getIncomingConnections();
                    n = simpleRelationshipArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        rel = simpleRelationshipArray[n2];
                        rel.resetLineWidth();
                        ++n2;
                    }
                }
                SimpleSWTExample.this.selectedEntity = null;
                SimpleSWTExample.this.mouseDownPoint = null;
                SimpleSWTExample.this.selectedEntityPositionAtMouseDown = null;
            }
        });
        this.mainComposite.addMouseMoveListener(e -> {
            if (this.selectedEntity != null && this.mouseDownPoint != null) {
                double dx = e.x - this.mouseDownPoint.x;
                double dy = e.y - this.mouseDownPoint.y;
                this.selectedEntity.ignoreInLayout(false);
                this.selectedEntity.setLocation((double)this.selectedEntityPositionAtMouseDown.x + dx, (double)this.selectedEntityPositionAtMouseDown.y + dy);
                this.selectedEntity.ignoreInLayout(true);
                this.mainComposite.redraw();
            }
        });
        this.mainComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (SimpleSWTExample.this.currentLayoutAlgorithm != null) {
                    SimpleSWTExample.this.performLayout(false);
                }
            }
        });
    }

    private void createTreeGraph(int maxLevels, int maxChildren, boolean random) {
        this.graph = new SimpleGraph();
        SimpleNode root = this.createSimpleNode(this.getNextID());
        this.graph.addEntity(root);
        SimpleNode root2 = this.createSimpleNode(this.getNextID());
        this.graph.addEntity(root2);
        SimpleNode currentParent = this.createSimpleNode(this.getNextID());
        this.graph.addEntity(currentParent);
        SimpleRelationship rel = new SimpleRelationship(root, currentParent, false);
        this.graph.addRelationship(rel);
        rel = new SimpleRelationship(root2, currentParent, false);
        this.graph.addRelationship(rel);
        int levels = random ? (int)(Math.random() * (double)maxLevels + 1.0) : maxLevels;
        this.createTreeGraphRecursive(currentParent, maxChildren, levels, 1, random);
    }

    private void createTreeGraphRecursive(SimpleNode currentParentNode, int maxChildren, int maxLevel, int level, boolean random) {
        if (level > maxLevel) {
            return;
        }
        int numChildren = random ? (int)(Math.random() * (double)maxChildren + 1.0) : maxChildren;
        int child = 0;
        while (child < numChildren) {
            SimpleNode childNode = this.createSimpleNode(this.getNextID());
            this.graph.addEntity(childNode);
            SimpleRelationship rel = new SimpleRelationship(currentParentNode, childNode, false);
            this.graph.addRelationship(rel);
            SimpleRelationship.setDefaultSize(2);
            this.createTreeGraphRecursive(childNode, maxChildren, maxLevel, level + 1, random);
            ++child;
        }
    }

    private String getNextID() {
        if (this.idCount >= (long)NAMES.length) {
            this.idCount = 0L;
            ++this.repeats;
        }
        Object id = NAMES[(int)this.idCount];
        if (this.repeats > 0) {
            id = (String)id + "_" + this.repeats;
        }
        ++this.idCount;
        return id;
    }

    private void placeRandomly() {
        SimpleNode[] simpleNodeArray = this.graph.getNodes();
        int n = simpleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleNode simpleNode = simpleNodeArray[n2];
            double x = Math.random() * 800.0 - 20.0;
            double y = Math.random() * 600.0 - 15.0;
            simpleNode.setLocation(x, y);
            ++n2;
        }
    }

    private SimpleNode createSimpleNode(String name) {
        SimpleNode simpleNode = new SimpleNode(name, this.graph);
        int w = name.length() * 8;
        simpleNode.setSize(Math.max((double)w, 20.0), 15.0);
        return simpleNode;
    }

    private void updateGUI() {
        if (!this.mainComposite.isDisposed()) {
            this.mainComposite.redraw();
        }
    }

    public static void main(String[] args) {
        display = Display.getDefault();
        SimpleSWTExample simpleSWTExample = new SimpleSWTExample(display);
        Shell shell = simpleSWTExample.getShell();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private class GraphPaintListener
    implements PaintListener {
        private GraphPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            Image imageBuffer;
            if (Display.getDefault() == null || e.width == 0 || e.height == 0) {
                return;
            }
            try {
                imageBuffer = new Image((Device)Display.getDefault(), e.width, e.height);
            }
            catch (SWTError noMoreHandles) {
                Object imageBuffer2 = null;
                noMoreHandles.printStackTrace();
                return;
            }
            catch (IllegalArgumentException tooBig) {
                Object imageBuffer3 = null;
                tooBig.printStackTrace();
                return;
            }
            GC gcBuffer = new GC((Drawable)imageBuffer);
            Object[] objectArray = SimpleSWTExample.this.graph.getConnections();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleRelationship rel = objectArray[n2];
                SimpleNode src = rel.getSource();
                SimpleNode dest = rel.getTarget();
                if (src.equals(SimpleSWTExample.this.selectedEntity)) {
                    dest.setAdjacent();
                    rel.setSelected();
                } else if (dest.equals(SimpleSWTExample.this.selectedEntity)) {
                    src.setAdjacent();
                    rel.setSelected();
                } else {
                    rel.setUnSelected();
                }
                double srcX = src.getX() + src.getWidth() / 2.0;
                double srcY = src.getY() + src.getHeight() / 2.0;
                double destX = dest.getX() + dest.getWidth() / 2.0;
                double destY = dest.getY() + dest.getHeight() / 2.0;
                this.drawEdge(srcX, srcY, destX, destY, rel, gcBuffer);
                ++n2;
            }
            objectArray = SimpleSWTExample.this.graph.getNodes();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                String name = ((SimpleNode)entity).toString();
                Point textSize = gcBuffer.stringExtent(name);
                int entityX = (int)((SimpleNode)entity).getX();
                int entityY = (int)((SimpleNode)entity).getY();
                int entityWidth = Math.max((int)((SimpleNode)entity).getWidth(), textSize.x + 8);
                int entityHeight = Math.max((int)((SimpleNode)entity).getHeight(), textSize.y + 2);
                gcBuffer.setBackground((Color)((SimpleNode)entity).getColor());
                gcBuffer.fillRoundRectangle(entityX, entityY, entityWidth, entityHeight, 8, 8);
                int x = (int)((double)entityX + (double)entityWidth / 2.0) - textSize.x / 2;
                gcBuffer.setForeground(BLACK);
                gcBuffer.drawString(name, x, entityY);
                gcBuffer.setForeground((Color)((SimpleNode)entity).getBorderColor());
                gcBuffer.setLineWidth(((SimpleNode)entity).getBorderWidth());
                gcBuffer.drawRoundRectangle(entityX, entityY, entityWidth, entityHeight, 8, 8);
                ++n2;
            }
            e.gc.drawImage(imageBuffer, 0, 0);
            imageBuffer.dispose();
            gcBuffer.dispose();
        }

        private void drawEdge(double srcX, double srcY, double destX, double destY, SimpleRelationship rel, GC gcBuffer) {
            gcBuffer.setForeground((Color)rel.getColor());
            gcBuffer.setLineWidth(rel.getLineWidth());
            gcBuffer.drawLine((int)srcX, (int)srcY, (int)destX, (int)destY);
        }
    }
}

