/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.shapes.model.commands;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.shapes.ShapesExampleMessages;
import org.eclipse.gef.examples.shapes.model.Connection;
import org.eclipse.gef.examples.shapes.model.Shape;
import org.eclipse.gef.examples.shapes.model.ShapesDiagram;

public class ShapeDeleteCommand
extends Command {
    private final Shape child;
    private final ShapesDiagram parent;
    private List<Connection> sourceConnections;
    private List<Connection> targetConnections;
    private boolean wasRemoved;

    public ShapeDeleteCommand(ShapesDiagram parent, Shape child) {
        if (parent == null || child == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(ShapesExampleMessages.ShapeDeleteCommand_ShapeDeletion);
        this.parent = parent;
        this.child = child;
    }

    private static void addConnections(List<Connection> connections) {
        connections.forEach(Connection::reconnect);
    }

    public boolean canUndo() {
        return this.wasRemoved;
    }

    public void execute() {
        this.sourceConnections = this.child.getSourceConnections();
        this.targetConnections = this.child.getTargetConnections();
        this.redo();
    }

    public void redo() {
        this.wasRemoved = this.parent.removeChild(this.child);
        if (this.wasRemoved) {
            ShapeDeleteCommand.removeConnections(this.sourceConnections);
            ShapeDeleteCommand.removeConnections(this.targetConnections);
        }
    }

    private static void removeConnections(List<Connection> connections) {
        connections.forEach(Connection::disconnect);
    }

    public void undo() {
        if (this.parent.addChild(this.child)) {
            ShapeDeleteCommand.addConnections(this.sourceConnections);
            ShapeDeleteCommand.addConnections(this.targetConnections);
        }
    }
}

