/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.rulers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicRuler;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.commands.CreateGuideCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.DeleteGuideCommand;
import org.eclipse.gef.examples.logicdesigner.model.commands.MoveGuideCommand;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;

public class LogicRulerProvider
extends RulerProvider {
    private LogicRuler ruler;
    private PropertyChangeListener rulerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("children changed")) {
                LogicGuide guide = (LogicGuide)evt.getNewValue();
                if (LogicRulerProvider.this.getGuides().contains(guide)) {
                    guide.addPropertyChangeListener(LogicRulerProvider.this.guideListener);
                } else {
                    guide.removePropertyChangeListener(LogicRulerProvider.this.guideListener);
                }
                for (RulerChangeListener listener : LogicRulerProvider.this.listeners) {
                    listener.notifyGuideReparented((Object)guide);
                }
            } else {
                for (RulerChangeListener listener : LogicRulerProvider.this.listeners) {
                    listener.notifyUnitsChanged(LogicRulerProvider.this.ruler.getUnit());
                }
            }
        }
    };
    private PropertyChangeListener guideListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("subparts changed")) {
                for (RulerChangeListener listener : LogicRulerProvider.this.listeners) {
                    listener.notifyPartAttachmentChanged(evt.getNewValue(), evt.getSource());
                }
            } else {
                for (RulerChangeListener listener : LogicRulerProvider.this.listeners) {
                    listener.notifyGuideMoved(evt.getSource());
                }
            }
        }
    };

    public LogicRulerProvider(LogicRuler ruler) {
        this.ruler = ruler;
        this.ruler.addPropertyChangeListener(this.rulerListener);
        this.getGuides().forEach(guide -> guide.addPropertyChangeListener(this.guideListener));
    }

    public List<LogicSubpart> getAttachedModelObjects(Object guide) {
        return new ArrayList<LogicSubpart>(((LogicGuide)guide).getParts());
    }

    public Command getCreateGuideCommand(int position) {
        return new CreateGuideCommand(this.ruler, position);
    }

    public Command getDeleteGuideCommand(Object guide) {
        return new DeleteGuideCommand((LogicGuide)guide, this.ruler);
    }

    public Command getMoveGuideCommand(Object guide, int pDelta) {
        return new MoveGuideCommand((LogicGuide)guide, pDelta);
    }

    public int[] getGuidePositions() {
        List<LogicGuide> guides = this.getGuides();
        int[] result = new int[guides.size()];
        int i = 0;
        while (i < guides.size()) {
            result[i] = guides.get(i).getPosition();
            ++i;
        }
        return result;
    }

    public Object getRuler() {
        return this.ruler;
    }

    public int getUnit() {
        return this.ruler.getUnit();
    }

    public void setUnit(int newUnit) {
        this.ruler.setUnit(newUnit);
    }

    public int getGuidePosition(Object guide) {
        return ((LogicGuide)guide).getPosition();
    }

    public List<LogicGuide> getGuides() {
        return this.ruler.getGuides();
    }
}

