/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.exampleStructures;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.widgets.Item;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.exampleStructures.SimpleGraph;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;
import org.eclipse.zest.layouts.interfaces.NodeLayout;
import org.eclipse.zest.layouts.interfaces.SubgraphLayout;

public class SimpleNode
implements NodeLayout {
    private static Object NODE_NORMAL_COLOR;
    private static Object NODE_SELECTED_COLOR;
    private static Object NODE_ADJACENT_COLOR;
    private static Object BORDER_NORMAL_COLOR;
    private static Object BORDER_SELECTED_COLOR;
    private static Object BORDER_ADJACENT_COLOR;
    private static final int BORDER_NORMAL_STROKE = 1;
    private static final int BORDER_STROKE_SELECTED = 2;
    protected DisplayIndependentPoint location;
    protected DisplayIndependentDimension size;
    protected Object realObject;
    private boolean ignoreInLayout = false;
    private Object colour = null;
    private Object borderColor = null;
    private int borderWidth;
    private final SimpleGraph graph;
    private boolean minimized;

    public SimpleNode(Object realObject, SimpleGraph graph) {
        this.realObject = realObject;
        this.graph = graph;
        this.location = new DisplayIndependentPoint(-1.0, -1.0);
        this.size = new DisplayIndependentDimension(110.0, 110.0);
        this.borderWidth = 1;
        this.colour = NODE_NORMAL_COLOR;
        this.borderColor = BORDER_NORMAL_COLOR;
    }

    public static void setNodeColors(Object nodeNormalColor, Object borderNormalColor, Object nodeSelectedColor, Object nodeAdjacentColor, Object borderSelectedColor, Object borderAdjacentColor) {
        NODE_NORMAL_COLOR = nodeNormalColor;
        BORDER_NORMAL_COLOR = borderNormalColor;
        NODE_SELECTED_COLOR = nodeSelectedColor;
        NODE_ADJACENT_COLOR = nodeAdjacentColor;
        BORDER_SELECTED_COLOR = borderSelectedColor;
        BORDER_ADJACENT_COLOR = borderAdjacentColor;
    }

    public List<SimpleNode> getRelatedEntities() {
        LinkedList<SimpleNode> listOfRelatedEntities = new LinkedList<SimpleNode>();
        SimpleRelationship[] simpleRelationshipArray = this.graph.getConnections();
        int n = simpleRelationshipArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleRelationship rel = simpleRelationshipArray[n2];
            if (rel.getSource() != this) {
                listOfRelatedEntities.add(rel.getSource());
            }
            if (rel.getTarget() != this) {
                listOfRelatedEntities.add(rel.getTarget());
            }
            ++n2;
        }
        return listOfRelatedEntities;
    }

    public void ignoreInLayout(boolean ignore) {
        this.ignoreInLayout = ignore;
    }

    public Object getRealObject() {
        return this.realObject;
    }

    public double getX() {
        return this.getLocation().x;
    }

    public double getY() {
        return this.getLocation().y;
    }

    public double getWidth() {
        return this.getSize().width;
    }

    public double getHeight() {
        return this.getSize().height;
    }

    public DisplayIndependentDimension getSize() {
        return this.size;
    }

    public void setSize(double width, double height) {
        if (!this.ignoreInLayout) {
            this.size.width = width;
            this.size.height = height;
        }
    }

    public DisplayIndependentPoint getLocation() {
        return this.location;
    }

    public void setLocation(double x, double y) {
        if (!this.ignoreInLayout) {
            this.location.x = x;
            this.location.y = y;
        }
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)object;
            result = this.realObject.equals(node.getRealObject());
        }
        return result;
    }

    public int hashCode() {
        return this.realObject.hashCode();
    }

    public String toString() {
        return this.realObject.toString();
    }

    public void setSelected() {
        this.colour = NODE_SELECTED_COLOR;
        this.borderColor = BORDER_SELECTED_COLOR;
        this.borderWidth = 2;
    }

    public void setUnSelected() {
        this.colour = NODE_NORMAL_COLOR;
        this.borderColor = BORDER_NORMAL_COLOR;
        this.borderWidth = 1;
    }

    public void setAdjacent() {
        this.colour = NODE_ADJACENT_COLOR;
        this.borderColor = BORDER_ADJACENT_COLOR;
        this.borderWidth = 2;
    }

    public Object getColor() {
        return this.colour;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Object getBorderColor() {
        return this.borderColor;
    }

    public double getPreferredAspectRatio() {
        return 0.0;
    }

    public boolean isResizable() {
        return true;
    }

    public boolean isMovable() {
        return true;
    }

    public SimpleNode[] getSuccessingEntities() {
        return this.getSuccessingNodes();
    }

    public SimpleNode[] getPredecessingEntities() {
        return this.getPredecessingNodes();
    }

    public Item[] getItems() {
        return null;
    }

    public boolean isPrunable() {
        return false;
    }

    public boolean isPruned() {
        return false;
    }

    public SubgraphLayout getSubgraph() {
        return null;
    }

    public void prune(SubgraphLayout subgraph) {
    }

    public SimpleNode[] getSuccessingNodes() {
        ArrayList<SimpleNode> successors = new ArrayList<SimpleNode>();
        SimpleRelationship[] simpleRelationshipArray = this.graph.getConnections();
        int n = simpleRelationshipArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleRelationship relationship = simpleRelationshipArray[n2];
            if (relationship.getSource() == this) {
                successors.add(relationship.getTarget());
            }
            ++n2;
        }
        return (SimpleNode[])successors.toArray(SimpleNode[]::new);
    }

    public SimpleNode[] getPredecessingNodes() {
        ArrayList<SimpleNode> predecessors = new ArrayList<SimpleNode>();
        SimpleRelationship[] simpleRelationshipArray = this.graph.getConnections();
        int n = simpleRelationshipArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleRelationship relationship = simpleRelationshipArray[n2];
            if (relationship.getTarget() == this) {
                predecessors.add(relationship.getSource());
            }
            ++n2;
        }
        return (SimpleNode[])predecessors.toArray(SimpleNode[]::new);
    }

    public void setMinimized(boolean minimized) {
        this.minimized = minimized;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public SimpleRelationship[] getIncomingConnections() {
        ArrayList<SimpleRelationship> relationships = new ArrayList<SimpleRelationship>();
        SimpleRelationship[] simpleRelationshipArray = this.graph.getConnections();
        int n = simpleRelationshipArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleRelationship relationship = simpleRelationshipArray[n2];
            if (relationship.getTarget() == this) {
                relationships.add(relationship);
            }
            ++n2;
        }
        return (SimpleRelationship[])relationships.toArray(SimpleRelationship[]::new);
    }

    public SimpleRelationship[] getOutgoingConnections() {
        ArrayList<SimpleRelationship> relationships = new ArrayList<SimpleRelationship>();
        SimpleRelationship[] simpleRelationshipArray = this.graph.getConnections();
        int n = simpleRelationshipArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleRelationship relationship = simpleRelationshipArray[n2];
            if (relationship.getSource() == this) {
                relationships.add(relationship);
            }
            ++n2;
        }
        return (SimpleRelationship[])relationships.toArray(SimpleRelationship[]::new);
    }
}

