/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.ButtonModel;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Toggle;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DetailedLabelFigure;
import org.eclipse.gef.internal.ui.palette.editparts.IPaletteStackEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.PinnablePaletteStackEditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.editparts.IPinnableEditPart;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class ToolEntryEditPart
extends PaletteEditPart {
    private static final String ACTIVE_STATE = "active";
    private DetailedLabelFigure customLabel;
    static final Border TOOLBAR_ITEM_BORDER = new ButtonBorder(ButtonBorder.SCHEMES.TOOLBAR);
    static final Insets LIST_HIGHLIGHT_INSETS = new Insets(1, 5, 2, 0);
    static final Insets ICON_HIGHLIGHT_INSETS = new Insets(2, 1, 2, 1);
    static final Border LIST_BORDER = new MarginBorder(3, 16, 4, 0);
    static final Border ICON_BORDER = new MarginBorder(4, 4, 3, 13);

    public ToolEntryEditPart(PaletteEntry paletteEntry) {
        super(paletteEntry);
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        PinnablePaletteStackEditPart pinPSEP;
        EditPart editPart;
        if (key == IPinnableEditPart.class && (editPart = this.getParent()) instanceof PinnablePaletteStackEditPart && (pinPSEP = (PinnablePaletteStackEditPart)editPart).canBePinned() && ((PaletteStack)this.getParent().getModel()).getActiveEntry().equals(this.getModel())) {
            return key.cast(this.getParent());
        }
        return super.getAdapter(key);
    }

    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            @Override
            public void getDescription(AccessibleEvent e) {
                e.result = ToolEntryEditPart.this.getModel().getDescription();
            }

            @Override
            public void getName(AccessibleEvent e) {
                e.result = ToolEntryEditPart.this.getModel().getLabel();
            }

            @Override
            public void getRole(AccessibleControlEvent e) {
                IPaletteStackEditPart psEP;
                EditPart editPart = ToolEntryEditPart.this.getParent();
                e.detail = editPart instanceof IPaletteStackEditPart && ToolEntryEditPart.this == (psEP = (IPaletteStackEditPart)((Object)editPart)).getActiveEntry() ? 46 : 43;
            }

            @Override
            public void getState(AccessibleControlEvent e) {
                super.getState(e);
                if (ToolEntryEditPart.this.getButtonModel().isSelected()) {
                    e.detail |= 0x10;
                }
            }
        };
    }

    @Override
    public IFigure createFigure() {
        this.customLabel = new DetailedLabelFigure();
        ToolEntryToggle button = new ToolEntryToggle((IFigure)this.customLabel);
        button.addActionListener(event -> this.getViewer().setActiveTool(this.getModel()));
        return button;
    }

    @Override
    public void deactivate() {
        this.customLabel.dispose();
        super.deactivate();
    }

    @Override
    public void eraseTargetFeedback(Request request) {
        if ("selection".equals(request.getType())) {
            this.getButtonModel().setMouseOver(false);
        }
        super.eraseTargetFeedback(request);
    }

    private ButtonModel getButtonModel() {
        Clickable c = (Clickable)this.getFigure();
        return c.getModel();
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        if (SWT.getPlatform().equals("gtk")) {
            return new GTKToggleButtonTracker();
        }
        return new OtherToggleButtonTracker();
    }

    @Override
    public ToolEntry getModel() {
        return (ToolEntry)super.getModel();
    }

    @Override
    protected String getToolTipText() {
        String result = null;
        if (this.getLayoutSetting() != 3) {
            result = super.getToolTipText();
        }
        return result;
    }

    @Override
    protected boolean nameNeededInToolTip() {
        DetailedLabelFigure label = (DetailedLabelFigure)((Object)this.getFigure().getChildren().get(0));
        return label.isNameTruncated() || super.nameNeededInToolTip();
    }

    @Override
    protected void refreshVisuals() {
        ToolEntry entry = this.getModel();
        this.customLabel.setName(entry.getLabel());
        this.customLabel.setDescription(entry.getDescription());
        if (this.getPreferenceSource().useLargeIcons()) {
            this.setImageDescriptor(entry.getLargeIcon());
        } else {
            this.setImageDescriptor(entry.getSmallIcon());
        }
        int layoutMode = this.getLayoutSetting();
        this.customLabel.setLayoutMode(layoutMode);
        if (layoutMode == 1) {
            this.customLabel.setBorder(ICON_BORDER);
        } else if (layoutMode == 0 || layoutMode == 3) {
            this.customLabel.setBorder(LIST_BORDER);
        } else if (layoutMode == 2 && !this.isToolbarItem()) {
            this.customLabel.setBorder(ICON_BORDER);
        } else {
            this.customLabel.setBorder(null);
        }
        super.refreshVisuals();
    }

    @Override
    public void removeNotify() {
        if (this.getButtonModel().isSelected()) {
            this.getViewer().setActiveTool(null);
        }
        super.removeNotify();
    }

    public void setToolSelected(boolean value) {
        this.getButtonModel().setSelected(value);
    }

    @Override
    public void restoreState(IMemento memento) {
        if (Boolean.parseBoolean(memento.getString(ACTIVE_STATE))) {
            this.getViewer().setActiveTool(this.getModel());
        }
        super.restoreState(memento);
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putString(ACTIVE_STATE, Boolean.toString(this.getViewer().getActiveTool() == this.getModel()));
        super.saveState(memento);
    }

    @Override
    protected void setImageInFigure(Image image) {
        DetailedLabelFigure fig = (DetailedLabelFigure)((Object)this.getFigure().getChildren().get(0));
        fig.setImage(image);
    }

    @Override
    public void setSelected(int value) {
        super.setSelected(value);
        if (value == 2 && this.getViewer().getControl() != null && !this.getViewer().getControl().isDisposed() && this.getViewer().getControl().isFocusControl()) {
            this.getFigure().requestFocus();
        }
    }

    @Override
    public void showTargetFeedback(Request request) {
        if ("selection".equals(request.getType())) {
            this.getButtonModel().setMouseOver(true);
        }
        super.showTargetFeedback(request);
    }

    static Rectangle getSelectionRectangle(int layoutMode, DetailedLabelFigure labelFigure) {
        Rectangle rect = Rectangle.SINGLETON;
        rect.setBounds(labelFigure.getBounds());
        if (layoutMode == 0 || layoutMode == 3) {
            rect.x += 9;
            rect.width -= 9;
            int newWidth = labelFigure.getPreferredSize().width + 17;
            if (newWidth < rect.width) {
                rect.width = newWidth;
            }
            rect.shrink(LIST_HIGHLIGHT_INSETS);
        } else {
            rect.width -= 9;
            rect.shrink(ICON_HIGHLIGHT_INSETS);
        }
        return rect;
    }

    class GTKToggleButtonTracker
    extends ToggleButtonTracker {
        int gtkState;

        GTKToggleButtonTracker() {
            this.gtkState = 0;
        }

        @Override
        public void deactivate() {
            this.disableTimer();
            super.deactivate();
        }

        @Override
        protected boolean handleButtonUp(int button) {
            this.disableTimer();
            if (this.gtkState == 1) {
                this.handleNativeDragFinished(null);
                return true;
            }
            if (button == 1) {
                ToolEntryEditPart.this.getButtonModel().setPressed(false);
                ToolEntryEditPart.this.getButtonModel().setArmed(false);
            }
            return super.handleButtonUp(button);
        }

        @Override
        protected boolean handleNativeDragStarted(DragSourceEvent event) {
            this.disableTimer();
            this.gtkState = 1;
            return true;
        }
    }

    class MenuTimer
    implements Runnable {
        public static final int MENU_TIMER_DELAY = 400;
        private boolean enabled = true;

        MenuTimer() {
        }

        public void disable() {
            this.enabled = false;
        }

        @Override
        public void run() {
            if (this.enabled) {
                ToolEntryEditPart.this.getButtonModel().setArmed(false);
                ToolEntryEditPart.this.getButtonModel().setPressed(false);
                ((IPaletteStackEditPart)((Object)ToolEntryEditPart.this.getParent())).openMenu();
                ToolEntryEditPart.this.getViewer().getEditDomain().loadDefaultTool();
            }
        }
    }

    class OtherToggleButtonTracker
    extends ToggleButtonTracker {
        private static final int WIN_THRESHOLD = 3;
        private org.eclipse.swt.graphics.Point mouseDownLoc;

        OtherToggleButtonTracker() {
            this.mouseDownLoc = null;
        }

        @Override
        public void deactivate() {
            this.disableTimer();
            ToolEntryEditPart.this.getButtonModel().setPressed(false);
            ToolEntryEditPart.this.getButtonModel().setArmed(false);
            super.deactivate();
        }

        @Override
        protected boolean handleButtonDown(int button) {
            this.mouseDownLoc = new org.eclipse.swt.graphics.Point(this.getLocation().x, this.getLocation().y);
            return super.handleButtonDown(button);
        }

        @Override
        protected boolean handleButtonUp(int button) {
            this.disableTimer();
            if (button == 1) {
                ToolEntryEditPart.this.getButtonModel().setPressed(false);
                ToolEntryEditPart.this.getButtonModel().setArmed(false);
            }
            return super.handleButtonUp(button);
        }

        @Override
        protected boolean handleNativeDragStarted(DragSourceEvent event) {
            this.disableTimer();
            EditPart editPart = ToolEntryEditPart.this.getParent();
            if (editPart instanceof IPaletteStackEditPart) {
                IPaletteStackEditPart psEP = (IPaletteStackEditPart)((Object)editPart);
                if (SWT.getPlatform().equals("win32")) {
                    org.eclipse.swt.graphics.Point nds = ToolEntryEditPart.this.getViewer().getControl().toControl(event.display.getCursorLocation());
                    if (this.mouseDownLoc != null && Math.abs(nds.x - this.mouseDownLoc.x) + Math.abs(nds.y - this.mouseDownLoc.y) < 3) {
                        ToolEntryEditPart.this.getButtonModel().setArmed(false);
                        ToolEntryEditPart.this.getButtonModel().setPressed(false);
                        psEP.openMenu();
                        ToolEntryEditPart.this.getViewer().getEditDomain().loadDefaultTool();
                        event.doit = false;
                        return false;
                    }
                }
            }
            ToolEntryEditPart.this.getButtonModel().setPressed(false);
            ToolEntryEditPart.this.getButtonModel().setArmed(false);
            return true;
        }
    }

    abstract class ToggleButtonTracker
    extends PaletteEditPart.SingleSelectionTracker {
        private MenuTimer timer;

        ToggleButtonTracker() {
            super(ToolEntryEditPart.this);
            this.timer = null;
        }

        protected void enableTimer() {
            this.timer = new MenuTimer();
            ToolEntryEditPart.this.getViewer().getControl().getDisplay().timerExec(400, (Runnable)this.timer);
        }

        protected void disableTimer() {
            if (this.timer != null) {
                this.timer.disable();
                this.timer = null;
            }
        }

        @Override
        protected boolean handleButtonDown(int button) {
            if (ToolEntryEditPart.this.getParent() instanceof IPaletteStackEditPart) {
                this.enableTimer();
            }
            if (button == 2 && this.isInState(1)) {
                this.performConditionalSelection();
            }
            super.handleButtonDown(button);
            if (button == 1) {
                ToolEntryEditPart.this.getFigure().internalGetEventDispatcher().requestRemoveFocus(ToolEntryEditPart.this.getFigure());
                ToolEntryEditPart.this.getButtonModel().setArmed(true);
                ToolEntryEditPart.this.getButtonModel().setPressed(true);
            }
            return true;
        }

        @Override
        protected boolean handleDrag() {
            Point point = this.getLocation().getCopy();
            ToolEntryEditPart.this.getFigure().translateToRelative((Translatable)point);
            if (!ToolEntryEditPart.this.getFigure().containsPoint(point)) {
                ToolEntryEditPart.this.getButtonModel().setArmed(false);
                ToolEntryEditPart.this.getButtonModel().setMouseOver(false);
                this.disableTimer();
            } else {
                ToolEntryEditPart.this.getButtonModel().setArmed(true);
                ToolEntryEditPart.this.getButtonModel().setMouseOver(true);
            }
            return true;
        }

        @Override
        protected boolean handleNativeDragFinished(DragSourceEvent event) {
            ToolEntryEditPart.this.getViewer().setActiveTool(null);
            return true;
        }
    }

    class ToolEntryToggle
    extends Toggle {
        private boolean showHoverFeedback;

        ToolEntryToggle(IFigure contents) {
            super(contents);
            this.showHoverFeedback = false;
            this.setOpaque(false);
            this.setEnabled(true);
            if (ToolEntryEditPart.this.isToolbarItem()) {
                this.setStyle(Clickable.STYLE_BUTTON | Clickable.STYLE_TOGGLE);
                this.setBorder(TOOLBAR_ITEM_BORDER);
            }
        }

        public boolean containsPoint(int x, int y) {
            Rectangle rect = this.getBounds().getCopy();
            if (ToolEntryEditPart.this.customLabel.getBorder() == ICON_BORDER) {
                rect.width -= 9;
            } else if (ToolEntryEditPart.this.customLabel.getBorder() == LIST_BORDER) {
                rect.width -= 9;
                rect.x += 9;
            }
            return rect.contains(x, y);
        }

        public IFigure findMouseEventTargetAt(int x, int y) {
            return null;
        }

        public IFigure getToolTip() {
            return ToolEntryEditPart.this.createToolTip();
        }

        public void setEnabled(boolean value) {
            super.setEnabled(value);
            if (this.isEnabled()) {
                this.setRolloverEnabled(true);
                if (this.getFlag(STYLE_BUTTON)) {
                    this.setBorder(TOOLBAR_ITEM_BORDER);
                }
                this.setForegroundColor(null);
            } else {
                if (this.getFlag(STYLE_BUTTON)) {
                    this.setBorder(null);
                }
                this.setRolloverEnabled(false);
                this.setForegroundColor(ColorConstants.gray);
            }
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            if (!ToolEntryEditPart.this.isToolbarItem() && this.isEnabled() && this.isRolloverEnabled()) {
                ButtonModel model = this.getModel();
                if (model.isSelected()) {
                    graphics.setBackgroundColor(ToolEntryEditPart.this.getColorProvider().getListSelectedBackgroundColor());
                    graphics.fillRoundRectangle(ToolEntryEditPart.getSelectionRectangle(ToolEntryEditPart.this.getLayoutSetting(), ToolEntryEditPart.this.customLabel), 3, 3);
                } else if (model.isMouseOver() || this.showHoverFeedback) {
                    graphics.setBackgroundColor(ToolEntryEditPart.this.getColorProvider().getListHoverBackgroundColor());
                    graphics.fillRoundRectangle(ToolEntryEditPart.getSelectionRectangle(ToolEntryEditPart.this.getLayoutSetting(), ToolEntryEditPart.this.customLabel), 3, 3);
                }
            }
        }

        protected void paintBorder(Graphics graphics) {
            if (this.isEnabled()) {
                if (this.getBorder() != null) {
                    this.getBorder().paint((IFigure)this, graphics, NO_INSETS);
                }
                if (this.hasFocus()) {
                    Rectangle area;
                    graphics.setForegroundColor(ColorConstants.black);
                    graphics.setBackgroundColor(ColorConstants.white);
                    Rectangle rectangle = area = ToolEntryEditPart.this.isToolbarItem() ? this.getClientArea() : ToolEntryEditPart.getSelectionRectangle(ToolEntryEditPart.this.getLayoutSetting(), ToolEntryEditPart.this.customLabel);
                    if (this.isStyle(STYLE_BUTTON)) {
                        graphics.drawFocus(area.x, area.y, area.width, area.height);
                    } else {
                        graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
                    }
                }
            } else {
                super.paintBorder(graphics);
            }
        }

        public void setShowHoverFeedback(boolean showHoverFeedback) {
            this.showHoverFeedback = showHoverFeedback;
            this.repaint();
        }
    }
}

