/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.examples.jface;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IGraphContentProvider;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;

public class GraphJFaceSnippet3 {
    public static final String GRAPH = "a calls b\na calls c\nb calld d\nb calls e\nc calls f\nc calls g\nd calls h\nd calls i\ne calls j\ne calls k\nf calls l\nf calls m\n";

    public static void main(String[] args) throws IOException {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Simple Graph File Format");
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterNames(new String[]{"Simple Graph Files (*.sgf)", "All Files (*.*)"});
        dialog.setFilterExtensions(new String[]{"*.sgf", "*.*"});
        String directory = System.getProperty("user.dir") + "/src/org/eclipse/zest/tests/jface/SimpleGraph.sgf";
        System.out.println(directory);
        dialog.setFilterPath(directory);
        shell.setLayout((Layout)new FillLayout(512));
        shell.setSize(400, 400);
        GraphViewer viewer = null;
        viewer = new GraphViewer((Composite)shell, 0);
        viewer.setContentProvider((IContentProvider)new SimpleGraphContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setLayoutAlgorithm((LayoutAlgorithm)new RadialLayoutAlgorithm(1));
        shell.open();
        String fileName = dialog.open();
        if (fileName == null) {
            viewer.setInput((Object)GRAPH);
        } else {
            FileReader fileReader = new FileReader(new File(fileName));
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            StringBuilder stringBuffer = new StringBuilder();
            while (bufferedReader.ready()) {
                stringBuffer.append(bufferedReader.readLine() + "\n");
            }
            viewer.setInput((Object)stringBuffer.toString());
        }
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    static class SimpleGraphContentProvider
    implements IGraphContentProvider {
        private StringTokenizer graph;

        SimpleGraphContentProvider() {
        }

        public Object getDestination(Object rel) {
            String string = (String)rel;
            String[] parts = string.split(" ");
            return parts[2];
        }

        public Object[] getElements(Object input) {
            ArrayList<String> listOfEdges = new ArrayList<String>();
            while (this.graph.hasMoreTokens()) {
                listOfEdges.add(this.graph.nextToken());
            }
            return listOfEdges.toArray();
        }

        public Object getSource(Object rel) {
            String string = (String)rel;
            String[] parts = string.split(" ");
            return parts[0];
        }

        public double getWeight(Object connection) {
            return 0.0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.graph = new StringTokenizer((String)newInput, "\n");
            }
        }
    }
}

