/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.IFigureProvider;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.AbstractStylingModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;

public class GraphModelEntityFactory
extends AbstractStylingModelFactory {
    AbstractStructuredGraphViewer viewer = null;

    public GraphModelEntityFactory(AbstractStructuredGraphViewer viewer) {
        super(viewer);
        this.viewer = viewer;
    }

    @Override
    public Graph createGraphModel(Graph model) {
        this.doBuildGraph(model);
        return model;
    }

    @Override
    protected void doBuildGraph(Graph model) {
        super.doBuildGraph(model);
        Object inputElement = this.getViewer().getInput();
        Object[] entities = this.getContentProvider().getElements(inputElement);
        if (entities == null) {
            return;
        }
        Object[] objectArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            Object data = objectArray[n2];
            IFigureProvider figureProvider = null;
            if (this.getLabelProvider() instanceof IFigureProvider) {
                figureProvider = (IFigureProvider)this.getLabelProvider();
            }
            if (!this.filterElement(inputElement, data)) {
                if (figureProvider != null) {
                    this.createNode(model, data, figureProvider.getFigure(data));
                } else {
                    this.createNode(model, data);
                }
            }
            ++n2;
        }
        Set keySet = ((AbstractStructuredGraphViewer)this.getViewer()).getNodesMap().keySet();
        Object[] objectArray2 = entities = keySet.toArray();
        int n3 = entities.length;
        n = 0;
        while (n < n3) {
            Object[] related;
            Object data = objectArray2[n];
            if (!this.filterElement(inputElement, data) && (related = ((IGraphEntityContentProvider)this.getContentProvider()).getConnectedTo(data)) != null) {
                Object[] objectArray3 = related;
                int n4 = related.length;
                int n5 = 0;
                while (n5 < n4) {
                    EntityConnectionData connectionData;
                    Object element = objectArray3[n5];
                    if (!this.filterElement(inputElement, element) && !this.filterElement(inputElement, connectionData = new EntityConnectionData(data, element))) {
                        this.createConnection(model, connectionData, data, element);
                    }
                    ++n5;
                }
            }
            ++n;
        }
    }

    @Override
    public void refresh(Graph graph, Object element, boolean refreshLabels) {
        GraphConnection conn;
        if (element == null) {
            return;
        }
        GraphNode node = this.viewer.getGraphModelNode(element);
        if (node == null && (conn = this.viewer.getGraphModelConnection(element)) != null) {
            this.refresh(graph, conn.getSource().getData(), refreshLabels);
            this.refresh(graph, conn.getDestination().getData(), refreshLabels);
            return;
        }
        if (node == null) {
            return;
        }
        this.reconnect(graph, element, refreshLabels);
        if (refreshLabels) {
            this.update(node);
            Iterator it = node.getSourceConnections().iterator();
            while (it.hasNext()) {
                this.update((GraphItem)((Object)it.next()));
            }
            it = node.getTargetConnections().iterator();
            while (it.hasNext()) {
                this.update((GraphItem)((Object)it.next()));
            }
        }
    }

    private void reconnect(Graph graph, Object element, boolean refreshLabels) {
        GraphNode node = this.viewer.getGraphModelNode(element);
        Object[] related = ((IGraphEntityContentProvider)this.getContentProvider()).getConnectedTo(element);
        List connections = node.getSourceConnections();
        LinkedList toAdd = new LinkedList();
        LinkedList toDelete = new LinkedList();
        LinkedList toKeep = new LinkedList();
        HashSet<Object> oldExternalConnections = new HashSet<Object>();
        HashSet<EntityConnectionData> newExternalConnections = new HashSet<EntityConnectionData>();
        Iterator iterator = connections.iterator();
        while (iterator.hasNext()) {
            oldExternalConnections.add(((GraphConnection)((Object)iterator.next())).getExternalConnection());
        }
        Object[] objectArray = related;
        int n = related.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            newExternalConnections.add(new EntityConnectionData(element, object));
            ++n2;
        }
        for (Object e : oldExternalConnections) {
            if (!newExternalConnections.contains(e)) {
                toDelete.add(e);
                continue;
            }
            toKeep.add(e);
        }
        for (Object e : newExternalConnections) {
            if (oldExternalConnections.contains(e)) continue;
            toAdd.add(e);
        }
        Iterator iterator2 = toDelete.iterator();
        while (iterator2.hasNext()) {
            this.viewer.removeGraphModelConnection(iterator2.next());
        }
        toDelete.clear();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (EntityConnectionData data : toAdd) {
            GraphNode dest = this.viewer.getGraphModelNode(data.dest);
            if (dest == null) {
                linkedList.add(data.dest);
            }
            this.createConnection(graph, data, data.source, data.dest);
        }
        toAdd.clear();
        if (refreshLabels) {
            Iterator i = toKeep.iterator();
            while (i.hasNext()) {
                this.styleItem(this.viewer.getGraphModelConnection(i.next()));
            }
        }
        Iterator it = linkedList.iterator();
        while (it.hasNext()) {
            this.refresh(graph, it.next());
        }
    }

    @Override
    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }
}

