/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.cg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.examples.AbstractExample;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;

public class ObstructionExample
extends AbstractExample {
    static ShortestPathRouter router = new ShortestPathRouter();
    static int COUNT = 0;
    static List sourceList = new ArrayList();
    static List targetList = new ArrayList();
    static Map obstacleMap = new HashMap();
    static List paths = new ArrayList();

    @Override
    protected IFigure getContents() {
        TestFigure f = new TestFigure();
        f.setPreferredSize(900, 700);
        return f;
    }

    public static void main(String[] args) {
        new ObstructionExample().run();
    }

    static class DragFigure
    extends RectangleFigure {
        private static Dimension offset = new Dimension();
        private DragFigure thisFigure = this;

        public DragFigure() {
            this.setBackgroundColor(ColorConstants.green);
            this.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent event) {
                    event.consume();
                    offset.setWidth(event.x - this.getLocation().x());
                    offset.setHeight(event.y - this.getLocation().y());
                }

                public void mouseReleased(MouseEvent event) {
                    offset.setWidth(0);
                    offset.setHeight(0);
                    if (event.button == 3) {
                        this.getParent().remove((IFigure)thisFigure);
                        router.removeObstacle((Rectangle)obstacleMap.get((Object)thisFigure));
                        obstacleMap.remove((Object)thisFigure);
                    }
                }
            });
            this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent event) {
                    Rectangle rect = this.getBounds().getCopy();
                    rect.setX(event.x - offset.width());
                    rect.setY(event.y - offset.height());
                    router.updateObstacle((Rectangle)obstacleMap.get((Object)thisFigure), rect);
                    obstacleMap.put(thisFigure, rect);
                    this.setBounds(rect);
                    this.getParent().repaint();
                }
            });
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Rectangle b = this.getBounds();
            Point p = b.getCenter().translate(-22, -15);
            graphics.drawString("y:" + b.y() + "h:" + b.height(), p);
            p.setY(p.y() + 12);
            graphics.drawString("x:" + b.x() + "w:" + b.width(), p);
        }
    }

    static class EllipseDragFigure
    extends Ellipse {
        protected Point loc;
        protected EllipseDragFigure oFigure;
        protected EllipseDragFigure thisFigure;
        protected boolean isSource;
        protected Path path;
        private static Dimension offset = new Dimension();

        public EllipseDragFigure(Point location, boolean isItSource) {
            this.loc = location;
            this.thisFigure = this;
            this.isSource = isItSource;
            this.setBackgroundColor(ColorConstants.darkBlue);
            this.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent event) {
                    event.consume();
                    offset.setWidth(event.x - this.getLocation().x());
                    offset.setHeight(event.y - this.getLocation().y());
                }

                public void mouseReleased(MouseEvent event) {
                    offset.setWidth(0);
                    offset.setHeight(0);
                    if (event.button == 3) {
                        if (oFigure != null) {
                            this.getParent().remove((IFigure)oFigure);
                            router.removePath(path);
                            paths.remove(path);
                        }
                        this.getParent().remove((IFigure)thisFigure);
                        if (isSource) {
                            sourceList.remove(loc);
                            if (oFigure != null) {
                                targetList.remove(oFigure.loc);
                            }
                        } else {
                            sourceList.remove(oFigure.loc);
                            targetList.remove(loc);
                        }
                    }
                }
            });
            this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent event) {
                    Rectangle rect = this.getBounds().getCopy();
                    rect.setX(event.x - offset.width());
                    rect.setY(event.y - offset.height());
                    this.setBounds(rect);
                    int index = 0;
                    if (isSource) {
                        index = sourceList.indexOf(loc);
                        sourceList.remove(loc);
                        loc = new Point(rect.x() + 10, rect.y() + 10);
                        sourceList.add(index, loc);
                        if (targetList.size() > index) {
                            router.removePath(path);
                            paths.remove(path);
                            path = new Path(loc, (Point)targetList.get(index));
                            router.addPath(path);
                            paths.add(path);
                            oFigure.path = path;
                        }
                    } else {
                        index = targetList.indexOf(loc);
                        router.removePath(path);
                        paths.remove(path);
                        targetList.remove(loc);
                        loc = new Point(rect.x() + 10, rect.y() + 10);
                        targetList.add(index, loc);
                        path = new Path((Point)sourceList.get(index), loc);
                        router.addPath(path);
                        paths.add(path);
                        oFigure.path = path;
                    }
                    this.getParent().repaint();
                }
            });
        }

        public void addOtherFigure(EllipseDragFigure figure) {
            this.oFigure = figure;
        }
    }

    class TestFigure
    extends Figure {
        Map obstacleMap = new HashMap();
        List obstaclesList = new ArrayList();
        boolean showSegs = false;

        public TestFigure() {
            router = new ShortestPathRouter();
            this.addMouseListener((MouseListener)new MouseListener.Stub(){
                private EllipseDragFigure figure;
                private Point pPoint;

                public void mousePressed(MouseEvent event) {
                    event.consume();
                    this.pPoint = event.getLocation();
                }

                public void mouseReleased(MouseEvent event) {
                    if (event.button == 1) {
                        if (Math.abs(this.pPoint.x() - event.getLocation().x()) > 10) {
                            DragFigure f = new DragFigure();
                            TestFigure.this.add((IFigure)f);
                            f.setBounds(new Rectangle(this.pPoint, event.getLocation()));
                            Rectangle bounds = new Rectangle(this.pPoint, event.getLocation());
                            router.addObstacle(bounds);
                            ObstructionExample.obstacleMap.put(f, bounds);
                        }
                    } else if (event.button == 3) {
                        if (sourceList.size() > targetList.size()) {
                            targetList.add(event.getLocation());
                            EllipseDragFigure eFigure = new EllipseDragFigure(event.getLocation(), false);
                            eFigure.setBounds(new Rectangle(event.getLocation().x() - 10, event.getLocation().y() - 10, 20, 20));
                            TestFigure.this.add((IFigure)eFigure);
                            this.figure.addOtherFigure(eFigure);
                            eFigure.addOtherFigure(this.figure);
                            Path path = new Path((Point)sourceList.get(targetList.size() - 1), event.getLocation());
                            router.addPath(path);
                            paths.add(path);
                            eFigure.path = path;
                            this.figure.path = path;
                            this.figure = null;
                            Object var3_6 = null;
                        } else {
                            sourceList.add(event.getLocation());
                            EllipseDragFigure eFigure = new EllipseDragFigure(event.getLocation(), true);
                            eFigure.setBounds(new Rectangle(event.getLocation().x() - 10, event.getLocation().y() - 10, 20, 20));
                            TestFigure.this.add((IFigure)eFigure);
                            this.figure = eFigure;
                        }
                    } else {
                        TestFigure.this.showSegs = !TestFigure.this.showSegs;
                    }
                    TestFigure.this.getParent().repaint();
                }
            });
            Random r = new Random(0L);
            int rowSize = (int)Math.sqrt(COUNT);
            int i = 0;
            while (i < COUNT) {
                DragFigure f = new DragFigure();
                this.add((IFigure)f);
                f.setBounds(new Rectangle(i / rowSize * 101 + i % 3 * 10 + 100, i % rowSize * 101 + i % 7 * 6, 50, 80 + (int)(r.nextDouble() * 10.0)));
                ++i;
            }
            i = 0;
            while (i < COUNT) {
                Rectangle bounds = ((IFigure)this.obstaclesList.get(i)).getBounds().getCopy();
                obstacleMap.put(this.obstaclesList.get(i), bounds);
                router.addObstacle(bounds);
                ++i;
            }
        }

        public void add(IFigure figure, Object constraint, int index) {
            if (figure instanceof DragFigure) {
                this.obstaclesList.add(figure);
            }
            super.add(figure, constraint, index);
        }

        protected void paintBorder(Graphics g) {
            router.solve();
            g.setLineWidth(1);
            g.setForegroundColor(ColorConstants.blue);
            g.setBackgroundColor(ColorConstants.button);
            Path path = null;
            int n = 0;
            while (n < paths.size()) {
                path = (Path)paths.get(n);
                PointList pList = path.getPoints();
                int i = 1;
                while (i < pList.size()) {
                    g.drawLine(pList.getPoint(i - 1), pList.getPoint(i));
                    ++i;
                }
                ++n;
            }
        }

        public void remove(IFigure figure) {
            if (figure instanceof DragFigure) {
                this.obstaclesList.remove(figure);
            }
            super.remove(figure);
            this.repaint();
        }
    }
}

