/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.pinclone.PinCloneUtils;
import org.eclipse.cdt.debug.internal.ui.pinclone.ViewIDCounterManager;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class OpenNewViewAction
extends Action {
    private IViewPart fView;

    public String getText() {
        return ActionMessages.getString("OpenNewViewActionText");
    }

    public String getId() {
        return "org.eclipse.cdt.debug.ui.toolbar.openNewView";
    }

    public String getToolTipText() {
        return ActionMessages.getString("OpenNewViewActionTooltipText");
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return CDebugImages.DESC_LCL_OPEN_NEW_VIEW;
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return CDebugImages.DESC_LCL_OPEN_NEW_VIEW;
    }

    public ImageDescriptor getImageDescriptor() {
        return CDebugImages.DESC_LCL_OPEN_NEW_VIEW;
    }

    public void run() {
        if (this.fView == null) {
            return;
        }
        IViewSite site = this.fView.getViewSite();
        String viewId = site.getId();
        IWorkbenchWindow ww = this.fView.getViewSite().getWorkbenchWindow();
        if (ww != null) {
            IViewReference[] viewRefs;
            Integer secondaryId = null;
            boolean assignSecondaryId = false;
            IViewReference[] iViewReferenceArray = viewRefs = ww.getActivePage().getViewReferences();
            int n = viewRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewRef = iViewReferenceArray[n2];
                if (viewId.equals(viewRef.getId()) && viewRef.getSecondaryId() == null) {
                    assignSecondaryId = true;
                    break;
                }
                ++n2;
            }
            if (assignSecondaryId) {
                secondaryId = ViewIDCounterManager.getInstance().getNextCounter(viewId);
            }
            try {
                ww.getActivePage().showView(viewId, secondaryId != null ? PinCloneUtils.encodeClonedPartSecondaryId(secondaryId.toString()) : null, 1);
            }
            catch (PartInitException e) {
                CDebugUIPlugin.log(e);
            }
        }
    }

    public void init(IViewPart view) {
        this.fView = view;
    }
}

