/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;

public class CPPASTTemplateDeclaration
extends ASTNode
implements ICPPASTInternalTemplateDeclaration,
IASTAmbiguityParent {
    private boolean exported;
    private byte isAssociatedWithLastName = (byte)-1;
    private short nestingLevel = (short)-1;
    private IASTDeclaration declaration;
    private ICPPTemplateScope templateScope;
    private ICPPASTTemplateParameter[] parameters;
    private int parametersPos = -1;

    public CPPASTTemplateDeclaration() {
    }

    public CPPASTTemplateDeclaration(IASTDeclaration declaration) {
        this.setDeclaration(declaration);
    }

    @Override
    public CPPASTTemplateDeclaration copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTTemplateDeclaration copy(IASTNode.CopyStyle style) {
        CPPASTTemplateDeclaration copy = new CPPASTTemplateDeclaration();
        copy.setDeclaration(this.declaration == null ? null : this.declaration.copy(style));
        copy.exported = this.exported;
        ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = this.getTemplateParameters();
        int n = iCPPASTTemplateParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTTemplateParameter param = iCPPASTTemplateParameterArray[n2];
            copy.addTemplateParameter(param == null ? null : param.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public boolean isExported() {
        return this.exported;
    }

    @Override
    public void setExported(boolean value) {
        this.assertNotFrozen();
        this.exported = value;
    }

    @Override
    public IASTDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public void setDeclaration(IASTDeclaration declaration) {
        this.assertNotFrozen();
        this.declaration = declaration;
        if (declaration != null) {
            declaration.setParent(this);
            declaration.setPropertyInParent(OWNED_DECLARATION);
        }
    }

    @Override
    public ICPPASTTemplateParameter[] getTemplateParameters() {
        if (this.parameters == null) {
            return ICPPASTTemplateParameter.EMPTY_TEMPLATEPARAMETER_ARRAY;
        }
        this.parameters = ArrayUtil.trimAt(ICPPASTTemplateParameter.class, this.parameters, this.parametersPos);
        return this.parameters;
    }

    @Override
    public void addTemplateParameter(ICPPASTTemplateParameter parm) {
        this.assertNotFrozen();
        if (parm != null) {
            this.parameters = ArrayUtil.appendAt(ICPPASTTemplateParameter.class, this.parameters, ++this.parametersPos, parm);
            parm.setParent(this);
            parm.setPropertyInParent(PARAMETER);
        }
    }

    @Override
    @Deprecated
    public void addTemplateParamter(ICPPASTTemplateParameter param) {
        this.addTemplateParameter(param);
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        ICPPASTTemplateParameter[] params = this.getTemplateParameters();
        int i = 0;
        while (i < params.length) {
            if (!params[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (this.declaration != null && !this.declaration.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public ICPPTemplateScope getScope() {
        if (this.templateScope == null) {
            this.templateScope = new CPPTemplateScope(this);
        }
        return this.templateScope;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.declaration == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.declaration = (IASTDeclaration)other;
        }
        int i = 0;
        while (i < this.parameters.length) {
            if (child == this.parameters[i]) {
                other.setPropertyInParent(child.getPropertyInParent());
                other.setParent(child.getParent());
                this.parameters[i] = (ICPPASTTemplateParameter)other;
            }
            ++i;
        }
    }

    @Override
    public short getNestingLevel() {
        if (this.nestingLevel == -1) {
            CPPTemplates.associateTemplateDeclarations(this);
        }
        assert (this.nestingLevel != -1);
        return this.nestingLevel;
    }

    @Override
    public boolean isAssociatedWithLastName() {
        if (this.isAssociatedWithLastName == -1) {
            CPPTemplates.associateTemplateDeclarations(this);
        }
        assert (this.isAssociatedWithLastName != -1);
        return this.isAssociatedWithLastName != 0;
    }

    @Override
    public void setAssociatedWithLastName(boolean value) {
        this.isAssociatedWithLastName = value ? (byte)1 : 0;
    }

    @Override
    public void setNestingLevel(short level) {
        assert (level >= 0);
        this.nestingLevel = level;
    }
}

