/// <reference types="node" />
/**
 * This method is providing an automatic operation to including new variables to process.env.
 * Method is not injecting the new variables to current thread, rather it is returning a new
 * object with included parameters.
 *
 * @param source
 * 		Source environment variables to include.
 * @param valuesToMerge
 * 		Key-Value dictionary to include.
 * @return
 * 		New environment variables dictionary.
 */
export declare function createEnvValues(source: NodeJS.ProcessEnv, valuesToMerge: Record<string, string | null>): NodeJS.ProcessEnv;
