/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Transforms;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class SelectTx
extends AnimatingControlsSurface {
    protected static final int RIGHT = 0;
    private static final int LEFT = 1;
    private static final int XMIDDLE = 2;
    private static final int DOWN = 3;
    private static final int UP = 4;
    private static final int YMIDDLE = 5;
    private static final int XupYup = 6;
    private static final int XdownYdown = 7;
    private static final String[] title = new String[]{"Scale", "Shear", "Rotate"};
    protected static final int SCALE = 0;
    protected static final int SHEAR = 1;
    protected static final int ROTATE = 2;
    private Image original;
    private int iw;
    private int ih;
    protected int transformType = 1;
    protected double sx;
    protected double sy;
    protected double angdeg;
    protected int direction = 0;
    protected int transformToggle;

    public SelectTx() {
        this.setBackground(Color.WHITE);
        this.original = this.getImage("painting.png");
        this.iw = this.original.getWidth(this);
        this.ih = this.original.getHeight(this);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    @Override
    public void reset(int w, int h) {
        this.iw = w > 3 ? w / 3 : 1;
        int n = this.ih = h > 3 ? h / 3 : 1;
        if (this.transformType == 0) {
            this.direction = 0;
            this.sy = 1.0;
            this.sx = 1.0;
        } else if (this.transformType == 1) {
            this.direction = 0;
            this.sy = 0.0;
            this.sx = 0.0;
        } else {
            this.angdeg = 0.0;
        }
    }

    @Override
    public void step(int w, int h) {
        int rw = this.iw + 10;
        int rh = this.ih + 10;
        if (this.transformType == 0 && this.direction == 0) {
            this.sx += 0.05;
            if ((double)w * 0.5 - (double)this.iw * 0.5 + (double)rw * this.sx + 10.0 > (double)w) {
                this.direction = 3;
            }
        } else if (this.transformType == 0 && this.direction == 3) {
            this.sy += 0.05;
            if ((double)h * 0.5 - (double)this.ih * 0.5 + (double)rh * this.sy + 20.0 > (double)h) {
                this.direction = 1;
            }
        } else if (this.transformType == 0 && this.direction == 1) {
            this.sx -= 0.05;
            if ((double)rw * this.sx - 10.0 <= -((double)w * 0.5 - (double)this.iw * 0.5)) {
                this.direction = 4;
            }
        } else if (this.transformType == 0 && this.direction == 4) {
            this.sy -= 0.05;
            if ((double)rh * this.sy - 20.0 <= -((double)h * 0.5 - (double)this.ih * 0.5)) {
                this.direction = 0;
                this.transformToggle = 1;
            }
        }
        if (this.transformType == 1 && this.direction == 0) {
            this.sx += 0.05;
            if ((double)rw + (double)(2 * rh) * this.sx + 20.0 > (double)w) {
                this.direction = 1;
                this.sx -= 0.1;
            }
        } else if (this.transformType == 1 && this.direction == 1) {
            this.sx -= 0.05;
            if ((double)rw - (double)(2 * rh) * this.sx + 20.0 > (double)w) {
                this.direction = 2;
            }
        } else if (this.transformType == 1 && this.direction == 2) {
            this.sx += 0.05;
            if (this.sx > 0.0) {
                this.direction = 3;
                this.sx = 0.0;
            }
        } else if (this.transformType == 1 && this.direction == 3) {
            this.sy -= 0.05;
            if ((double)rh - (double)(2 * rw) * this.sy + 20.0 > (double)h) {
                this.direction = 4;
                this.sy += 0.1;
            }
        } else if (this.transformType == 1 && this.direction == 4) {
            this.sy += 0.05;
            if ((double)rh + (double)(2 * rw) * this.sy + 20.0 > (double)h) {
                this.direction = 5;
            }
        } else if (this.transformType == 1 && this.direction == 5) {
            this.sy -= 0.05;
            if (this.sy < 0.0) {
                this.direction = 6;
                this.sy = 0.0;
            }
        } else if (this.transformType == 1 && this.direction == 6) {
            this.sx += 0.05;
            this.sy += 0.05;
            if ((double)rw + (double)(2 * rh) * this.sx + 30.0 > (double)w || (double)rh + (double)(2 * rw) * this.sy + 30.0 > (double)h) {
                this.direction = 7;
            }
        } else if (this.transformType == 1 && this.direction == 7) {
            this.sy -= 0.05;
            this.sx -= 0.05;
            if (this.sy < 0.0) {
                this.direction = 0;
                this.sy = 0.0;
                this.sx = 0.0;
                this.transformToggle = 2;
            }
        }
        if (this.transformType == 2) {
            this.angdeg += 5.0;
            if (this.angdeg == 360.0) {
                this.angdeg = 0.0;
                this.transformToggle = 0;
            }
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        Font font = g2.getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout(title[this.transformType], font, frc);
        g2.setColor(Color.BLACK);
        tl.draw(g2, (float)((double)(w / 2) - tl.getBounds().getWidth() / 2.0), tl.getAscent() + tl.getDescent());
        if (this.transformType == 2) {
            String s = Double.toString(this.angdeg);
            g2.drawString("angdeg=" + s, 2, h - 4);
        } else {
            String s = Double.toString(this.sx);
            s = s.length() < 5 ? s : s.substring(0, 5);
            TextLayout tlsx = new TextLayout("sx=" + s, font, frc);
            tlsx.draw(g2, 2.0f, h - 4);
            s = Double.toString(this.sy);
            s = s.length() < 5 ? s : s.substring(0, 5);
            g2.drawString("sy=" + s, (int)(tlsx.getBounds().getWidth() + 4.0), h - 4);
        }
        if (this.transformType == 0) {
            g2.translate(w / 2 - this.iw / 2, h / 2 - this.ih / 2);
            g2.scale(this.sx, this.sy);
        } else if (this.transformType == 1) {
            g2.translate(w / 2 - this.iw / 2, h / 2 - this.ih / 2);
            g2.shear(this.sx, this.sy);
        } else {
            g2.rotate(Math.toRadians(this.angdeg), w / 2, h / 2);
            g2.translate(w / 2 - this.iw / 2, h / 2 - this.ih / 2);
        }
        g2.setColor(Color.ORANGE);
        g2.fillRect(0, 0, this.iw + 10, this.ih + 10);
        g2.drawImage(this.original, 5, 5, this.iw, this.ih, Color.ORANGE, this);
    }

    public static void main(String[] argv) {
        SelectTx.createDemoFrame(new SelectTx());
    }

    static final class DemoControls
    extends CustomControls
    implements ActionListener {
        SelectTx demo;
        JToolBar toolbar;

        public DemoControls(SelectTx demo) {
            super(demo.name);
            this.demo = demo;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Scale", false);
            this.addTool("Shear", true);
            this.addTool("Rotate", false);
        }

        public void addTool(String str, boolean state) {
            JToggleButton b = (JToggleButton)this.toolbar.add(new JToggleButton(str));
            b.setFocusPainted(false);
            b.setSelected(state);
            b.addActionListener(this);
            int width = b.getPreferredSize().width;
            Dimension prefSize = new Dimension(width, 21);
            b.setPreferredSize(prefSize);
            b.setMaximumSize(prefSize);
            b.setMinimumSize(prefSize);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < this.toolbar.getComponentCount(); ++i) {
                JToggleButton b = (JToggleButton)this.toolbar.getComponentAtIndex(i);
                b.setSelected(false);
            }
            JToggleButton b = (JToggleButton)e.getSource();
            b.setSelected(true);
            if (b.getText().equals("Scale")) {
                this.demo.transformType = 0;
                this.demo.direction = 0;
                this.demo.sy = 1.0;
                this.demo.sx = 1.0;
            } else if (b.getText().equals("Shear")) {
                this.demo.transformType = 1;
                this.demo.direction = 0;
                this.demo.sy = 0.0;
                this.demo.sx = 0.0;
            } else if (b.getText().equals("Rotate")) {
                this.demo.transformType = 2;
                this.demo.angdeg = 0.0;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 39);
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            this.demo.transformToggle = this.demo.transformType;
            while (this.thread == me) {
                try {
                    Thread.sleep(222L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (this.demo.transformToggle == this.demo.transformType) continue;
                ((AbstractButton)this.toolbar.getComponentAtIndex(this.demo.transformToggle)).doClick();
            }
            this.thread = null;
        }
    }
}

