/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import java.util.Objects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public interface BranchToken
extends BranchId,
NamedId {
    public static final String NOT_LOADED_NAME = "Not Loaded";
    public static final BranchToken SENTINEL = BranchToken.create(Id.SENTINEL, "Sentinel");
    public static final int SHORT_NAME_LIMIT = 35;

    public static BranchToken create(BranchId id, String name) {
        if (id instanceof BranchToken) {
            return (BranchToken)id;
        }
        return BranchToken.create(id.getId(), name, ArtifactId.SENTINEL);
    }

    public static BranchToken create(long id, String name) {
        return BranchToken.create(id, name, ArtifactId.SENTINEL);
    }

    public static BranchToken create(Long id, ArtifactId view) {
        return BranchToken.create(id, NOT_LOADED_NAME, view);
    }

    public static BranchToken create(Long id, String name) {
        return BranchToken.create(id, name, ArtifactId.SENTINEL);
    }

    public static BranchToken create(Long id, String name, ArtifactId viewId) {
        Long safeId = Objects.nonNull(id) && id >= -1L ? id : Id.SENTINEL;
        String safeName = Strings.isValidAndNonBlank((String)name) ? name : NOT_LOADED_NAME;
        ArtifactId safeViewId = Objects.nonNull(viewId) ? viewId : ArtifactId.SENTINEL;
        final class BranchTokenImpl
        extends NamedIdBase
        implements BranchToken {
            private final ArtifactId viewId;

            public BranchTokenImpl(Long id, String name, ArtifactId viewId) {
                super(id, name);
                this.viewId = viewId;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof BranchId)) {
                    return false;
                }
                BranchId otherBranchId = (BranchId)obj;
                if (!super.equals((Object)otherBranchId)) {
                    return false;
                }
                ArtifactId otherViewId = otherBranchId.getViewId();
                if (Objects.isNull(this.viewId) && Objects.isNull(otherViewId)) {
                    return true;
                }
                if (Objects.isNull(this.viewId)) {
                    return false;
                }
                return this.viewId.equals(otherViewId);
            }

            @Override
            public ArtifactId getViewId() {
                return this.viewId;
            }

            public String toStringWithId() {
                return String.format("[%s]-[%s]", this.getName(), this.getId());
            }
        }
        return new BranchTokenImpl(safeId, safeName, safeViewId);
    }

    public static BranchToken create(String name) {
        return BranchToken.create(Lib.generateUuid(), name, ArtifactId.SENTINEL);
    }

    public static BranchToken valueOf(BranchId id) {
        if (id instanceof BranchToken) {
            return (BranchToken)id;
        }
        return BranchToken.create(id.getId(), NOT_LOADED_NAME, ArtifactId.SENTINEL);
    }

    default public String getShortName() {
        return this.getShortName(35);
    }

    default public String getShortName(int length) {
        return Strings.truncate((String)this.getName(), (int)length);
    }

    public static String getShortName(String name) {
        return Strings.truncate((String)name, (int)35);
    }
}

