/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.applicability;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.framework.core.applicability.ConfigurationValue;
import org.eclipse.osee.framework.core.applicability.FeatureValue;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;

public class ProductLineConfig {
    private List<FeatureValue> table = new LinkedList<FeatureValue>();
    private final List<ConfigurationValue> headers = new LinkedList<ConfigurationValue>();
    private final List<Integer> headerLengths = new LinkedList<Integer>();

    public ProductLineConfig(List<FeatureValue> table) {
        this.setTable(table);
        List internalHeaders = this.table.stream().flatMap(x -> x.getConfigurationValues().stream()).distinct().sorted(new NamedComparator(SortOrder.ASCENDING)).collect(Collectors.toList());
        List configsInGroups = internalHeaders.stream().flatMap(x -> x.getRelated().stream()).collect(Collectors.toList());
        List groups = internalHeaders.stream().filter(x -> x.getTypeId().equals(CoreArtifactTypes.GroupArtifact)).collect(Collectors.toList());
        for (ConfigurationValue group : groups) {
            List groupHeaders = internalHeaders.stream().filter(x -> x.getId().equals(group.getId()) || group.getRelated().contains(ArtifactId.valueOf(x.getId()))).sorted((a, b) -> Long.valueOf(a.getTypeId().getId() - b.getTypeId().getId()).intValue()).sorted((a, b) -> a.getApplicability().getName().compareTo(b.getApplicability().getName())).collect(Collectors.toList());
            this.headers.addAll(groupHeaders);
            this.headerLengths.add(groupHeaders.size());
        }
        List noConfig = Stream.concat(Stream.of(ConfigurationValue.NO_GROUP), internalHeaders.stream().filter(x -> !configsInGroups.contains(ArtifactId.valueOf(x.getId())) && !x.getTypeId().equals(CoreArtifactTypes.GroupArtifact))).sorted((a, b) -> a.getApplicability().getName().compareTo(b.getApplicability().getName())).collect(Collectors.toList());
        if (noConfig.size() > 1) {
            this.headerLengths.add(noConfig.size() - 1);
            this.headers.addAll(noConfig);
        }
    }

    public ProductLineConfig() {
    }

    public List<FeatureValue> getTable() {
        return this.table;
    }

    public void setTable(List<FeatureValue> table) {
        this.table = table;
    }

    public List<ConfigurationValue> getHeaders() {
        return this.headers;
    }

    public List<Integer> getHeaderLengths() {
        return this.headerLengths;
    }
}

