/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.applicability;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.applicability.BatFile;
import org.eclipse.osee.framework.core.applicability.BatMatchText;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class BatConfigFile
extends BatFile {
    private String name = "";
    private String group = "";
    private final List<String> features = new ArrayList<String>();
    private final List<BatMatchText> substitutions = new ArrayList<BatMatchText>();

    public BatConfigFile() {
    }

    public BatConfigFile(ArtifactReadable configOrGroup, Map<String, List<String>> namedViewApplicabilityMap, List<ArtifactReadable> featureArts) {
        this.setName(configOrGroup.getName().replace(" ", "_"));
        this.addFeatures(featureArts.stream().map(f -> String.valueOf(f.getName()) + "=" + Collections.toString((String)",", (Iterable)((Iterable)namedViewApplicabilityMap.get(f.getName())))).collect(Collectors.toList()));
        ArtifactReadable group = (ArtifactReadable)configOrGroup.getRelated(CoreRelationTypes.PlConfigurationGroup_Group).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (group.isValid()) {
            this.setGroup(group.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String normalizedName) {
        this.name = normalizedName;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void addFeatures(List<String> features) {
        this.features.addAll(features);
    }

    public List<BatMatchText> getSubstitutions() {
        return this.substitutions;
    }

    public void addSubstitutions(List<BatMatchText> substitutions) {
        this.substitutions.addAll(substitutions);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

