/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.CiItemData;
import org.eclipse.osee.disposition.model.CiSetData;
import org.eclipse.osee.disposition.model.CiTestPoint;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;
import org.eclipse.osee.framework.jdk.core.util.Strings;

@Path(value="ci")
@Swagger
public class ContinuousIntegrationResource {
    private final DispoApi dispoApi;

    public ContinuousIntegrationResource(DispoApi dispoApi) {
        this.dispoApi = dispoApi;
    }

    @Path(value="annotations")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get all Dispo Annotations given a CiSetData object")
    @Tags(value={@Tag(name="ci"), @Tag(name="annotations")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public HashMap<String, List<DispoAnnotationData>> getAllDispoAnnotations(CiSetData setData) {
        HashMap<String, List<DispoAnnotationData>> allDispoAnnotations = new HashMap<String, List<DispoAnnotationData>>();
        if (setData != null && Strings.isNumeric((String)setData.getDispoSetId())) {
            List<DispoItem> dispoItems = this.dispoApi.getDispoItems(BranchId.valueOf((String)setData.getBranchId()), setData.getDispoSetId(), false);
            for (DispoItem item : dispoItems) {
                allDispoAnnotations.put(item.getName(), item.getAnnotationsList());
            }
        }
        return allDispoAnnotations;
    }

    @Path(value="{item}/annotation")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get all Dispo Annotations per item given a CiSetData object and specific item")
    @Tags(value={@Tag(name="ci"), @Tag(name="annotations")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public List<DispoAnnotationData> getAllDispoAnnotationsPerItem(CiSetData setData, @Parameter(description="The item name", required=true) @PathParam(value="item") String item) {
        BranchId branch;
        String itemId;
        if (setData != null && (itemId = this.dispoApi.getDispoItemId(branch = BranchId.valueOf((String)setData.getBranchId()), setData.getDispoSetId(), item)) != null && !itemId.isEmpty()) {
            return this.dispoApi.getDispoAnnotations(branch, itemId);
        }
        return null;
    }

    @GET
    @Path(value="sets")
    @Produces(value={"application/json"})
    @Operation(summary="Get all existing CI Sets")
    @Tags(value={@Tag(name="ci"), @Tag(name="sets")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public List<CiSetData> getAllCiSets() {
        return this.dispoApi.getAllCiSets();
    }

    @Path(value="annotate")
    @POST
    @Consumes(value={"application/json"})
    @Operation(summary="Create a Dispo Annotation")
    @Tags(value={@Tag(name="create"), @Tag(name="annotation")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Bad Request")})
    public Response createDispoAnnotation(CiItemData data, @Parameter(description="The Username", required=true) @QueryParam(value="userName") String userName) {
        Response response;
        block6: {
            response = null;
            try {
                response = Response.status((Response.Status)Response.Status.OK).build();
                if (data != null) {
                    BranchId branch = BranchId.valueOf((String)data.getSetData().getBranchId());
                    String itemId = this.dispoApi.getDispoItemId(branch, data.getSetData().getDispoSetId(), data.getScriptName());
                    if (Strings.isInValid((String)itemId)) {
                        this.dispoApi.createDispoItem(branch, data, userName);
                        itemId = this.dispoApi.getDispoItemId(branch, data.getSetData().getDispoSetId(), data.getScriptName());
                    }
                    if (Strings.isValid((String)itemId)) {
                        this.updateDiscrepencies(data, branch, itemId, userName);
                        this.dispoApi.deleteAllDispoAnnotation(branch, itemId, userName, true);
                        response.close();
                        response = this.createAndUpdateAnnotation(data, userName, response, branch, itemId);
                    }
                } else {
                    response.close();
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            catch (Exception exception) {
                if (response == null) break block6;
                response.close();
            }
        }
        return response;
    }

    private void updateDiscrepencies(CiItemData data, BranchId branch, String itemId, String userName) {
        CiTestPoint testPoints = data.getTestPoints();
        DispoItem item = this.dispoApi.getDispoItemById(branch, itemId);
        DispoItemData itemData = DispoUtil.itemArtToItemData(item, true);
        String asRanges = itemData.getDiscrepanciesAsRanges();
        if (!testPoints.getFail().equals(asRanges)) {
            this.removePassing(branch, itemId, userName, testPoints, item);
            this.addFailing(branch, itemId, userName, testPoints, item);
        }
    }

    private void addFailing(BranchId branch, String itemId, String userName, CiTestPoint testPoints, DispoItem item) {
        List<Integer> ranges = DispoUtil.splitDiscrepancyLocations(testPoints.getFail());
        List<String> discrepToAdd = DispoUtil.findMissingDiscrepancyLocs(ranges, item);
        ArrayList<Discrepancy> discrepancies = new ArrayList<Discrepancy>();
        for (String toAdd : discrepToAdd) {
            Discrepancy discrepancy = new Discrepancy();
            discrepancy.setLocation(toAdd);
            discrepancies.add(discrepancy);
        }
        this.dispoApi.createDispoDiscrepancies(branch, itemId, discrepancies, userName);
        this.dispoApi.editDispoDiscrepancies(branch, itemId, discrepancies, userName);
    }

    private void removePassing(BranchId branch, String itemId, String userName, CiTestPoint testPoints, DispoItem item) {
        if (testPoints.getFail().equals("")) {
            for (Discrepancy discrepancy : item.getDiscrepanciesList().values()) {
                this.dispoApi.deleteDispoDiscrepancy(branch, itemId, discrepancy.getId(), userName);
            }
        } else {
            List<Integer> ranges = DispoUtil.splitDiscrepancyLocations(testPoints.getPass());
            List<String> discrepToRemove = DispoUtil.findDiscrepancyLocsToRemove(ranges, item);
            for (String toRemove : discrepToRemove) {
                this.dispoApi.deleteDispoDiscrepancy(branch, itemId, toRemove, userName);
            }
        }
    }

    private Response createAndUpdateAnnotation(CiItemData data, String userName, Response response, BranchId branchId, String itemId) {
        try {
            for (DispoAnnotationData annotation : data.getAnnotations()) {
                DispoAnnotationData temp = new DispoAnnotationData();
                String createdAnnotationId = this.dispoApi.createDispoAnnotation(branchId, itemId, temp, userName, true);
                if (!createdAnnotationId.isEmpty()) {
                    response.close();
                    response = Response.status((Response.Status)Response.Status.OK).build();
                    this.initTempAnnotationData(annotation, temp);
                    boolean wasEdited = this.dispoApi.editDispoAnnotation(branchId, itemId, createdAnnotationId, temp, userName, true);
                    if (wasEdited) {
                        response.close();
                        response = Response.status((Response.Status)Response.Status.OK).build();
                        continue;
                    }
                    response.close();
                    response = Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
                } else {
                    response.close();
                    response = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
                }
                break;
            }
        }
        catch (Exception exception) {
            if (response != null) {
                response.close();
            }
            return null;
        }
        return response;
    }

    private void initTempAnnotationData(DispoAnnotationData annotation, DispoAnnotationData initData) {
        initData.setLocationRefs(annotation.getLocationRefs());
        initData.setResolution(annotation.getResolution());
        initData.setResolutionType(annotation.getResolutionType());
        initData.setLastResolutionType(annotation.getLastResolutionType());
        initData.setLastResolution(annotation.getLastResolution());
        initData.setLastManualResolutionType(annotation.getLastManualResolutionType());
        initData.setLastManualResolution(annotation.getLastManualResolution());
        initData.setCustomerNotes(annotation.getCustomerNotes());
        initData.setDeveloperNotes(annotation.getDeveloperNotes());
    }
}

