/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.synchronization;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.osee.define.rest.api.synchronization.ImportMapping;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class ImportRequest
implements ToMessage {
    private String synchronizationArtifactType;
    private ImportMapping[] importMappings;

    public ImportRequest() {
        this.synchronizationArtifactType = null;
        this.importMappings = null;
    }

    public ImportRequest(String synchronizationArtifactType, ImportMapping[] importMappings) {
        this.synchronizationArtifactType = Objects.requireNonNull(synchronizationArtifactType, "ImportRequest::new, the parameter \"synchronizationArtifactType\" is null.");
        this.importMappings = Objects.requireNonNull(importMappings, "ImportRequest::new, the parameter \"importMappings\" is null.");
    }

    public ImportMapping[] getImportMappings() {
        if (Objects.isNull(this.importMappings)) {
            Message message = new Message().title((CharSequence)"ImportRequest::getImportMappings, the member \"importMappings\" has not been set.").blank();
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        return this.importMappings;
    }

    public String getSynchronizationArtifactType() {
        if (Objects.isNull(this.synchronizationArtifactType)) {
            Message message = new Message().title((CharSequence)"ImportRequest::getSynchronizationArtifactType, the member \"synchronizationArtifactType\" has not been set.").blank();
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        return this.synchronizationArtifactType;
    }

    public boolean isValid() {
        return Objects.nonNull(this.synchronizationArtifactType) && Objects.nonNull(this.importMappings) && !Arrays.stream(this.importMappings).anyMatch(Predicate.not(ImportMapping::isValid));
    }

    public void setImportMappings(ImportMapping[] importMappings) {
        if (Objects.nonNull(this.importMappings)) {
            Message message = new Message().title((CharSequence)"ImportRequest::setImportMappings, the member \"importMappings\" has already been set.").blank();
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        this.importMappings = Objects.requireNonNull(importMappings, "ImportRequest::new, the parameter \"importMappings\" is null.");
    }

    public void setSynchronizationArtifactType(String synchronizationArtifactType) {
        if (Objects.nonNull(this.synchronizationArtifactType)) {
            Message message = new Message().title((CharSequence)"ImportRequest::setSynchronizationArtifactType, the member \"synchronizationArtifactType\" has already been set.").blank();
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        this.synchronizationArtifactType = Objects.requireNonNull(synchronizationArtifactType, "ImportRequest::new, the parameter \"synchronizationArtifactType\" is null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"ImportRequest").indentInc().segment((CharSequence)"synchronizationArtifactType", (Object)this.synchronizationArtifactType).segmentIndexed((CharSequence)"importMappings", (Object[])this.importMappings).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

